/*
 * Decompiled with CFR 0.152.
 */
package io.jsonwebtoken.impl.security;

import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.impl.lang.Bytes;
import io.jsonwebtoken.impl.lang.RequiredParameterReader;
import io.jsonwebtoken.impl.security.AbstractFamilyJwkFactory;
import io.jsonwebtoken.impl.security.AbstractJwk;
import io.jsonwebtoken.impl.security.CryptoAlgorithm;
import io.jsonwebtoken.impl.security.DefaultSecretJwk;
import io.jsonwebtoken.impl.security.JwkContext;
import io.jsonwebtoken.impl.security.KeysBridge;
import io.jsonwebtoken.io.Encoders;
import io.jsonwebtoken.lang.Assert;
import io.jsonwebtoken.lang.Strings;
import io.jsonwebtoken.security.InvalidKeyException;
import io.jsonwebtoken.security.MacAlgorithm;
import io.jsonwebtoken.security.MalformedKeyException;
import io.jsonwebtoken.security.SecretJwk;
import io.jsonwebtoken.security.SecureDigestAlgorithm;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

class SecretJwkFactory
extends AbstractFamilyJwkFactory<SecretKey, SecretJwk> {
    SecretJwkFactory() {
        super("oct", SecretKey.class, DefaultSecretJwk.PARAMS);
    }

    @Override
    protected SecretJwk createJwkFromKey(JwkContext<SecretKey> ctx) {
        String k;
        SecretKey key = (SecretKey)Assert.notNull((Object)ctx.getKey(), (String)"JwkContext key cannot be null.");
        try {
            byte[] encoded = KeysBridge.getEncoded(key);
            k = (String)Encoders.BASE64URL.encode((Object)encoded);
            Assert.hasText((CharSequence)k, (String)"k value cannot be null or empty.");
        }
        catch (Throwable t) {
            String msg = "Unable to encode SecretKey to JWK: " + t.getMessage();
            throw new InvalidKeyException(msg, t);
        }
        ctx.put(DefaultSecretJwk.K.getId(), k);
        return new DefaultSecretJwk(ctx);
    }

    private static void assertKeyBitLength(byte[] bytes, MacAlgorithm alg) {
        long requiredBitLen;
        long bitLen = Bytes.bitLength(bytes);
        if (bitLen != (requiredBitLen = (long)alg.getKeyBitLength())) {
            String msg = "Secret JWK " + AbstractJwk.ALG + " value is '" + alg.getId() + "', but the " + DefaultSecretJwk.K + " length does not equal the '" + alg.getId() + "' length requirement of " + Bytes.bitsMsg(requiredBitLen) + ". This discrepancy could be the result of an algorithm " + "substitution attack or simply an erroneously constructed JWK. In either case, it is likely " + "to result in unexpected or undesired security consequences.";
            throw new MalformedKeyException(msg);
        }
    }

    @Override
    protected SecretJwk createJwkFromValues(JwkContext<SecretKey> ctx) {
        SecureDigestAlgorithm alg;
        RequiredParameterReader reader = new RequiredParameterReader(ctx);
        byte[] bytes = reader.get(DefaultSecretJwk.K);
        String jcaName = null;
        String id = ctx.getAlgorithm();
        if (Strings.hasText((String)id) && (alg = (SecureDigestAlgorithm)Jwts.SIG.get().get((Object)id)) instanceof MacAlgorithm) {
            jcaName = ((CryptoAlgorithm)alg).getJcaName();
            Assert.hasText((CharSequence)jcaName, (String)"Algorithm jcaName cannot be null or empty.");
            SecretJwkFactory.assertKeyBitLength(bytes, (MacAlgorithm)alg);
        }
        if (!Strings.hasText(jcaName)) {
            jcaName = ctx.isSigUse() ? "HmacSHA" + Bytes.bitLength(bytes) : "AES";
        }
        Assert.stateNotNull(jcaName, (String)"jcaName cannot be null (invariant)");
        SecretKeySpec key = new SecretKeySpec(bytes, jcaName);
        ctx.setKey(key);
        return new DefaultSecretJwk(ctx);
    }
}

