/*
 * Decompiled with CFR 0.152.
 */
package uws.job.parameters;

import uws.UWSException;
import uws.job.parameters.InputParamController;

public class StringParamController
implements InputParamController {
    private final String paramName;
    private String defaultValue = null;
    private String[] possibleValues = null;
    private String regexp = null;
    private boolean allowModification = true;

    public StringParamController(String paramName) {
        this(paramName, null, (String[])null, true);
    }

    public StringParamController(String paramName, String defaultValue, String[] possibleValues, boolean allowModif) {
        this.paramName = paramName;
        this.setDefaultValue(defaultValue);
        this.setPossibleValues(possibleValues);
        this.allowModification(allowModif);
    }

    public StringParamController(String paramName, String defaultValue, String regExp, boolean allowModif) {
        this.paramName = paramName;
        this.setDefaultValue(defaultValue);
        this.setRegExp(regExp);
        this.allowModification(allowModif);
    }

    public final String getDefaultValue() {
        return this.defaultValue;
    }

    public final void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public final String getRegExp() {
        return this.regexp;
    }

    public final void setRegExp(String regExp) {
        if (regExp != null && regExp.length() > 0) {
            this.regexp = regExp;
            this.possibleValues = null;
        } else {
            this.regexp = null;
        }
    }

    public final String[] getPossibleValues() {
        return this.possibleValues;
    }

    public final void setPossibleValues(String[] possibleValues) {
        if (possibleValues == null || possibleValues.length == 0) {
            this.possibleValues = null;
        } else {
            this.possibleValues = possibleValues;
            this.regexp = null;
        }
    }

    @Override
    public final boolean allowModification() {
        return this.allowModification;
    }

    public final void allowModification(boolean allowModif) {
        this.allowModification = allowModif;
    }

    @Override
    public Object check(Object value) throws UWSException {
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            String strValue = (String)value;
            if (this.possibleValues != null && this.possibleValues.length > 0) {
                for (String v : this.possibleValues) {
                    if (!strValue.equalsIgnoreCase(v)) continue;
                    return v;
                }
                throw new UWSException(400, "Unknown value for the parameter \"" + this.paramName + "\": \"" + strValue + "\". It should be " + this.getExpectedFormat());
            }
            if (this.regexp != null) {
                if (strValue.matches(this.regexp)) {
                    return strValue;
                }
                throw new UWSException(400, "Incorrect value for the property \"" + this.paramName + "\": \"" + strValue + "\". It should be " + this.getExpectedFormat());
            }
            return strValue;
        }
        throw new UWSException(500, "Wrong type for the parameter \"" + this.paramName + "\": \"" + value.getClass().getName() + "\"! It should be a String.");
    }

    protected final String getExpectedFormat() {
        if (this.possibleValues != null && this.possibleValues.length > 0) {
            StringBuffer buffer = new StringBuffer("a String value among: ");
            for (int i = 0; i < this.possibleValues.length; ++i) {
                buffer.append(i == 0 ? "" : ", ").append(this.possibleValues[i]);
            }
            return buffer.toString();
        }
        if (this.regexp != null) {
            return "a String matching this Regular Expression: " + this.regexp;
        }
        return "a String value.";
    }

    @Override
    public Object getDefault() {
        return this.defaultValue;
    }
}

