/*
 * Decompiled with CFR 0.152.
 */
package it.inaf.ia2.client;

import it.inaf.ia2.client.ClientException;
import it.inaf.ia2.client.HttpErrorLoggingUtils;
import java.net.ConnectException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseClient {
    private static final Logger LOG = LoggerFactory.getLogger(BaseClient.class);
    private final HttpClient wrappedHttpClient;
    private final String baseUrl;

    public BaseClient(String baseUrl) {
        if (baseUrl == null) {
            throw new IllegalArgumentException("Base URL cannot be null");
        }
        this.wrappedHttpClient = HttpClient.newBuilder().followRedirects(HttpClient.Redirect.ALWAYS).version(HttpClient.Version.HTTP_1_1).build();
        if (!((String)baseUrl).endsWith("/")) {
            baseUrl = (String)baseUrl + "/";
        }
        this.baseUrl = baseUrl;
    }

    public HttpRequest.Builder newRequest(String endpoint) {
        return this.newRequest(this.getUri(endpoint));
    }

    public HttpRequest.Builder newRequest(URI uri) {
        return HttpRequest.newBuilder().uri(uri);
    }

    public URI getUri(String endpoint) {
        if (endpoint.startsWith("/")) {
            endpoint = endpoint.substring(1);
        }
        return URI.create(this.baseUrl + endpoint);
    }

    public <T, U> U call(HttpRequest request, HttpResponse.BodyHandler<T> responseBodyHandler, int expectedStatusCode, Function<T, U> responseHandler) {
        try {
            return (U)((CompletableFuture)((CompletableFuture)this.wrappedHttpClient.sendAsync(request, responseBodyHandler).thenApply(response -> {
                if (response.statusCode() == expectedStatusCode) {
                    return response.body();
                }
                HttpErrorLoggingUtils.logServerError(request, response);
                throw new ClientException(this.getInvalidStatusCodeExceptionMessage(request, (HttpResponse)response));
            })).thenApply(response -> responseHandler.apply(response))).join();
        }
        catch (CompletionException ex) {
            if (ex.getCause() != null) {
                if (ex.getCause() instanceof ConnectException) {
                    throw new ClientException("Cannot connect to " + request.uri().getHost() + " on port " + request.uri().getPort());
                }
                if (ex.getCause() instanceof ClientException) {
                    throw (ClientException)ex.getCause();
                }
                LOG.error("Error calling " + request.uri().toString(), ex.getCause());
                throw new ClientException("Error calling " + request.uri().toString(), ex.getCause());
            }
            LOG.error("Error calling " + request.uri().toString(), (Throwable)ex);
            throw new ClientException("Error calling " + request.uri().toString(), ex);
        }
    }

    protected <T> String getInvalidStatusCodeExceptionMessage(HttpRequest request, HttpResponse<T> response) {
        return "Error calling " + request.uri().toString() + ". Server response code is " + response.statusCode();
    }
}

