/*
 * Decompiled with CFR 0.152.
 */
package org.cache2k.core;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.WeakHashMap;
import org.cache2k.Cache;
import org.cache2k.CacheManager;
import org.cache2k.configuration.Cache2kConfiguration;
import org.cache2k.core.CacheManagerImpl;
import org.cache2k.core.DummyConfigurationProvider;
import org.cache2k.core.InternalCache2kBuilder;
import org.cache2k.core.spi.CacheConfigurationProvider;
import org.cache2k.core.util.Cache2kVersion;
import org.cache2k.core.util.Log;
import org.cache2k.spi.Cache2kCoreProvider;
import org.cache2k.spi.Cache2kExtensionProvider;
import org.cache2k.spi.SingleProviderResolver;

public class Cache2kCoreProviderImpl
implements Cache2kCoreProvider {
    public static final String STANDARD_DEFAULT_MANAGER_NAME = "default";
    public static final CacheConfigurationProvider CACHE_CONFIGURATION_PROVIDER = (CacheConfigurationProvider)SingleProviderResolver.resolve(CacheConfigurationProvider.class, DummyConfigurationProvider.class);
    private Object lock = new Object();
    private volatile Map<ClassLoader, String> loader2defaultName = Collections.emptyMap();
    private volatile Map<ClassLoader, Map<String, CacheManager>> loader2name2manager = Collections.emptyMap();
    private String version;

    public Cache2kCoreProviderImpl() {
        this.extractVersionAndGreet();
        this.registerExtensions();
    }

    private void extractVersionAndGreet() {
        Log log = Log.getLog(this.getClass());
        this.version = Cache2kVersion.getVersion();
        StringBuilder sb = new StringBuilder();
        sb.append("cache2k starting. ");
        sb.append("version=");
        sb.append(this.version);
        log.info(sb.toString());
    }

    private void registerExtensions() {
        Iterator<Cache2kExtensionProvider> it = ServiceLoader.load(Cache2kExtensionProvider.class, CacheManager.class.getClassLoader()).iterator();
        while (it.hasNext()) {
            try {
                it.next().registerCache2kExtension();
            }
            catch (ServiceConfigurationError ex) {
                Log.getLog(CacheManager.class.getName()).debug("Error loading cache2k extension", ex);
            }
        }
    }

    public Object getLockObject() {
        return this.lock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDefaultManagerName(ClassLoader cl, String s) {
        Object object = this.getLockObject();
        synchronized (object) {
            if (this.loader2defaultName.containsKey(cl)) {
                throw new IllegalStateException("a CacheManager was already created");
            }
            this.loader2defaultName.put(cl, s);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDefaultManagerName(ClassLoader cl) {
        String n = this.loader2defaultName.get(cl);
        if (n != null) {
            return n;
        }
        Object object = this.getLockObject();
        synchronized (object) {
            n = this.loader2defaultName.get(cl);
            if (n != null) {
                return n;
            }
            n = CACHE_CONFIGURATION_PROVIDER.getDefaultManagerName(cl);
            if (n == null) {
                n = STANDARD_DEFAULT_MANAGER_NAME;
            }
            WeakHashMap<ClassLoader, String> _copy = new WeakHashMap<ClassLoader, String>(this.loader2defaultName);
            _copy.put(cl, n);
            this.loader2defaultName = _copy;
        }
        return n;
    }

    public ClassLoader getDefaultClassLoader() {
        return this.getClass().getClassLoader();
    }

    public CacheManager getManager(ClassLoader cl, String _name) {
        CacheManagerImpl.checkName(_name);
        if (cl == null) {
            throw new NullPointerException("classloader is null");
        }
        return this.getManager(cl, _name, this.getDefaultManagerName(cl).equals(_name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CacheManager getManager(ClassLoader cl, String _name, boolean _default) {
        CacheManager mgr;
        Map<String, CacheManager> _loader2managers = this.loader2name2manager.get(cl);
        if (_loader2managers != null && (mgr = _loader2managers.get(_name)) != null) {
            return mgr;
        }
        Object object = this.getLockObject();
        synchronized (object) {
            _loader2managers = this.loader2name2manager.get(cl);
            if (_loader2managers != null && (mgr = _loader2managers.get(_name)) != null) {
                return mgr;
            }
            _loader2managers = _loader2managers != null ? new HashMap<String, CacheManager>(_loader2managers) : new HashMap<String, CacheManager>();
            mgr = new CacheManagerImpl(this, cl, _name, _default);
            _loader2managers.put(_name, mgr);
            WeakHashMap<ClassLoader, Map<String, CacheManager>> _copy = new WeakHashMap<ClassLoader, Map<String, CacheManager>>(this.loader2name2manager);
            _copy.put(cl, _loader2managers);
            this.loader2name2manager = _copy;
        }
        return mgr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeManager(CacheManager cm) {
        Object object = this.getLockObject();
        synchronized (object) {
            Map<String, CacheManager> _name2managers = this.loader2name2manager.get(cm.getClassLoader());
            _name2managers = new HashMap<String, CacheManager>(_name2managers);
            CacheManager _removed = _name2managers.remove(cm.getName());
            WeakHashMap<ClassLoader, Map<String, CacheManager>> _copy = new WeakHashMap<ClassLoader, Map<String, CacheManager>>(this.loader2name2manager);
            _copy.put(cm.getClassLoader(), _name2managers);
            this.loader2name2manager = _copy;
            if (cm.isDefaultManager()) {
                WeakHashMap<ClassLoader, String> _defaultNameCopy = new WeakHashMap<ClassLoader, String>(this.loader2defaultName);
                _defaultNameCopy.remove(cm.getClassLoader());
                this.loader2defaultName = _defaultNameCopy;
            }
        }
    }

    public void close(ClassLoader l) {
        for (CacheManager cm : this.loader2name2manager.get(l).values()) {
            cm.close();
        }
    }

    public void close() {
        for (ClassLoader cl : this.loader2name2manager.keySet()) {
            this.close(cl);
        }
    }

    public void close(ClassLoader cl, String managerName) {
        Map<String, CacheManager> map;
        if (cl == null) {
            cl = this.getDefaultClassLoader();
        }
        if ((map = this.loader2name2manager.get(cl)) == null) {
            return;
        }
        CacheManager cm = map.get(managerName);
        if (cm == null) {
            return;
        }
        cm.close();
    }

    public <K, V> Cache<K, V> createCache(CacheManager m, Cache2kConfiguration<K, V> cfg) {
        return new InternalCache2kBuilder<K, V>(cfg, m).build();
    }

    public String getVersion() {
        return this.version;
    }

    public Cache2kConfiguration getDefaultConfiguration(CacheManager mgr) {
        return CACHE_CONFIGURATION_PROVIDER.getDefaultConfiguration(mgr);
    }
}

