
import java.util.Map;


class Parser
{

   static String getFirstString(Map<String, String[]> params, String key)
   {
      String[] values = params.get(key);
      if (values == null) return null;

      if (values.length < 1)
         throw new IllegalArgumentException(key + " has no valid value");
      else
         return values[0];// FIXME if values[0] is null -> canot distinguish from key not found
   }


   static String[] getFirstStringArray(Map<String, String[]> params, String key, String separator, int arrayLength)
   {
      String array = getFirstString(params, key);
      if (array == null) return null;

      String[] stringArray = array.split(separator);

      if(stringArray.length != arrayLength)
         throw new IllegalArgumentException(
               key + " parameter has incorrect number of elements (" 
               + stringArray.length + " vs " + arrayLength + ") or incorrect separator used");

      return stringArray;
   }


}
