/*
 * Decompiled with CFR 0.152.
 */
package uws.job.parameters;

import java.io.Serializable;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import uws.ISO8601Format;
import uws.UWSException;
import uws.job.parameters.InputParamController;

public class DestructionTimeController
implements InputParamController,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final int NO_INTERVAL = 0;
    protected Date defaultTime = null;
    protected DateField defaultIntervalField = null;
    protected int defaultInterval = 0;
    protected Date maxTime = null;
    protected DateField maxIntervalField = null;
    protected int maxInterval = 0;
    protected boolean allowModification = true;

    @Override
    public Object check(Object value) throws UWSException {
        if (value == null) {
            return this.getDefault();
        }
        Date date = null;
        if (value instanceof Date) {
            date = (Date)value;
        } else if (value instanceof String) {
            String strValue = (String)value;
            try {
                date = ISO8601Format.parseToDate(strValue);
            }
            catch (ParseException pe) {
                throw new UWSException(400, (Throwable)pe, "Wrong date format for the destruction time parameter: \"" + strValue + "\"! Dates must be formatted in ISO8601 (\"yyyy-MM-dd'T'hh:mm:ss[.sss]['Z'|[+|-]hh:mm]\", fields inside brackets are optional).");
            }
        } else {
            throw new UWSException(500, "Wrong type for the destruction time parameter: class \"" + value.getClass().getName() + "\"! It should be a Date or a string containing a date formatted in IS8601 (\"yyyy-MM-dd'T'hh:mm:ss[.sss]['Z'|[+|-]hh:mm]\", fields inside brackets are optional).");
        }
        Date maxDate = this.getMaxDestructionTime();
        if (maxDate != null && date.after(maxDate)) {
            date = maxDate;
        }
        return date;
    }

    @Override
    public Object getDefault() {
        Date defaultDate = this.getDefaultDestructionTime();
        return defaultDate == null ? this.getMaxDestructionTime() : defaultDate;
    }

    public final Date getDefaultDestructionTime() {
        if (this.defaultInterval > 0) {
            Calendar date = Calendar.getInstance();
            try {
                date.add(this.defaultIntervalField.getFieldIndex(), this.defaultInterval);
                return date.getTime();
            }
            catch (ArrayIndexOutOfBoundsException ex) {
                return null;
            }
        }
        return this.defaultTime;
    }

    public final void setDefaultDestructionTime(Date defaultDestructionTime) {
        this.defaultTime = defaultDestructionTime;
        this.defaultInterval = 0;
        this.defaultIntervalField = null;
    }

    public final int getDefaultDestructionInterval() {
        return this.defaultInterval;
    }

    public final DateField getDefaultIntervalField() {
        return this.defaultIntervalField;
    }

    public final void setDefaultDestructionInterval(int defaultDestructionInterval) {
        this.setDefaultDestructionInterval(defaultDestructionInterval, DateField.MINUTE);
    }

    public final void setDefaultDestructionInterval(int defaultDestructionInterval, DateField timeField) {
        if (defaultDestructionInterval <= 0 || timeField == null) {
            this.defaultIntervalField = null;
            this.defaultInterval = 0;
        } else {
            this.defaultIntervalField = timeField;
            this.defaultInterval = defaultDestructionInterval;
        }
        this.defaultTime = null;
    }

    public final Date getMaxDestructionTime() {
        if (this.maxInterval > 0) {
            Calendar date = Calendar.getInstance();
            try {
                date.add(this.maxIntervalField.getFieldIndex(), this.maxInterval);
                return date.getTime();
            }
            catch (ArrayIndexOutOfBoundsException ex) {
                return null;
            }
        }
        return this.maxTime;
    }

    public final void setMaxDestructionTime(Date maxDestructionTime) {
        this.maxTime = maxDestructionTime;
        this.maxInterval = 0;
        this.maxIntervalField = null;
    }

    public final int getMaxDestructionInterval() {
        return this.maxInterval;
    }

    public final DateField getMaxIntervalField() {
        return this.maxIntervalField;
    }

    public final void setMaxDestructionInterval(int maxDestructionInterval) {
        this.setMaxDestructionInterval(maxDestructionInterval, DateField.MINUTE);
    }

    public final void setMaxDestructionInterval(int maxDestructionInterval, DateField timeField) {
        if (maxDestructionInterval <= 0 || timeField == null) {
            this.maxInterval = 0;
            this.maxIntervalField = null;
            this.maxTime = null;
        } else {
            this.maxInterval = maxDestructionInterval;
            this.maxIntervalField = timeField;
            this.maxTime = null;
        }
    }

    @Override
    public final boolean allowModification() {
        return this.allowModification;
    }

    public final void allowModification(boolean allowModification) {
        this.allowModification = allowModification;
    }

    public static enum DateField {
        SECOND(13),
        MINUTE(12),
        HOUR(10),
        DAY(5),
        MONTH(2),
        YEAR(1);

        private final int index;

        private DateField(int fieldIndex) {
            this.index = fieldIndex;
        }

        public final int getFieldIndex() {
            return this.index;
        }
    }
}

