/*
 * Decompiled with CFR 0.152.
 */
package vo.parameter;

import java.util.Map;
import java.util.logging.Logger;
import vo.parameter.Circle;
import vo.parameter.Parser;
import vo.parameter.Polygon;
import vo.parameter.Range;

public class Pos {
    private static final String ARG_POS = "POS";
    private static final String ARG_CIRCLE = "CIRCLE";
    private static final String ARG_POLYGON = "POLYGON";
    private static final String ARG_POSSYS = "POSSYS";
    protected static final Logger LOGGER = Logger.getLogger("Pos");
    public System system;
    public Shape shape;
    public Circle circle;
    public Range range;
    public Polygon polygon;

    public static Pos parsePos(Map<String, String[]> params, String defaultSystem) {
        String valuePos = Parser.getSingleValue(params, ARG_POS);
        String valueCircle = Parser.getSingleValue(params, ARG_CIRCLE);
        String valuePolygon = Parser.getSingleValue(params, ARG_POLYGON);
        String valuePosSystem = Parser.getSingleValue(params, ARG_POSSYS);
        if (valuePosSystem == null) {
            valuePosSystem = Parser.getSingleValue(params, "skysystem", defaultSystem);
        }
        Pos pos = null;
        if (valuePos != null && valueCircle == null && valuePolygon == null) {
            pos = new Pos(valuePos, valuePosSystem);
            LOGGER.info(pos.toString());
        } else if (valuePos == null && valueCircle != null && valuePolygon == null) {
            Circle circle = new Circle(valueCircle);
            LOGGER.info(circle.toString());
            pos = new Pos(circle, valuePosSystem);
        } else if (valuePos == null && valueCircle == null && valuePolygon != null) {
            Polygon polygon = new Polygon(valuePolygon);
            LOGGER.info(polygon.toString());
            pos = new Pos(polygon, valuePosSystem);
        } else if (valuePos == null && valueCircle == null && valuePolygon == null) {
            pos = Pos.vlkbReq_getCircleRect(params, valuePosSystem);
        } else {
            throw new IllegalArgumentException("Exactly one of POS | CIRCLE | POLYGON must be given.");
        }
        return pos;
    }

    public Pos(String value, String valuePosSystem) {
        LOGGER.info("trace: " + value);
        this.parsePos(value);
        this.system = System.valueOf(valuePosSystem);
    }

    public Pos(Circle circle, String valuePosSystem) {
        this.shape = Shape.CIRCLE;
        this.circle = circle;
        this.system = System.valueOf(valuePosSystem);
    }

    public Pos(Range range, String valuePosSystem) {
        this.shape = Shape.RANGE;
        this.range = range;
        this.system = System.valueOf(valuePosSystem);
    }

    public Pos(Polygon polygon, String valuePosSystem) {
        this.shape = Shape.POLYGON;
        this.polygon = polygon;
        this.system = System.valueOf(valuePosSystem);
    }

    private void parsePos(String str) {
        String[] strArr = str.strip().split(" +", 2);
        if (strArr.length <= 1) {
            throw new IllegalArgumentException("POS value must have more then one space-separated elements but had " + strArr.length + " elements)");
        }
        this.shape = Shape.valueOf(strArr[0].strip());
        String value = strArr[1].strip();
        switch (this.shape) {
            case CIRCLE: {
                this.circle = new Circle(value);
                break;
            }
            case RANGE: {
                this.range = new Range(value);
                break;
            }
            case POLYGON: {
                this.polygon = new Polygon(value);
                break;
            }
            default: {
                throw new IllegalArgumentException("Valid POS shape is CIRCLE or RANGE or POLYGON but was: " + this.shape.toString());
            }
        }
    }

    public void setSystem(String strSystem) {
        this.system = System.valueOf(strSystem);
    }

    public String toString() {
        return "POS=" + (switch (this.shape) {
            case Shape.CIRCLE -> this.circle.toString();
            case Shape.RANGE -> this.range.toString();
            case Shape.POLYGON -> this.polygon.toString();
            default -> throw new IllegalArgumentException("Valid POS shape is CIRCLE or RANGE or POLYGON but was: " + this.shape.toString());
        }) + "&POSSYS=" + this.system.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Pos vlkbReq_getCircleRect(Map<String, String[]> params, String valuePosSystem) {
        Pos pos = null;
        String l_value = Parser.getSingleValue(params, "l");
        String b_value = Parser.getSingleValue(params, "b");
        if (l_value != null && b_value != null) {
            String r_value = Parser.getSingleValue(params, "r");
            if (r_value != null) {
                Circle circle = new Circle(l_value + " " + b_value + " " + r_value);
                return new Pos(circle, valuePosSystem);
            }
            String dl_value = Parser.getSingleValue(params, "dl");
            String db_value = Parser.getSingleValue(params, "db");
            if (dl_value == null) throw new IllegalArgumentException("one of 'r' or '(dl,db)' pair must be provided to designate sky area");
            if (db_value == null) throw new IllegalArgumentException("one of 'r' or '(dl,db)' pair must be provided to designate sky area");
            double l = Double.parseDouble(l_value);
            double b = Double.parseDouble(b_value);
            double dl = Double.parseDouble(dl_value);
            double db = Double.parseDouble(db_value);
            Range range = new Range(l, b, dl, db);
            return new Pos(range, valuePosSystem);
        }
        if (l_value != null) {
            if (b_value == null) throw new IllegalArgumentException("VLKB sky position center (l,b): l or b is missing");
        }
        if (l_value != null) return pos;
        if (b_value == null) return pos;
        throw new IllegalArgumentException("VLKB sky position center (l,b): l or b is missing");
    }

    public static enum System {
        NONE,
        ICRS,
        GALACTIC;

    }

    public static enum Shape {
        CIRCLE,
        RANGE,
        POLYGON;

    }
}

