/*
 * Decompiled with CFR 0.152.
 */
package uws.service.file;

import java.io.File;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import uws.job.user.JobOwner;
import uws.service.file.OwnerGroupIdentifier;

public class DefaultOwnerGroupIdentifier
implements OwnerGroupIdentifier {
    protected static final Pattern DIR_PREFIX_PATTERN = Pattern.compile(".*([a-zA-Z])[^a-zA-Z]*");

    @Override
    public String getOwnerGroup(JobOwner owner) {
        if (owner == null || owner.getID() == null || owner.getID().trim().isEmpty()) {
            return null;
        }
        String userDir = owner.getID().trim().replaceAll(Pattern.quote(File.separator), "_");
        String parentDir = "_";
        Matcher m = DIR_PREFIX_PATTERN.matcher(userDir);
        if (m.matches()) {
            parentDir = m.group(1).toLowerCase();
        }
        return parentDir;
    }
}

