/*
 * Decompiled with CFR 0.152.
 */
package uws.service.file;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.regex.Pattern;
import uws.UWSException;
import uws.UWSToolBox;
import uws.job.ErrorSummary;
import uws.job.Result;
import uws.job.UWSJob;
import uws.job.user.JobOwner;
import uws.service.file.DefaultOwnerGroupIdentifier;
import uws.service.file.EventFrequency;
import uws.service.file.OwnerGroupIdentifier;
import uws.service.file.UWSFileManager;
import uws.service.file.UnsupportedURIProtocolException;
import uws.service.file.io.OutputStreamWithCloseAction;
import uws.service.file.io.RotateFileAction;
import uws.service.log.UWSLog;
import uws.service.request.UploadFile;

public class LocalUWSFileManager
implements UWSFileManager {
    private DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
    protected static final String DEFAULT_LOG_FILE_NAME = "service.log";
    protected static final String DEFAULT_BACKUP_FILE_NAME = "service.backup";
    protected final File rootDirectory;
    protected File tmpDirectory = new File(System.getProperty("java.io.tmpdir"));
    protected PrintWriter logOutput = null;
    protected EventFrequency logRotation = new EventFrequency("D 0 0");
    protected final boolean oneDirectoryForEachUser;
    protected final boolean groupUserDirectories;
    protected final OwnerGroupIdentifier ownerGroupId;

    public LocalUWSFileManager(File root) throws UWSException {
        this(root, true, true, null);
    }

    public LocalUWSFileManager(File root, boolean oneDirectoryForEachUser, boolean groupUserDirectories) throws UWSException {
        this(root, oneDirectoryForEachUser, groupUserDirectories, null);
    }

    public LocalUWSFileManager(File root, boolean oneDirectoryForEachUser, boolean groupUserDirectories, OwnerGroupIdentifier ownerGroupIdentifier) throws UWSException {
        if (root == null) {
            throw new NullPointerException("Missing root directory ! Impossible to create a LocalUWSFileManager.");
        }
        if (!root.exists()) {
            if (!root.mkdirs()) {
                throw new UWSException(500, "The given root directory does not exist and can not be created automatically !");
            }
        } else {
            if (!root.isDirectory()) {
                throw new UWSException(500, "The root directory of a UWSFileManager must be a DIRECTORY !");
            }
            if (!root.canRead()) {
                throw new UWSException(500, "Missing READ permission for the root directory of a UWSFileManager !");
            }
            if (!root.canWrite()) {
                throw new UWSException(500, "Missing WRITE permission for the root directory of a UWSFileManager !");
            }
        }
        this.rootDirectory = root;
        this.oneDirectoryForEachUser = oneDirectoryForEachUser;
        if (this.oneDirectoryForEachUser) {
            this.groupUserDirectories = groupUserDirectories;
            this.ownerGroupId = this.groupUserDirectories ? (ownerGroupIdentifier != null ? ownerGroupIdentifier : new DefaultOwnerGroupIdentifier()) : null;
        } else {
            this.groupUserDirectories = false;
            this.ownerGroupId = null;
        }
    }

    public File getOwnerDirectory(JobOwner owner) {
        String ownerGroup;
        if (!this.oneDirectoryForEachUser || owner == null || owner.getID() == null || owner.getID().trim().isEmpty()) {
            return this.rootDirectory;
        }
        File ownerDir = this.rootDirectory;
        if (this.groupUserDirectories && (ownerGroup = this.ownerGroupId.getOwnerGroup(owner)) != null) {
            ownerDir = new File(this.rootDirectory, ownerGroup);
        }
        ownerDir = new File(ownerDir, owner.getID().replaceAll(Pattern.quote(File.separator), "_"));
        return ownerDir;
    }

    protected void cleanOwnerDirectory(JobOwner owner) throws IOException {
        File ownerDir;
        String[] dirContent;
        if (owner != null && this.oneDirectoryForEachUser && (dirContent = (ownerDir = this.getOwnerDirectory(owner)).list()).length <= 1) {
            File userGroupDir;
            if (dirContent.length == 1 && dirContent[0].equals(this.getBackupFileName(owner))) {
                new File(this.rootDirectory, this.getBackupFileName(owner)).delete();
                dirContent = ownerDir.list();
            }
            if (dirContent.length == 0 && ownerDir.delete() && this.groupUserDirectories && (userGroupDir = ownerDir.getParentFile()).list().length == 0) {
                userGroupDir.delete();
            }
        }
    }

    public final String getLogRotationFreq() {
        return this.logRotation.toString();
    }

    public final void setLogRotationFreq(String interval) {
        this.logRotation = new EventFrequency(interval);
    }

    protected String getLogFileName(UWSLog.LogLevel level, String context) {
        return DEFAULT_LOG_FILE_NAME;
    }

    protected File getLogFile(UWSLog.LogLevel level, String context) {
        return new File(this.rootDirectory, this.getLogFileName(level, context));
    }

    @Override
    public InputStream getLogInput(UWSLog.LogLevel level, String context) throws IOException {
        File logFile = this.getLogFile(level, context);
        if (logFile.exists()) {
            return new FileInputStream(logFile);
        }
        return null;
    }

    @Override
    public synchronized PrintWriter getLogOutput(UWSLog.LogLevel level, String context) throws IOException {
        File logFile;
        if (this.logOutput != null && this.logRotation != null && this.logRotation.isTimeElapsed()) {
            this.logOutput.close();
            this.logOutput = null;
            logFile = this.getLogFile(level, context);
            String logFileName = logFile.getName();
            String fileExt = "";
            int indFileExt = logFileName.lastIndexOf(46);
            if (indFileExt >= 0) {
                fileExt = logFileName.substring(indFileExt);
                logFileName = logFileName.substring(0, indFileExt);
            }
            logFile.renameTo(new File(logFile.getParentFile(), logFileName + "_" + this.logRotation.getEventID() + fileExt));
        }
        if (this.logOutput == null) {
            logFile = this.getLogFile(level, context);
            this.createParentDir(logFile);
            this.logOutput = new PrintWriter(new FileOutputStream(logFile, true), true);
            this.printLogHeader(this.logOutput);
            if (this.logRotation != null) {
                this.logRotation.nextEvent();
            }
        }
        return this.logOutput;
    }

    protected void printLogHeader(PrintWriter out) {
        String msgHeader = "########################################### LOG STARTS " + this.dateFormat.format(new Date()) + " (file rotation: " + this.logRotation + ") ###########################################";
        StringBuffer buf = new StringBuffer("");
        for (int i = 0; i < msgHeader.length(); ++i) {
            buf.append('#');
        }
        String separator = buf.toString();
        out.println(separator);
        out.println(msgHeader);
        out.println(separator);
        out.flush();
    }

    protected final File getFile(UploadFile upload) {
        if (upload.getLocation().startsWith("file:")) {
            try {
                return new File(new URI(upload.getLocation()));
            }
            catch (URISyntaxException use) {
                return new File(upload.getLocation());
            }
        }
        return new File(upload.getLocation());
    }

    @Override
    public File getTmpDirectory() {
        return this.tmpDirectory;
    }

    @Override
    public boolean setTmpDirectory(File newTmpDir) {
        if (!(newTmpDir != null && newTmpDir.exists() && newTmpDir.isDirectory() && newTmpDir.canRead() && newTmpDir.canWrite())) {
            return false;
        }
        this.tmpDirectory = newTmpDir;
        return true;
    }

    @Override
    public InputStream getUploadInput(UploadFile upload) throws IOException {
        File source = this.getFile(upload);
        if (!source.exists()) {
            throw new FileNotFoundException("The uploaded file submitted with the parameter \"" + upload.paramName + "\" can not be found any more on the server!");
        }
        return new FileInputStream(source);
    }

    @Override
    public InputStream openURI(URI uri) throws UnsupportedURIProtocolException, IOException {
        String scheme = uri.getScheme();
        if (scheme.equalsIgnoreCase("http") || scheme.equalsIgnoreCase("ftp")) {
            return uri.toURL().openStream();
        }
        throw new UnsupportedURIProtocolException(uri);
    }

    @Override
    public void deleteUpload(UploadFile upload) throws IOException {
        File f = this.getFile(upload);
        if (!f.exists()) {
            return;
        }
        if (f.isDirectory()) {
            throw new IOException("Incorrect location! An uploaded file must be a regular file, not a directory. (file location: \"" + f.getPath() + "\")");
        }
        try {
            if (!f.delete()) {
                throw new IOException("Can not delete the file!");
            }
        }
        catch (SecurityException se) {
            throw new IOException("Unexpected permission restriction on the uploaded file \"" + f.getPath() + "\" => can not delete it!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String moveUpload(UploadFile upload, UWSJob destination) throws IOException {
        File source = this.getFile(upload);
        if (!source.exists()) {
            throw new FileNotFoundException("The uploaded file submitted with the parameter \"" + upload.paramName + "\" can not be found any more on the server!");
        }
        File ownerDir = this.getOwnerDirectory(destination.getOwner());
        File copy = new File(ownerDir, "UPLOAD_" + destination.getJobId() + "_" + upload.paramName);
        OutputStream output = null;
        BufferedInputStream input = null;
        boolean done = false;
        try {
            int len;
            input = new BufferedInputStream(this.getUploadInput(upload));
            output = new BufferedOutputStream(new FileOutputStream(copy));
            byte[] buffer = new byte[2048];
            while ((len = ((InputStream)input).read(buffer)) > 0) {
                output.write(buffer, 0, len);
            }
            output.flush();
            output.close();
            output = null;
            ((InputStream)input).close();
            input = null;
            source.delete();
            done = true;
            String string = copy.toURI().toString();
            return string;
        }
        finally {
            if (output != null) {
                try {
                    output.close();
                }
                catch (IOException iOException) {}
            }
            if (input != null) {
                try {
                    ((InputStream)input).close();
                }
                catch (IOException iOException) {}
            }
            if (!done && copy.exists()) {
                try {
                    copy.delete();
                }
                catch (SecurityException securityException) {}
            }
        }
    }

    protected String getResultFileName(Result result, UWSJob job) {
        String fileName = job.getJobId() + "_";
        fileName = result != null && result.getId() != null && !result.getId().trim().isEmpty() ? fileName + result.getId() : fileName + "result";
        String fileExt = UWSToolBox.getFileExtension(result.getMimeType());
        fileExt = fileExt == null ? "" : "." + fileExt;
        fileName = fileName + fileExt;
        return fileName;
    }

    protected File getResultFile(Result result, UWSJob job) {
        File ownerDir = this.getOwnerDirectory(job.getOwner());
        return new File(ownerDir, this.getResultFileName(result, job));
    }

    @Override
    public InputStream getResultInput(Result result, UWSJob job) throws IOException {
        File resultFile = this.getResultFile(result, job);
        return resultFile.exists() ? new FileInputStream(resultFile) : null;
    }

    @Override
    public OutputStream getResultOutput(Result result, UWSJob job) throws IOException {
        File resultFile = this.getResultFile(result, job);
        this.createParentDir(resultFile);
        return new FileOutputStream(resultFile);
    }

    @Override
    public long getResultSize(Result result, UWSJob job) throws IOException {
        File resultFile = this.getResultFile(result, job);
        if (resultFile == null || !resultFile.exists()) {
            return -1L;
        }
        return resultFile.length();
    }

    @Override
    public boolean deleteResult(Result result, UWSJob job) throws IOException {
        boolean deleted = this.getResultFile(result, job).delete();
        if (deleted) {
            this.cleanOwnerDirectory(job.getOwner());
        }
        return deleted;
    }

    protected String getErrorFileName(ErrorSummary error, UWSJob job) {
        return job.getJobId() + "_ERROR.log";
    }

    protected File getErrorFile(ErrorSummary error, UWSJob job) {
        File ownerDir = this.getOwnerDirectory(job.getOwner());
        return new File(ownerDir, this.getErrorFileName(error, job));
    }

    @Override
    public InputStream getErrorInput(ErrorSummary error, UWSJob job) throws IOException {
        File errorFile = this.getErrorFile(error, job);
        return errorFile.exists() ? new FileInputStream(errorFile) : null;
    }

    @Override
    public OutputStream getErrorOutput(ErrorSummary error, UWSJob job) throws IOException {
        File errorFile = this.getErrorFile(error, job);
        this.createParentDir(errorFile);
        return new FileOutputStream(errorFile);
    }

    @Override
    public long getErrorSize(ErrorSummary error, UWSJob job) throws IOException {
        File errorFile = this.getErrorFile(error, job);
        if (errorFile == null || !errorFile.exists()) {
            return -1L;
        }
        return errorFile.length();
    }

    @Override
    public boolean deleteError(ErrorSummary error, UWSJob job) throws IOException {
        boolean deleted = this.getErrorFile(error, job).delete();
        if (deleted) {
            this.cleanOwnerDirectory(job.getOwner());
        }
        return deleted;
    }

    protected String getBackupFileName(JobOwner owner) throws IllegalArgumentException {
        if (owner == null || owner.getID() == null || owner.getID().trim().isEmpty()) {
            throw new IllegalArgumentException("Missing owner! Can not get the backup file of an unknown owner.");
        }
        return owner.getID().replaceAll(Pattern.quote(File.separator), "_") + ".backup";
    }

    @Override
    public InputStream getBackupInput(JobOwner owner) throws IllegalArgumentException, IOException {
        File backupFile = new File(this.getOwnerDirectory(owner), this.getBackupFileName(owner));
        return backupFile.exists() ? new FileInputStream(backupFile) : null;
    }

    @Override
    public Iterator<InputStream> getAllUserBackupInputs() {
        return new LocalAllUserBackupInputs(this);
    }

    @Override
    public OutputStream getBackupOutput(JobOwner owner) throws IllegalArgumentException, IOException {
        File backupFile = new File(this.getOwnerDirectory(owner), this.getBackupFileName(owner));
        File tempBackupFile = new File(this.getOwnerDirectory(owner), this.getBackupFileName(owner) + ".temp-" + System.currentTimeMillis());
        this.createParentDir(backupFile);
        return new OutputStreamWithCloseAction(new FileOutputStream(tempBackupFile), new RotateFileAction(tempBackupFile, backupFile));
    }

    protected String getBackupFileName() {
        return DEFAULT_BACKUP_FILE_NAME;
    }

    @Override
    public InputStream getBackupInput() throws IOException {
        File backupFile = new File(this.rootDirectory, this.getBackupFileName());
        return backupFile.exists() ? new FileInputStream(backupFile) : null;
    }

    @Override
    public OutputStream getBackupOutput() throws IOException {
        File backupFile = new File(this.rootDirectory, this.getBackupFileName());
        File tempBackupFile = new File(this.rootDirectory, this.getBackupFileName() + ".temp-" + System.currentTimeMillis());
        this.createParentDir(backupFile);
        return new OutputStreamWithCloseAction(new FileOutputStream(tempBackupFile), new RotateFileAction(tempBackupFile, backupFile));
    }

    protected boolean createParentDir(File f) {
        if (!f.getParentFile().exists()) {
            return f.getParentFile().mkdirs();
        }
        return true;
    }

    protected final class OwnerFileFilter
    implements FileFilter {
        protected String ownerID = null;

        protected OwnerFileFilter() {
        }

        public void setOwnerID(String ownerID) {
            this.ownerID = ownerID;
        }

        @Override
        public boolean accept(File f) {
            if (f == null || f.isDirectory()) {
                return false;
            }
            if (this.ownerID == null || this.ownerID.trim().isEmpty()) {
                return f.getName().endsWith(".backup") && !f.getName().equalsIgnoreCase(LocalUWSFileManager.this.getBackupFileName());
            }
            return f.getName().equalsIgnoreCase(this.ownerID + ".backup");
        }
    }

    protected static final class DirectoryFilter
    implements FileFilter {
        protected DirectoryFilter() {
        }

        @Override
        public boolean accept(File f) {
            return f != null && f.isDirectory();
        }
    }

    protected class LocalAllUserBackupInputs
    implements Iterator<InputStream> {
        private final LocalUWSFileManager fileManager;
        private Iterator<File> itBackupFiles;
        private final FileFilter dirFilter = new DirectoryFilter();
        private final OwnerFileFilter ownerFileFilter = new OwnerFileFilter();

        public LocalAllUserBackupInputs(LocalUWSFileManager fm) {
            this.fileManager = fm;
            this.itBackupFiles = this.loadAllBackupFiles().iterator();
        }

        private List<File> loadAllBackupFiles() {
            ArrayList<File> backupFiles = new ArrayList<File>();
            if (this.fileManager.oneDirectoryForEachUser) {
                File[] dir0 = this.fileManager.rootDirectory.listFiles(this.dirFilter);
                if (this.fileManager.groupUserDirectories) {
                    for (File groupDir : dir0) {
                        File[] dir1;
                        for (File userDir : dir1 = groupDir.listFiles(this.dirFilter)) {
                            this.addOwnerBackupFiles(backupFiles, userDir, userDir.getName());
                        }
                    }
                } else {
                    for (File userDir : dir0) {
                        this.addOwnerBackupFiles(backupFiles, userDir, userDir.getName());
                    }
                }
            } else {
                this.addOwnerBackupFiles(backupFiles, this.fileManager.rootDirectory, null);
            }
            return backupFiles;
        }

        private void addOwnerBackupFiles(ArrayList<File> files, File rootDirectory, String ownerID) {
            File[] backups;
            this.ownerFileFilter.setOwnerID(ownerID);
            for (File f : backups = rootDirectory.listFiles(this.ownerFileFilter)) {
                files.add(f);
            }
        }

        @Override
        public boolean hasNext() {
            return this.itBackupFiles != null && this.itBackupFiles.hasNext();
        }

        @Override
        public InputStream next() throws NoSuchElementException {
            if (this.itBackupFiles == null) {
                throw new NoSuchElementException();
            }
            try {
                File f = this.itBackupFiles.next();
                if (!this.itBackupFiles.hasNext()) {
                    this.itBackupFiles = null;
                }
                return f == null || !f.exists() ? null : new FileInputStream(f);
            }
            catch (FileNotFoundException e) {
                return null;
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

