#!/bin/bash

set +e
LOG_FILE=/tmp/entrypoint.log

{
date
whoami
env
#########################################################################
#INST_DIR="/usr/local"
WEBAPP_DIR=/webapps
#CONFIG_DIR=/config
#QUEUE_NAME=dockervlkb$ACCESS_CONTEXT_ROOT

echo "SECURITY   : "$SECURITY
echo "DISCOVERY_CONTEXT_ROOT : "$DISCOVERY_CONTEXT_ROOT
echo "DISCOVERY_DB_URI       : "$DISCOVERY_DB_URI
#echo "VLKBOBSCORE_PG_URI     : "$VLKBOBSCORE_PG_URI
#echo "ACCESS_CONTEXT_ROOT    : "$ACCESS_CONTEXT_ROOT
echo "RESPONSE_FORMAT        : "$RESPONSE_FORMAT
echo "URL_CUTOUTS            : "$URL_CUTOUTS
echo "INST_DIR   : "$INST_DIR
echo "WEBAPP_DIR : "$WEBAPP_DIR
#echo "CONFIG_DIR : "$CONFIG_DIR
#echo "QUEUE_NAME : "$QUEUE_NAME
#########################################################################



## configure vlkb-tools
#mkdir -p $INST_DIR/etc/vlkb-obscore
#cp $CONFIG_DIR/vlkb-obscore.datasets.conf $INST_DIR/etc/vlkb-obscore/datasets.conf
#if test -n "$VLKBOBSCORE_PG_URI"
#then
#   echo "pg_uri=$VLKBOBSCORE_PG_URI" >> $INST_DIR/etc/vlkb-obscore/datasets.conf
#   echo "pg_schema=datasets"         >> $INST_DIR/etc/vlkb-obscore/datasets.conf
#fi



## configure VLKB discovery
if test -n "$DISCOVERY_CONTEXT_ROOT" && test -n "$DISCOVERY_DB_URI"
then

   if test -n "$SECURITY"
   then
     cd $WEBAPP_DIR/vlkb-search/WEB-INF/ && rm -f web.xml && cp web-search-$SECURITY.xml web.xml && cd -
   fi

#   cp $CONFIG_DIR/{auth.properties,neatoken.properties} $WEBAPP_DIR/vlkb-search/WEB-INF/classes/
   echo "<Context docBase=\"$WEBAPP_DIR/vlkb-search\"/>" > /var/lib/tomcat9/conf/Catalina/localhost/$DISCOVERY_CONTEXT_ROOT.xml
   echo "db_uri=$DISCOVERY_DB_URI"  >  $WEBAPP_DIR/vlkb-search/WEB-INF/classes/discovery.properties
   echo "db_schema=datasets"        >> $WEBAPP_DIR/vlkb-search/WEB-INF/classes/discovery.properties
   echo "db_user_name=$DB_USERNAME" >> $WEBAPP_DIR/vlkb-search/WEB-INF/classes/discovery.properties
   echo "db_password=$DB_PASSWORD"  >> $WEBAPP_DIR/vlkb-search/WEB-INF/classes/discovery.properties
   # use the same DB for authz permissions (ObsCore with extensions)
   cp $WEBAPP_DIR/vlkb-search/WEB-INF/classes/discovery.properties $WEBAPP_DIR/vlkb-search/WEB-INF/classes/authpolicy.properties

   if test -n "$RESPONSE_FORMAT"
   then
      echo "default_response_format=$RESPONSE_FORMAT" >> $WEBAPP_DIR/vlkb-search/WEB-INF/classes/discovery.properties
   fi




fi



## configure VLKB access
#if test -n "$ACCESS_CONTEXT_ROOT"
#then

#   if test -n "$SECURITY"
#   then
#      cd $WEBAPP_DIR/vlkb-cutout/WEB-INF/ && rm -f web.xml && cp web-cutout-$SECURITY.xml web.xml && cd -
#   fi

#   cp $CONFIG_DIR/{auth.properties,neatoken.properties} $WEBAPP_DIR/vlkb-cutout/WEB-INF/classes/
   #echo "<Context docBase=\"$WEBAPP_DIR/vlkb-cutout\"/>" > /var/lib/tomcat9/conf/Catalina/localhost/$ACCESS_CONTEXT_ROOT.xml
#   cp $WEBAPP_DIR/vlkb-cutout/META-INF/context.xml /var/lib/tomcat9/conf/Catalina/localhost/$ACCESS_CONTEXT_ROOT.xml
#   echo "db_uri=$DISCOVERY_DB_URI"  >  $WEBAPP_DIR/vlkb-cutout/WEB-INF/classes/authpolicy.properties
#   echo "db_schema=datasets"        >> $WEBAPP_DIR/vlkb-cutout/WEB-INF/classes/authpolicy.properties
#   echo "db_user_name=$DB_USERNAME" >> $WEBAPP_DIR/vlkb-cutout/WEB-INF/classes/authpolicy.properties
#   echo "db_password=$DB_PASSWORD"  >> $WEBAPP_DIR/vlkb-cutout/WEB-INF/classes/authpolicy.properties


#   echo "fits_path_surveys=/srv/surveys" > $WEBAPP_DIR/vlkb-cutout/WEB-INF/classes/datasets.conf
#   echo "fits_path_cutouts=/srv/cutouts" >> $WEBAPP_DIR/vlkb-cutout/WEB-INF/classes/datasets.conf
#   if test -f /srv/surveys/survey_populate.csv
#   then
#      echo "surveys_metadata_abs_pathname=/srv/surveys/survey_populate.csv" >> $WEBAPP_DIR/vlkb-cutout/WEB-INF/classes/datasets.conf
#      echo "fits_url_cutouts=$URL_CUTOUTS" >> $WEBAPP_DIR/vlkb-cutout/WEB-INF/classes/datasets.conf
#   fi
#   if test -n "$RESPONSE_FORMAT"
#   then
#      echo "default_response_format=$RESPONSE_FORMAT" >> $WEBAPP_DIR/vlkb-cutout/WEB-INF/classes/datasets.conf
#   fi

#   case $RESPONSE_FORMAT in application/vlkb*)
#      echo "default_sky_system=GALACTIC"   >> $WEBAPP_DIR/vlkb-cutout/WEB-INF/classes/datasets.conf
#      echo "default_spec_system=VELO_LSRK" >> $WEBAPP_DIR/vlkb-cutout/WEB-INF/classes/datasets.conf
#      echo "show_duration=yes"             >> $WEBAPP_DIR/vlkb-cutout/WEB-INF/classes/datasets.conf
#   esac

   # for resolver (id & extraCards)
#   echo "db_uri=$DISCOVERY_DB_URI"  >> $WEBAPP_DIR/vlkb-cutout/WEB-INF/classes/datasets.conf
#   echo "db_schema=datasets"        >> $WEBAPP_DIR/vlkb-cutout/WEB-INF/classes/datasets.conf
#   echo "db_user_name=$DB_USERNAME" >> $WEBAPP_DIR/vlkb-cutout/WEB-INF/classes/datasets.conf
#   echo "db_password=$DB_PASSWORD"  >> $WEBAPP_DIR/vlkb-cutout/WEB-INF/classes/datasets.conf

#   echo "amqp_host_name=localhost"     >> $WEBAPP_DIR/vlkb-cutout/WEB-INF/classes/datasets.conf
#   echo "amqp_port=5672"               >> $WEBAPP_DIR/vlkb-cutout/WEB-INF/classes/datasets.conf
#   echo "amqp_routing_key=$QUEUE_NAME" >> $WEBAPP_DIR/vlkb-cutout/WEB-INF/classes/datasets.conf

#   case $RESPONSE_FORMAT in application/vlkb*)
#      service rabbitmq-server start
#      $INST_DIR/bin/vlkbd_exec.sh localhost $QUEUE_NAME $INST_DIR/etc/vlkbd/datasets.conf
#   esac
#fi



# configure port/SSL connector: (path is relative to the dir where compose.yaml is
# - web.xml to run filters set above
# * ssl: set tomcat connector with certificates (ia2 needs SECTIGO, iam needs self-signed keystore.jks)
# * keep right jjwt*.jar libs (ia2 authlib needs v0.11, iam needs v0.12)
# assume all files in ssl sub-dir relative to where compose.yaml is
# set volume mapping in compose.yaml: ssl/ -> /etc/pki/tls/
case $SECURITY in
   ia2token)
      #cp ssl/server-connector-8443.xml-SECTIGO-vlkb_ia2_inaf_it  /etc/tomcat9/server-connector-8443.xml
      cp /root/ssl/server-connector-8443.xml /etc/tomcat9/server-connector-8443.xml
      # map volume instead of this: cp -r ssl/SECTIGO /etc/pki/tls/
      rm /webapps/vlkb-search/WEB-INF/lib/jjwt-*0.12*.jar
#      rm /webapps/vlkb-cutout/WEB-INF/lib/jjwt-*0.12*.jar
      ;;
   iamtoken)
      #cp ssl/server-connector-8443.xml-keystore-self-signed  /etc/tomcat9/server-connector-8443.xml
      cp /root/ssl/server-connector-8443.xml  /etc/tomcat9/server-connector-8443.xml
      # map volume somedir:/etc/pki/tls with somedir/{keystore.jks,SECTIGO/*} XXX cp ssl/keystore.jks /etc/pki/tls/
      rm /webapps/vlkb-search/WEB-INF/lib/jjwt-*0.11*.jar
#      rm /webapps/vlkb-cutout/WEB-INF/lib/jjwt-*0.11*.jar
      ;;
   *)
      echo "Security not configured, runs open."
      ;;
esac



#if test -f /srv/surveys/keystore.jks
#then
#   cp /srv/surveys/keystore.jks /root/
#fi
#if test -f /srv/surveys/server-connector-8443.xml /etc/tomcat9/
#then
#   cp /srv/surveys/server-connector-8443.xml /etc/tomcat9/
#fi
#
if test -n "$SECURITY"
then
   cd /etc/tomcat9/ && ln -s server-connector-8443.xml server-connector.xml && cd -
else
   cd /etc/tomcat9/ && ln -s server-connector-8080.xml server-connector.xml && cd -
fi

# configure access-token validation
if test -f /srv/surveys/iamtoken.properties
then
#   cp /srv/surveys/iamtoken.properties $WEBAPP_DIR/vlkb-cutout/WEB-INF/classes/
   cp /srv/surveys/iamtoken.properties $WEBAPP_DIR/vlkb-search/WEB-INF/classes/
fi


#########################################################################

date

} 1> $LOG_FILE 2>&1

JAVA_HOME=/usr/lib/jvm/java-17-openjdk-amd64 CATALINA_BASE=/var/lib/tomcat9 CATALINA_HOME=/usr/share/tomcat9 CATALINA_TMPDIR=/tmp /usr/libexec/tomcat9/tomcat-start.sh &

wait -n

