/*
 * Decompiled with CFR 0.152.
 */
package vo.parameter;

import java.util.Map;
import vo.parameter.Interval;
import vo.parameter.Parser;

public class Band
extends Interval {
    private static final String ARG_BAND = "BAND";
    private static final String ARG_BANDSYS = "BANDSYS";
    public System system;

    private static Band vlkbReq_getVelocity(Map<String, String[]> params, String strSystem) {
        boolean vel_valid;
        Band band = null;
        String cvlow = Parser.getSingleValue(params, "vl");
        String cvup = Parser.getSingleValue(params, "vu");
        boolean bl = vel_valid = cvlow != null && cvup != null;
        if (vel_valid) {
            double vel_low = Double.parseDouble(cvlow);
            double vel_up = Double.parseDouble(cvup);
            band = new Band(vel_low, vel_up, strSystem);
        }
        return band;
    }

    public static Band parseBand(Map<String, String[]> params, String defaultSystem) {
        String strValue;
        String strSystem = Parser.getSingleValue(params, ARG_BANDSYS);
        if (strSystem == null) {
            strSystem = Parser.getSingleValue(params, "specsystem", defaultSystem);
        }
        if ((strValue = Parser.getSingleValue(params, ARG_BAND)) == null) {
            return Band.vlkbReq_getVelocity(params, strSystem);
        }
        return new Band(strValue, strSystem);
    }

    public Band(String str, String strSystem) {
        super(str);
        this.system = System.valueOf(strSystem);
    }

    public Band(double low, double up, String strSystem) {
        super(low, up);
        this.system = System.valueOf(strSystem);
    }

    public void setSystem(String strSystem) {
        this.system = System.valueOf(strSystem);
    }

    public String toString() {
        return super.toString(ARG_BAND);
    }

    public static enum System {
        WAVE_Barycentric,
        VELO_LSRK,
        NONE;

    }
}

