/*
 * Decompiled with CFR 0.152.
 */
package uws.service.file.io;

import java.io.IOException;
import java.io.OutputStream;
import uws.service.file.io.CloseAction;

public class OutputStreamWithCloseAction
extends OutputStream {
    private final OutputStream output;
    private final CloseAction closeAction;

    public OutputStreamWithCloseAction(OutputStream output, CloseAction action) throws NullPointerException {
        if (output == null) {
            throw new NullPointerException("Missing OutputStream to wrap!");
        }
        this.output = output;
        this.closeAction = action;
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.output.write(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.output.write(b, off, len);
    }

    @Override
    public void write(int b) throws IOException {
        this.output.write(b);
    }

    @Override
    public void flush() throws IOException {
        this.output.flush();
    }

    @Override
    public void close() throws IOException {
        this.output.close();
        if (this.closeAction != null) {
            this.closeAction.run();
        }
    }
}

