
import com.opencsv.*;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.Path;
import java.util.List;
import java.util.ArrayList;
import java.io.Reader;

class CsvParser
{
   public static void main(String[] args) throws Exception
   {
      Path filePath = Paths.get(args[0]);

      CsvParser parser = new CsvParser();

      List<String[]> lines = parser.readLineByLine(filePath);

      for(String[] strArr : lines)
      {
         for(String str : strArr) System.out.print(str + " | ");
         System.out.println();
      }
   }

   public List<String[]> readLineByLine(Path filePath) throws Exception
   {
      CSVParser parser = new CSVParserBuilder()
         .withSeparator(',')
         .withIgnoreQuotations(true)
         .build();

      List<String[]> list = new ArrayList<>();
      try (Reader reader = Files.newBufferedReader(filePath))
      {
         try (CSVReader csvReader = new CSVReaderBuilder(reader)
               .withSkipLines(0)
               .withCSVParser(parser)
               .build();
               // CSVReader csvReader = new CSVReader(reader)
             )
         {
            String[] line;
            while ((line = csvReader.readNext()) != null) {
               list.add(line);
            }
         }
      }
      return list;
   }
}
