/*
 * Decompiled with CFR 0.152.
 */
package uws.service.actions;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import uws.UWSException;
import uws.job.JobList;
import uws.job.serializer.UWSSerializer;
import uws.job.serializer.filter.JobListRefiner;
import uws.job.user.JobOwner;
import uws.service.UWSService;
import uws.service.UWSUrl;
import uws.service.actions.UWSAction;
import uws.service.log.UWSLog;

public class ListJobs
extends UWSAction {
    private static final long serialVersionUID = 1L;

    public ListJobs(UWSService u) {
        super(u);
    }

    @Override
    public String getName() {
        return "List Jobs";
    }

    @Override
    public String getDescription() {
        return "Gives a list of all jobs contained into the specified jobs list. (URL: {baseUWS_URL}/{jobListName}, Method: HTTP-GET, No parameters)";
    }

    @Override
    public boolean match(UWSUrl urlInterpreter, JobOwner user, HttpServletRequest request) throws UWSException {
        return urlInterpreter.hasJobList() && !urlInterpreter.hasJob() && request.getMethod().equalsIgnoreCase("get");
    }

    @Override
    public boolean apply(UWSUrl urlInterpreter, JobOwner user, HttpServletRequest request, HttpServletResponse response) throws UWSException, IOException {
        JobList jobsList = this.getJobsList(urlInterpreter);
        UWSSerializer serializer = this.uws.getSerializer(request.getHeader("Accept"));
        response.setContentType(serializer.getMimeType());
        response.setCharacterEncoding("UTF-8");
        try {
            jobsList.serialize(response.getOutputStream(), serializer, user, new JobListRefiner(request));
        }
        catch (Exception e) {
            if (!(e instanceof UWSException)) {
                this.getLogger().logUWS(UWSLog.LogLevel.ERROR, urlInterpreter, "SERIALIZE", "Can not serialize the jobs list \"" + jobsList.getName() + "\"!", e);
                throw new UWSException(500, (Throwable)e, "Can not format properly the jobs list \"" + jobsList.getName() + "\"!");
            }
            throw (UWSException)e;
        }
        return true;
    }
}

