/*
 * Decompiled with CFR 0.152.
 */
package vo.parameter;

import java.util.Map;
import java.util.logging.Logger;
import vo.parameter.Circle;
import vo.parameter.Parser;
import vo.parameter.Polygon;
import vo.parameter.Range;

public class Pos {
    protected static final Logger LOGGER = Logger.getLogger("Pos");
    public String shape;
    String value;
    public System system;
    public Circle circle;
    public Range range;
    public Polygon polygon;

    public static Pos parsePos(Map<String, String[]> params) {
        return new Parser(params).getPosCirclePolygon();
    }

    public Pos(Circle circle) {
        this.shape = "CIRCLE";
        this.circle = circle;
    }

    public Pos(Range range) {
        this.shape = "RANGE";
        this.range = range;
    }

    public Pos(Polygon polygon) {
        this.shape = "POLYGON";
        this.polygon = polygon;
    }

    public Pos(String value) {
        LOGGER.info("trace: " + value);
        this.parsePos(value);
    }

    private void parsePos(String str) {
        String[] strArr = str.strip().split(" +", 2);
        if (strArr.length <= 1) {
            throw new IllegalArgumentException("POS value must have more then one space-separated elements but had " + strArr.length + " elements)");
        }
        this.shape = strArr[0].strip();
        this.value = strArr[1].strip();
        if (this.shape.equals("CIRCLE")) {
            this.circle = new Circle(this.value);
        } else if (this.shape.equals("RANGE")) {
            this.range = new Range(this.value);
        } else if (this.shape.equals("POLYGON")) {
            this.polygon = new Polygon(this.value);
        } else {
            throw new IllegalArgumentException("Valid POS shape is CIRCLE or RANGE or POLYGON but was: " + this.shape);
        }
    }

    public void setSystem(System system) {
        this.system = system;
    }

    public String toString() {
        String shapeStr;
        if (this.shape.equals("CIRCLE")) {
            shapeStr = this.circle.toString();
        } else if (this.shape.equals("RANGE")) {
            shapeStr = this.range.toString();
        } else if (this.shape.equals("POLYGON")) {
            shapeStr = this.polygon.toString();
        } else {
            throw new IllegalArgumentException("Valid POS shape is CIRCLE or RANGE or POLYGON but was: " + this.shape);
        }
        return "POS: " + shapeStr;
    }

    public static enum System {
        NONE,
        ICRS,
        GALACTIC;

    }
}

