

import uk.ac.starlink.table.*;// ColumnInfo needed
import uk.ac.starlink.votable.*;

class ObscoreExt
{
   static private ColumnInfo genPubDidColInfo()
   {
      ColumnInfo colInfo = new ColumnInfo( "obs_publisher_did", String.class,  "Publisher Did" );
      colInfo.setAuxDatum(new DescribedValue(VOStarTable.ID_INFO, "primaryID"));
      return colInfo;
   }


   public static final ColumnInfo[] OBSCORE_COLINFO =
   {

      new ColumnInfo( "dataproduct_type",  String.class,  "Dataproduct Type (image|cube)" ),
      new ColumnInfo( "calib_level",       Integer.class, "Calibration level" ),
      new ColumnInfo( "obs_collection",    String.class,  "Collection" ),
      new ColumnInfo( "obs_title",         String.class,  "Title" ),
      new ColumnInfo( "obs_id",            String.class,  "Observation Id" ),
      genPubDidColInfo(),
      new ColumnInfo( "bib_reference",     String.class,  "Bibbliographic refererence" ),
      new ColumnInfo( "data_rights",       String.class,  "Data rights" ),

      new ColumnInfo( "access_url",     String.class, "Access URL" ),
      new ColumnInfo( "access_format",  String.class, "Format (MIME type)" ),
      new ColumnInfo( "access_estsize", Long.class,   "Extimated size (KB)" ),

      new ColumnInfo( "target_name", String.class,  "Target" ),

      new ColumnInfo( "s_ra",         Double.class, "Right Ascention" ),
      new ColumnInfo( "s_dec",        Double.class, "Declination" ),
      new ColumnInfo( "s_fov",        Double.class, "Field of view" ),
      new ColumnInfo( "s_region",     String.class, "Region" ),
      new ColumnInfo( "s_xel1",       Long.class,   "Pixels axis1" ),
      new ColumnInfo( "s_xel2",       Long.class,   "Pixels axis2" ),
      new ColumnInfo( "s_resolution", Double.class, "Spatial resolution" ),

      new ColumnInfo( "t_min",        Double.class, "Time min" ),
      new ColumnInfo( "t_max",        Double.class, "Time max" ),
      new ColumnInfo( "t_exptime",    Double.class, "Exposure time" ),
      new ColumnInfo( "t_resolution", Double.class, "Time resolution" ),
      new ColumnInfo( "t_xel",        Long.class,   "Time pixels" ),

      new ColumnInfo( "em_min",       Double.class, "Spectrum min" ),
      new ColumnInfo( "em_max",       Double.class, "Spectrum max" ),
      new ColumnInfo( "em_res_power", Double.class, "Spectrum resolution power" ),
      new ColumnInfo( "em_xel",       Long.class,   "Spectrum pixels" ),

      new ColumnInfo( "o_ucd", String.class, "Observable UCD" ),

      new ColumnInfo( "pol_states", String.class, "Polarization states" ),
      new ColumnInfo( "pol_xel",    Long.class,   "Polarization pixels" ),

      new ColumnInfo( "facility_name", String.class, "Facility" ),
      new ColumnInfo( "instrument_name", String.class, "Instrument" ),
   };

   public static Object[] obscoreRow( Dataset dataset )
   {
      return new Object[]
      {
         dataset.obsCore.dataproduct_type,
            dataset.obsCore.calib_level,
            dataset.obsCore.obs_collection,
            dataset.obsCore.obs_title,
            dataset.obsCore.obs_id,
            dataset.obsCore.obs_publisher_did,
            dataset.obsCore.bib_reference,
            dataset.obsCore.data_rights,

            dataset.obsCore.access_url,
            dataset.obsCore.access_format,
            dataset.obsCore.access_estsize,

            dataset.obsCore.target_name,

            dataset.obsCore.s_ra,
            dataset.obsCore.s_dec,
            dataset.obsCore.s_fov,

            dataset.obsCore.s_region,
            dataset.obsCore.s_xel1,
            dataset.obsCore.s_xel2,
            dataset.obsCore.s_resolution,

            dataset.obsCore.t_min,
            dataset.obsCore.t_max,
            dataset.obsCore.t_exptime,
            dataset.obsCore.t_resolution,
            dataset.obsCore.t_xel,

            dataset.obsCore.em_min,
            dataset.obsCore.em_max,
            dataset.obsCore.em_res_power,
            dataset.obsCore.em_xel,

            dataset.obsCore.o_ucd,

            dataset.obsCore.pol_states,
            dataset.obsCore.pol_xel,

            dataset.obsCore.facility_name,
            dataset.obsCore.instrument_name,
      };
   }



   public static final ColumnInfo[] VLKB_COLINFO =
   {
      new ColumnInfo( "overlap",     Integer.class, "Overlap Code" ),
      new ColumnInfo( "overlapSky",  Integer.class, "Overlap Code for Sky axes" ),
      new ColumnInfo( "overlapSpec", Integer.class, "Overlap Code for Spectral axis" ),

      new ColumnInfo( "s_region_galactic", String.class, "Region [GALACTIC]" ),

      new ColumnInfo( "vel_min",    Double.class, "Velocity min" ),
      new ColumnInfo( "vel_max",    Double.class, "Velocity max" ),
   };

   public static Object[] vlkbRow( Dataset dataset )
   {
      return new Object[]
      {
         dataset.overlapCode,
            dataset.overlapCodeSky,
            dataset.overlapCodeVel,

            dataset.obsCore.s_region_galactic,

            dataset.obsCore.vel_min,
            dataset.obsCore.vel_max,
      };
   }



   public static final ColumnInfo[] OBSCORE_VLKB_COLINFO = concat(OBSCORE_COLINFO, VLKB_COLINFO);

   public static Object[] obscoreVlkbRow( Dataset dataset )
   {
      return concat(obscoreRow(dataset),vlkbRow(dataset));
   }



   private static ColumnInfo[] concat(ColumnInfo[] arr1, ColumnInfo[] arr2)
   {
      ColumnInfo[] oc = new ColumnInfo[arr1.length + arr2.length];
      System.arraycopy(arr1, 0, oc, 0,           arr1.length);
      System.arraycopy(arr2, 0, oc, arr1.length, arr2.length);
      return oc;
   };

   private static Object[] concat(Object[] arr1, Object[] arr2)
   {
      Object[] oc = new Object[arr1.length + arr2.length];
      System.arraycopy(arr1, 0, oc, 0,           arr1.length);
      System.arraycopy(arr2, 0, oc, arr1.length, arr2.length);
      return oc;
   };
}

