/*
 * Decompiled with CFR 0.152.
 */
package vo.parameter;

import java.util.Map;
import vo.parameter.Interval;
import vo.parameter.Parser;

public class Band {
    public System system;
    public double[] wavelength;

    public static Band parseBand(Map<String, String[]> params, String defaultSystem) {
        Parser parser = new Parser(params);
        return parser.getBand(defaultSystem);
    }

    public Band(String str, String strSystem) {
        this.wavelength = Interval.getDaliIntervalPositiveValues(str, "BAND");
        this.system = this.toBandSystem(strSystem);
    }

    public Band(double low, double up) {
        this.wavelength = new double[2];
        this.wavelength[0] = low;
        this.wavelength[1] = up;
    }

    public void setSystem(System system) {
        this.system = system;
    }

    public String toString() {
        return "BAND " + this.wavelength[0] + " " + this.wavelength[1];
    }

    private System toBandSystem(String str) {
        for (System sys : System.values()) {
            if (!str.equals((Object)sys)) continue;
            return sys;
        }
        throw new IllegalArgumentException("Invalid BANDSYS value: " + str);
    }

    public static enum System {
        WAVE_Barycentric,
        VELO_LSRK,
        NONE;

    }
}

