/*
 * Decompiled with CFR 0.152.
 */
package vo.parameter;

import java.util.Map;
import vo.parameter.Interval;
import vo.parameter.Parser;

public class Time {
    public System system;
    public double[] mjdUtc;

    public static Time parseTime(Map<String, String[]> params, String defaultSystem) {
        return new Parser(params).getTime(defaultSystem);
    }

    public Time(String value, String strSystem) {
        this.mjdUtc = Interval.getDaliIntervalPositiveValues(value, "TIME");
        this.system = this.toTimeSystem(strSystem);
    }

    public void setSystem(System system) {
        this.system = system;
    }

    public String toString() {
        return "TIME " + this.mjdUtc[0] + " " + this.mjdUtc[1];
    }

    private System toTimeSystem(String str) {
        for (System sys : System.values()) {
            if (!str.equals((Object)sys)) continue;
            return sys;
        }
        throw new IllegalArgumentException("Invalid TIMESYS value: " + str);
    }

    public static enum System {
        MJD_UTC,
        NONE;

    }
}

