/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.fits;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import nom.tam.fits.FitsElement;
import nom.tam.fits.FitsException;
import nom.tam.util.ArrayDataInput;
import nom.tam.util.ArrayDataOutput;
import nom.tam.util.ArrayFuncs;
import nom.tam.util.BufferedDataInputStream;
import nom.tam.util.BufferedDataOutputStream;

public class FitsHeap
implements FitsElement {
    private static final int MINIMUM_HEAP_SIZE = 16384;
    private byte[] heap;
    private int heapSize;
    private int heapOffset = 0;
    private BufferedDataInputStream bstr;

    FitsHeap(int size) {
        this.heapSize = size;
        if (size < 0) {
            throw new IllegalArgumentException("Illegal size for FITS heap:" + size);
        }
    }

    private void allocate() {
        if (this.heap == null) {
            this.heap = new byte[this.heapSize];
        }
    }

    FitsHeap copy() {
        FitsHeap copy = new FitsHeap(0);
        if (this.heap != null) {
            copy.heap = (byte[])this.heap.clone();
        }
        copy.heapSize = this.heapSize;
        copy.heapOffset = this.heapOffset;
        return copy;
    }

    void expandHeap(int need) {
        this.bstr = null;
        this.allocate();
        if (this.heapSize + need > this.heap.length) {
            int newlen = (this.heapSize + need) * 2;
            if (newlen < 16384) {
                newlen = 16384;
            }
            byte[] newHeap = new byte[newlen];
            System.arraycopy(this.heap, 0, newHeap, 0, this.heapSize);
            this.heap = newHeap;
        }
    }

    public void getData(int offset, Object array) throws FitsException {
        this.allocate();
        try {
            if (this.bstr == null || this.heapOffset > offset) {
                this.heapOffset = 0;
                this.bstr = new BufferedDataInputStream(new ByteArrayInputStream(this.heap));
            }
            this.bstr.skipAllBytes(offset - this.heapOffset);
            this.heapOffset = offset;
            this.heapOffset = (int)((long)this.heapOffset + this.bstr.readLArray(array));
        }
        catch (IOException e) {
            throw new FitsException("Error decoding heap area at offset=" + offset + ".  Exception: Exception " + e);
        }
    }

    @Override
    public long getFileOffset() {
        throw new IllegalStateException("FitsHeap should only be reset from inside its parent, never alone");
    }

    @Override
    public long getSize() {
        return this.size();
    }

    int putData(Object data) throws FitsException {
        long lsize = ArrayFuncs.computeLSize(data);
        if (lsize > Integer.MAX_VALUE) {
            throw new FitsException("FITS Heap > 2 G");
        }
        int size = (int)lsize;
        this.expandHeap(size);
        ByteArrayOutputStream bo = new ByteArrayOutputStream(size);
        try {
            BufferedDataOutputStream o = new BufferedDataOutputStream(bo);
            o.writeArray(data);
            o.flush();
            o.close();
        }
        catch (IOException e) {
            throw new FitsException("Unable to write variable column length data");
        }
        System.arraycopy(bo.toByteArray(), 0, this.heap, this.heapSize, size);
        int oldOffset = this.heapSize;
        this.heapSize += size;
        return oldOffset;
    }

    @Override
    @SuppressFBWarnings(value={"RR_NOT_CHECKED"}, justification="this read will never return less than the requested length")
    public void read(ArrayDataInput str) throws FitsException {
        if (this.heapSize > 0) {
            this.allocate();
            try {
                str.read(this.heap, 0, this.heapSize);
            }
            catch (IOException e) {
                throw new FitsException("Error reading heap:" + e);
            }
        }
        this.bstr = null;
    }

    @Override
    public boolean reset() {
        throw new IllegalStateException("FitsHeap should only be reset from inside its parent, never alone");
    }

    @Override
    public void rewrite() throws IOException, FitsException {
        throw new FitsException("FitsHeap should only be rewritten from inside its parent, never alone");
    }

    @Override
    public boolean rewriteable() {
        return false;
    }

    public int size() {
        return this.heapSize;
    }

    @Override
    public void write(ArrayDataOutput str) throws FitsException {
        this.allocate();
        try {
            str.write(this.heap, 0, this.heapSize);
        }
        catch (IOException e) {
            throw new FitsException("Error writing heap:" + e);
        }
    }
}

