/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.fits;

import java.io.Serializable;
import java.util.Comparator;
import nom.tam.fits.header.Standard;

public class HeaderOrder
implements Comparator<String>,
Serializable {
    private static final long serialVersionUID = 1L;

    @Override
    public int compare(String c1, String c2) {
        if (c1.equals(c2)) {
            return 0;
        }
        if (c1.equals(Standard.SIMPLE.key()) || c1.equals(Standard.XTENSION.key())) {
            return -1;
        }
        if (c2.equals(Standard.SIMPLE.key()) || c2.equals(Standard.XTENSION.key())) {
            return 1;
        }
        if (c1.equals(Standard.BITPIX.key())) {
            return -1;
        }
        if (c2.equals(Standard.BITPIX.key())) {
            return 1;
        }
        if (c1.equals(Standard.NAXIS.key())) {
            return -1;
        }
        if (c2.equals(Standard.NAXIS.key())) {
            return 1;
        }
        int naxisNc1 = HeaderOrder.naxisN(c1);
        int naxisNc2 = HeaderOrder.naxisN(c2);
        if (naxisNc1 > 0) {
            if (naxisNc2 > 0) {
                if (naxisNc1 < naxisNc2) {
                    return -1;
                }
                return 1;
            }
            return -1;
        }
        if (naxisNc2 > 0) {
            return 1;
        }
        if (c1.equals(Standard.EXTEND.key())) {
            return -1;
        }
        if (c2.equals(Standard.EXTEND.key())) {
            return 1;
        }
        if (c1.equals(Standard.PCOUNT.key())) {
            return -1;
        }
        if (c2.equals(Standard.PCOUNT.key())) {
            return 1;
        }
        if (c1.equals(Standard.GCOUNT.key())) {
            return -1;
        }
        if (c2.equals(Standard.GCOUNT.key())) {
            return 1;
        }
        if (c1.equals(Standard.TFIELDS.key())) {
            return -1;
        }
        if (c2.equals(Standard.TFIELDS.key())) {
            return 1;
        }
        if (c1.equals(Standard.BLOCKED.key())) {
            return -1;
        }
        if (c2.equals(Standard.BLOCKED.key())) {
            return 1;
        }
        if (c1.equals(Standard.THEAP.key())) {
            return 1;
        }
        if (c2.equals(Standard.THEAP.key())) {
            return -1;
        }
        if (c1.equals(Standard.END.key())) {
            return 1;
        }
        if (c2.equals(Standard.END.key())) {
            return -1;
        }
        return 0;
    }

    public boolean equals(String a, String b) {
        return this.compare(a, b) == 0;
    }

    private static int naxisN(String key) {
        int startOfNumber = Standard.NAXIS.key().length();
        if (key.length() > startOfNumber && key.startsWith(Standard.NAXIS.key()) && Character.isDigit(key.charAt(startOfNumber))) {
            return Integer.parseInt(key.substring(startOfNumber));
        }
        return -1;
    }
}

