/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.fits.compression.algorithm.gzip2;

import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import nom.tam.fits.compression.algorithm.gzip.GZipCompressor;

public abstract class GZip2Compressor<T extends Buffer>
extends GZipCompressor<T> {
    public GZip2Compressor(int primitiveSize) {
        super(primitiveSize);
    }

    private int[] calculateOffsets(byte[] byteArray) {
        int[] offset = new int[this.primitiveSize];
        offset[0] = 0;
        for (int primitivIndex = 1; primitivIndex < this.primitiveSize; ++primitivIndex) {
            offset[primitivIndex] = offset[primitivIndex - 1] + byteArray.length / this.primitiveSize;
        }
        return offset;
    }

    @Override
    public boolean compress(T pixelData, ByteBuffer compressed) {
        int pixelDataLimit = ((Buffer)pixelData).limit();
        byte[] pixelBytes = new byte[pixelDataLimit * this.primitiveSize];
        this.getPixel(pixelData, pixelBytes);
        pixelBytes = this.shuffle(pixelBytes);
        try (GZIPOutputStream zip = this.createGZipOutputStream(pixelDataLimit, compressed);){
            zip.write(pixelBytes, 0, pixelBytes.length);
        }
        catch (IOException e) {
            throw new IllegalStateException("could not gzip data", e);
        }
        return true;
    }

    @Override
    public void decompress(ByteBuffer compressed, T pixelData) {
        int pixelDataLimit = ((Buffer)pixelData).limit();
        byte[] pixelBytes = new byte[pixelDataLimit * this.primitiveSize];
        try (GZIPInputStream zip = this.createGZipInputStream(compressed);){
            int count = 0;
            int offset = 0;
            while (offset < pixelBytes.length && count >= 0) {
                count = zip.read(pixelBytes, offset, pixelBytes.length - offset);
                if (count < 0) continue;
                offset += count;
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("could not gunzip data", e);
        }
        pixelBytes = this.unshuffle(pixelBytes);
        this.setPixel(pixelData, pixelBytes);
    }

    public byte[] shuffle(byte[] byteArray) {
        byte[] result = new byte[byteArray.length];
        int resultIndex = 0;
        int[] offset = this.calculateOffsets(byteArray);
        for (int index = 0; index < byteArray.length; index += this.primitiveSize) {
            for (int primitiveIndex = 0; primitiveIndex < this.primitiveSize; ++primitiveIndex) {
                result[resultIndex + offset[primitiveIndex]] = byteArray[index + primitiveIndex];
            }
            ++resultIndex;
        }
        return result;
    }

    public byte[] unshuffle(byte[] byteArray) {
        byte[] result = new byte[byteArray.length];
        int resultIndex = 0;
        int[] offset = this.calculateOffsets(byteArray);
        for (int index = 0; index < byteArray.length; index += this.primitiveSize) {
            for (int primitiveIndex = 0; primitiveIndex < this.primitiveSize; ++primitiveIndex) {
                result[index + primitiveIndex] = byteArray[resultIndex + offset[primitiveIndex]];
            }
            ++resultIndex;
        }
        return result;
    }

    public static class ShortGZip2Compressor
    extends GZip2Compressor<ShortBuffer> {
        protected static final int BYTE_SIZE_OF_SHORT = 2;

        public ShortGZip2Compressor() {
            super(2);
        }

        @Override
        protected void getPixel(ShortBuffer pixelData, byte[] pixelBytes) {
            ShortBuffer shortBuffer = ByteBuffer.wrap(pixelBytes).asShortBuffer();
            shortBuffer.put(pixelData);
        }

        @Override
        protected void setPixel(ShortBuffer pixelData, byte[] pixelBytes) {
            pixelData.put(ByteBuffer.wrap(pixelBytes).asShortBuffer());
        }
    }

    public static class LongGZip2Compressor
    extends GZip2Compressor<LongBuffer> {
        protected static final int BYTE_SIZE_OF_LONG = 8;

        public LongGZip2Compressor() {
            super(8);
        }

        @Override
        protected void getPixel(LongBuffer pixelData, byte[] pixelBytes) {
            LongBuffer pixelBuffer = ByteBuffer.wrap(pixelBytes).asLongBuffer();
            pixelBuffer.put(pixelData);
        }

        @Override
        protected void setPixel(LongBuffer pixelData, byte[] pixelBytes) {
            pixelData.put(ByteBuffer.wrap(pixelBytes).asLongBuffer());
        }
    }

    public static class IntGZip2Compressor
    extends GZip2Compressor<IntBuffer> {
        protected static final int BYTE_SIZE_OF_INT = 4;

        public IntGZip2Compressor() {
            super(4);
        }

        @Override
        protected void getPixel(IntBuffer pixelData, byte[] pixelBytes) {
            IntBuffer pixelBuffer = ByteBuffer.wrap(pixelBytes).asIntBuffer();
            pixelBuffer.put(pixelData);
        }

        @Override
        protected void setPixel(IntBuffer pixelData, byte[] pixelBytes) {
            pixelData.put(ByteBuffer.wrap(pixelBytes).asIntBuffer());
        }
    }

    public static class ByteGZip2Compress
    extends GZipCompressor.ByteGZipCompressor {
    }
}

