/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.fits.compression.provider.param.base;

import nom.tam.fits.BinaryTable;
import nom.tam.fits.BinaryTableHDU;
import nom.tam.fits.FitsException;
import nom.tam.fits.Header;
import nom.tam.fits.HeaderCardException;
import nom.tam.fits.compression.provider.param.api.ICompressColumnParameter;
import nom.tam.fits.compression.provider.param.api.ICompressHeaderParameter;
import nom.tam.fits.compression.provider.param.api.ICompressParameters;
import nom.tam.fits.header.Standard;

public abstract class CompressParameters
implements ICompressParameters {
    @Override
    public void addColumnsToTable(BinaryTableHDU hdu) throws FitsException {
        for (ICompressColumnParameter parameter : this.columnParameters()) {
            Object column = parameter.column();
            if (column == null) continue;
            hdu.setColumnName(hdu.addColumn(column) - 1, parameter.getName(), null);
        }
    }

    protected ICompressColumnParameter[] columnParameters() {
        return new ICompressColumnParameter[0];
    }

    private Object getNullableColumn(Header header, BinaryTable binaryTable, String columnName) throws FitsException {
        for (int i = 1; i <= binaryTable.getNCols(); ++i) {
            String val = header.getStringValue(Standard.TTYPEn.n(i));
            if (val == null || !val.trim().equals(columnName)) continue;
            return binaryTable.getColumn(i - 1);
        }
        return null;
    }

    @Override
    public void getValuesFromColumn(int index) {
        for (ICompressColumnParameter parameter : this.columnParameters()) {
            parameter.getValueFromColumn(index);
        }
    }

    @Override
    public void getValuesFromHeader(Header header) {
        for (ICompressHeaderParameter compressionParameter : this.headerParameters()) {
            compressionParameter.getValueFromHeader(header);
        }
    }

    protected abstract ICompressHeaderParameter[] headerParameters();

    @Override
    public void initializeColumns(Header header, BinaryTable binaryTable, int size) throws FitsException {
        for (ICompressColumnParameter parameter : this.columnParameters()) {
            parameter.column(this.getNullableColumn(header, binaryTable, parameter.getName()), size);
        }
    }

    @Override
    public void initializeColumns(int size) {
        for (ICompressColumnParameter parameter : this.columnParameters()) {
            parameter.column(null, size);
        }
    }

    @Override
    public void setValueFromColumn(int index) {
        for (ICompressColumnParameter parameter : this.columnParameters()) {
            parameter.setValueInColumn(index);
        }
    }

    @Override
    public void setValuesInHeader(Header header) throws HeaderCardException {
        for (ICompressHeaderParameter parameter : this.headerParameters()) {
            parameter.setValueInHeader(header);
        }
    }
}

