/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.util.type;

import java.nio.ByteBuffer;
import java.nio.ShortBuffer;
import nom.tam.util.type.PrimitiveTypeBase;

class ShortType
extends PrimitiveTypeBase<ShortBuffer> {
    private static final int BIT_PIX = 16;

    protected ShortType() {
        super(2, false, Short.TYPE, Short.class, ShortBuffer.class, 'S', 16);
    }

    @Override
    public void appendBuffer(ShortBuffer buffer, ShortBuffer dataToAppend) {
        short[] temp = new short[Math.min(1024, dataToAppend.remaining())];
        while (dataToAppend.hasRemaining()) {
            int nrObBytes = Math.min(temp.length, dataToAppend.remaining());
            dataToAppend.get(temp, 0, nrObBytes);
            buffer.put(temp, 0, nrObBytes);
        }
    }

    @Override
    public ShortBuffer asTypedBuffer(ByteBuffer buffer) {
        return buffer.asShortBuffer();
    }

    @Override
    public void getArray(ShortBuffer buffer, Object array, int length) {
        buffer.get((short[])array, 0, length);
    }

    @Override
    public Object newArray(int length) {
        return new short[length];
    }

    @Override
    public void putArray(ShortBuffer buffer, Object array, int length) {
        buffer.put((short[])array, 0, length);
    }

    @Override
    public ShortBuffer sliceBuffer(ShortBuffer buffer) {
        return buffer.slice();
    }

    @Override
    public ShortBuffer wrap(Object array) {
        return ShortBuffer.wrap((short[])array);
    }
}

