/*
 * Decompiled with CFR 0.152.
 */
package uws.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Properties;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import uws.UWSException;
import uws.config.ConfigurableUWSFactory;
import uws.config.UWSConfiguration;
import uws.job.JobList;
import uws.job.manager.DefaultDestructionManager;
import uws.job.manager.DefaultExecutionManager;
import uws.job.manager.DestructionManager;
import uws.job.manager.ExecutionManager;
import uws.job.manager.QueuedExecutionManager;
import uws.job.serializer.UWSSerializer;
import uws.job.serializer.XMLSerializer;
import uws.service.UWSFactory;
import uws.service.UWSService;
import uws.service.UserIdentifier;
import uws.service.actions.ShowHomePage;
import uws.service.actions.UWSAction;
import uws.service.backup.DefaultUWSBackupManager;
import uws.service.error.ServiceErrorWriter;
import uws.service.file.LocalUWSFileManager;
import uws.service.file.UWSFileManager;
import uws.service.log.DefaultUWSLog;
import uws.service.log.Slf4jUWSLog;
import uws.service.log.UWSLog;

public class ConfigurableUWSServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private UWSService uws = null;

    public void init(ServletConfig config) throws ServletException {
        if (this.uws != null) {
            return;
        }
        String uwsConfPath = config.getInitParameter("uwsconf");
        if (uwsConfPath == null || uwsConfPath.trim().length() == 0) {
            uwsConfPath = null;
        }
        InputStream input = null;
        if (uwsConfPath == null) {
            input = this.searchFile("uws.properties", config);
        } else {
            File f = new File(uwsConfPath);
            if (f.exists()) {
                try {
                    input = new FileInputStream(f);
                }
                catch (IOException ioe) {
                    throw new ServletException("Impossible to read the UWS configuration file (" + uwsConfPath + ")!", (Throwable)ioe);
                }
            } else {
                input = this.searchFile(uwsConfPath, config);
            }
        }
        if (input == null) {
            throw new ServletException("Configuration file not found with the path: \"" + (uwsConfPath == null ? "uws.properties" : uwsConfPath) + "\"! Please provide a correct file path in servlet init parameter (\"" + "uwsconf" + "\") or put your configuration file named \"" + "uws.properties" + "\" in a directory of the classpath or in WEB-INF or META-INF.");
        }
        Properties uwsConf = new Properties();
        try {
            uwsConf.load(input);
        }
        catch (IOException ioe) {
            throw new ServletException("Impossible to read the UWS configuration file (" + uwsConfPath + ")!", (Throwable)ioe);
        }
        finally {
            try {
                input.close();
            }
            catch (IOException iOException) {}
        }
        UWSFileManager fileManager = null;
        try {
            fileManager = this.createFileManager(uwsConf, config.getServletContext().getRealPath(""));
        }
        catch (Exception ex) {
            if (ex instanceof UWSException) {
                throw new ServletException(ex.getMessage(), ex.getCause());
            }
            throw new ServletException("Impossible to initialize the UWS file manager!", (Throwable)ex);
        }
        UWSLog logger = null;
        try {
            logger = this.createLogger(uwsConf, fileManager);
        }
        catch (Exception ex) {
            if (ex instanceof UWSException) {
                throw new ServletException(ex.getMessage(), ex.getCause());
            }
            throw new ServletException("Impossible to initialize the UWS logger!", (Throwable)ex);
        }
        try {
            this.uws = new UWSService(this.createFactory(uwsConf), fileManager, logger);
        }
        catch (Exception ex) {
            this.uws = null;
            if (ex instanceof UWSException) {
                throw new ServletException(ex.getMessage(), ex.getCause());
            }
            throw new ServletException("Impossible to initialize the UWS service!", (Throwable)ex);
        }
        String propValue = UWSConfiguration.getProperty(uwsConf, "home_page");
        if (propValue != null) {
            if (UWSConfiguration.isClassName(propValue)) {
                try {
                    this.uws.replaceUWSAction(UWSConfiguration.newInstance(propValue, "home_page", ShowHomePage.class, new Class[]{UWSService.class}, new Object[]{this.uws}));
                }
                catch (UWSException te) {
                    throw new ServletException(te.getMessage(), te.getCause());
                }
            } else {
                this.uws.setHomePage(propValue);
                propValue = UWSConfiguration.getProperty(uwsConf, "home_page_mime_type");
                if (propValue != null) {
                    this.uws.setHomePageMimeType(propValue);
                }
            }
        }
        this.uws.setName(UWSConfiguration.getProperty(uwsConf, "service_name"));
        this.uws.setDescription(UWSConfiguration.getProperty(uwsConf, "service_description"));
        this.initBackup(uwsConf);
        this.initUserIdentifier(uwsConf);
        this.initJobLists(uwsConf);
        this.addCustomActions(uwsConf);
        this.addCustomSerializers(uwsConf);
        this.initXSLTStylesheet(uwsConf);
        this.initErrorWriter(uwsConf);
        super.init(config);
    }

    private UWSFileManager createFileManager(Properties uwsConfig, String webAppRootDir) throws UWSException {
        String fileManagerType = UWSConfiguration.getProperty(uwsConfig, "file_manager");
        if (fileManagerType == null) {
            throw new UWSException("The property \"file_manager\" is missing! It is required to create a TAP Service. Two possible values: local or a class name between {...}.");
        }
        if ((fileManagerType = fileManagerType.trim()).equalsIgnoreCase("local")) {
            String rootPath = UWSConfiguration.getProperty(uwsConfig, "file_root_path");
            if (rootPath == null) {
                throw new UWSException("The property \"file_root_path\" is missing! It is required to create a TAP Service. Please provide a path toward a directory which will contain all files related to the service.");
            }
            File rootFile = this.getFile(rootPath, webAppRootDir, "file_root_path");
            String propValue = UWSConfiguration.getProperty(uwsConfig, "directory_per_user");
            boolean oneDirectoryPerUser = propValue == null ? false : Boolean.parseBoolean(propValue);
            propValue = UWSConfiguration.getProperty(uwsConfig, "group_user_directories");
            boolean groupUserDirectories = propValue == null ? false : Boolean.parseBoolean(propValue);
            try {
                return new LocalUWSFileManager(rootFile, oneDirectoryPerUser, groupUserDirectories);
            }
            catch (UWSException e) {
                throw new UWSException("The property \"file_root_path\" (" + rootPath + ") is incorrect: " + e.getMessage());
            }
        }
        return UWSConfiguration.newInstance(fileManagerType, "file_manager", UWSFileManager.class, new Class[]{Properties.class}, new Object[]{uwsConfig});
    }

    private UWSLog createLogger(Properties uwsConfig, UWSFileManager fileManager) throws UWSException {
        String propValue = UWSConfiguration.getProperty(uwsConfig, "logger");
        UWSLog logger = propValue == null || propValue.trim().equalsIgnoreCase("default") ? new DefaultUWSLog(fileManager) : (propValue == null || propValue.trim().equalsIgnoreCase("slf4j") ? new Slf4jUWSLog() : UWSConfiguration.newInstance(propValue, "logger", UWSLog.class, new Class[]{UWSFileManager.class}, new Object[]{fileManager}));
        if (propValue == null || propValue.trim().equalsIgnoreCase("default")) {
            propValue = UWSConfiguration.getProperty(uwsConfig, "min_log_level");
            if (propValue != null) {
                try {
                    ((DefaultUWSLog)logger).setMinLogLevel(UWSLog.LogLevel.valueOf(propValue.toUpperCase()));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            if (fileManager instanceof LocalUWSFileManager && (propValue = UWSConfiguration.getProperty(uwsConfig, "log_rotation")) != null) {
                ((LocalUWSFileManager)fileManager).setLogRotationFreq(propValue);
            }
        }
        logger.info("Logger initialized - {" + logger.getConfigString() + "}");
        return logger;
    }

    private UWSFactory createFactory(Properties uwsConfig) throws UWSException {
        String propValue = UWSConfiguration.getProperty(uwsConfig, "uws_factory");
        if (propValue == null) {
            return new ConfigurableUWSFactory(uwsConfig);
        }
        if (UWSConfiguration.hasConstructor(propValue, "uws_factory", UWSFactory.class, new Class[]{Properties.class})) {
            return UWSConfiguration.newInstance(propValue, "uws_factory", UWSFactory.class, new Class[]{Properties.class}, new Object[]{uwsConfig});
        }
        return UWSConfiguration.newInstance(propValue, "uws_factory", UWSFactory.class, new Class[0], new Object[0]);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void initBackup(Properties uwsConf) throws ServletException {
        try {
            long backupFrequency;
            String propValue;
            block8: {
                propValue = UWSConfiguration.getProperty(uwsConf, "backup_frequency");
                if (propValue != null) {
                    try {
                        backupFrequency = Long.parseLong(propValue);
                        if (backupFrequency <= 0L) {
                            backupFrequency = -1L;
                        }
                    }
                    catch (NumberFormatException nfe) {
                        if (propValue.equalsIgnoreCase("never")) {
                            backupFrequency = -1L;
                            break block8;
                        }
                        if (!propValue.equalsIgnoreCase("user_action")) throw new UWSException("Long expected for the property \"backup_frequency\", instead of: \"" + propValue + "\"!");
                        backupFrequency = 0L;
                    }
                } else {
                    backupFrequency = -1L;
                }
            }
            boolean backupByUser = (propValue = UWSConfiguration.getProperty(uwsConf, "backup_by_user")) == null ? false : Boolean.parseBoolean(propValue);
            this.uws.setBackupManager(new DefaultUWSBackupManager(this.uws, backupByUser, backupFrequency));
            return;
        }
        catch (UWSException ue) {
            throw new ServletException("Impossible to initialize the Backup system (and so to restore all the last backuped jobs)!", (Throwable)ue);
        }
    }

    private void initUserIdentifier(Properties uwsConfig) throws ServletException {
        String propValue = UWSConfiguration.getProperty(uwsConfig, "user_identifier");
        if (propValue != null) {
            try {
                this.uws.setUserIdentifier(UWSConfiguration.newInstance(propValue, "user_identifier", UserIdentifier.class));
            }
            catch (UWSException ue) {
                throw new ServletException("Impossible to initialize the user identification!", (Throwable)ue);
            }
        }
    }

    private void initJobLists(Properties uwsConf) throws ServletException {
        String propValue = UWSConfiguration.getProperty(uwsConf, "joblists");
        if (propValue != null) {
            String[] jlNames = propValue.split(",");
            if (jlNames == null || jlNames.length == 0) {
                throw new ServletException("Missing job list name! At least one job list name must be provided. See property \"joblists\".");
            }
            for (String jlName : jlNames) {
                ExecutionManager execManager;
                block16: {
                    if (!(jlName = jlName.trim()).matches("[^\\.=\\s]+")) {
                        throw new ServletException("Incorrect job list name: \"" + jlName + "\"! It must not contain space characters, point and equal sign.");
                    }
                    int nbMaxRunningJobs = -1;
                    execManager = null;
                    try {
                        propValue = UWSConfiguration.getProperty(uwsConf, jlName + "." + "execution_manager");
                        if (propValue != null) {
                            execManager = UWSConfiguration.newInstance(propValue, jlName + "." + "execution_manager", ExecutionManager.class, new Class[]{UWSLog.class}, new Object[]{this.uws.getLogger()});
                            break block16;
                        }
                        propValue = UWSConfiguration.getProperty(uwsConf, jlName + "." + "max_running_jobs");
                        if (propValue == null) break block16;
                        try {
                            nbMaxRunningJobs = Integer.parseInt(propValue);
                            if (nbMaxRunningJobs > 0) {
                                execManager = new QueuedExecutionManager(this.uws.getLogger(), nbMaxRunningJobs);
                            }
                        }
                        catch (NumberFormatException nfe) {
                            this.uws.getLogger().logUWS(UWSLog.LogLevel.ERROR, this.uws, "INIT", "Incorrect value for the property \"" + jlName + "." + "max_running_jobs" + "\": \"" + propValue + "\"! It should be a positive integer value. No execution queue is set for this job list.", nfe);
                        }
                    }
                    catch (UWSException ue) {
                        this.uws.getLogger().logUWS(UWSLog.LogLevel.ERROR, this.uws, "INIT", "Impossible to set a custom execution manager to the job list \"" + jlName + "\"! The default one will be used.", ue);
                    }
                }
                DestructionManager destManager = null;
                try {
                    propValue = UWSConfiguration.getProperty(uwsConf, jlName + "." + "destruction_manager");
                    if (propValue != null) {
                        destManager = UWSConfiguration.newInstance(propValue, jlName + "." + "destruction_manager", DestructionManager.class, new Class[0], new Object[0]);
                    }
                }
                catch (UWSException ue) {
                    this.uws.getLogger().logUWS(UWSLog.LogLevel.ERROR, this.uws, "INIT", "Impossible to set a custom destruction manager to the job list \"" + jlName + "\"! The default one will be used.", ue);
                }
                if (execManager == null) {
                    execManager = new DefaultExecutionManager(this.uws.getLogger());
                }
                if (destManager == null) {
                    destManager = new DefaultDestructionManager();
                }
                this.uws.addJobList(new JobList(jlName, execManager, destManager));
            }
        } else {
            throw new ServletException("Missing job list name! At least one job list name must be provided. See property \"joblists\".");
        }
    }

    private void addCustomActions(Properties uwsConfig) throws ServletException {
        String propValue = UWSConfiguration.getProperty(uwsConfig, "additional_actions");
        if (propValue != null) {
            String[] actionClasses = propValue.split(",");
            if (actionClasses == null || actionClasses.length == 0) {
                return;
            }
            for (String actionClass : actionClasses) {
                try {
                    int actionIndex = actionClass.indexOf(58);
                    if (actionIndex > 0) {
                        actionIndex = Integer.parseInt(actionClass.substring(0, actionIndex));
                        actionClass = actionClass.substring(actionIndex + 1);
                    }
                    UWSAction action = UWSConfiguration.newInstance(actionClass, "additional_actions", UWSAction.class, new Class[]{UWSService.class}, new Object[]{this.uws});
                    boolean added = false;
                    added = this.uws.getUWSAction(action.getName()) != null ? this.uws.replaceUWSAction(action) != null : (actionIndex >= 0 ? this.uws.addUWSAction(actionIndex, action) : this.uws.addUWSAction(action));
                    if (added) continue;
                    this.uws.getLogger().logUWS(UWSLog.LogLevel.ERROR, this.uws, "INIT", "Failed to add the UWS action \"" + action.getName() + "\" implemented with the class \"" + actionClass + "\"! See property \"" + "additional_actions" + "\".", null);
                }
                catch (UWSException ue) {
                    this.uws.getLogger().logUWS(UWSLog.LogLevel.ERROR, this.uws, "INIT", "Impossible to create the UWS action \"" + actionClass + "\" specified in the property \"" + "additional_actions" + "\"!", ue);
                }
                catch (NumberFormatException nfe) {
                    this.uws.getLogger().logUWS(UWSLog.LogLevel.ERROR, this.uws, "INIT", "Impossible to extract the given action index for the UWS action \"" + actionClass + "\" specified in the property \"" + "additional_actions" + "\"! A positive integer value is expected.", nfe);
                }
            }
        }
    }

    private void addCustomSerializers(Properties uwsConfig) throws ServletException {
        String propValue = UWSConfiguration.getProperty(uwsConfig, "additional_serializers");
        if (propValue != null) {
            String[] serializerClasses = propValue.split(",");
            if (serializerClasses == null || serializerClasses.length == 0) {
                return;
            }
            for (String serializerClass : serializerClasses) {
                try {
                    this.uws.addSerializer(UWSConfiguration.newInstance(serializerClass, "additional_serializers", UWSSerializer.class, new Class[0], new Object[0]));
                }
                catch (UWSException ue) {
                    this.uws.getLogger().logUWS(UWSLog.LogLevel.ERROR, this.uws, "INIT", "Impossible to create the UWS serializer \"" + serializerClass + "\" specified in the property \"" + "additional_serializers" + "\"!", ue);
                }
            }
        }
    }

    private void initXSLTStylesheet(Properties uwsConfig) throws ServletException {
        String propValue = UWSConfiguration.getProperty(uwsConfig, "xslt_stylesheet");
        if (propValue != null) {
            try {
                if (this.uws.getSerializer("text/xml") instanceof XMLSerializer) {
                    ((XMLSerializer)this.uws.getSerializer("text/xml")).setXSLTPath(propValue);
                }
            }
            catch (UWSException ue) {
                this.uws.getLogger().logUWS(UWSLog.LogLevel.ERROR, this.uws, "INIT", "Impossible to set the specified XSLT stylesheet: \"" + propValue + "\"! Then, no XSLT stylesheet is used.", ue);
            }
        }
    }

    private void initErrorWriter(Properties uwsConfig) throws ServletException {
        String propValue = UWSConfiguration.getProperty(uwsConfig, "error_writer");
        if (propValue != null) {
            try {
                this.uws.setErrorWriter(UWSConfiguration.newInstance(propValue, "error_writer", ServiceErrorWriter.class));
            }
            catch (UWSException ue) {
                this.uws.getLogger().logUWS(UWSLog.LogLevel.ERROR, this.uws, "INIT", "Impossible to initialize the error writer! Then, the default one will be used.", ue);
            }
        }
    }

    protected final InputStream searchFile(String filePath, ServletConfig config) {
        InputStream input = null;
        input = Thread.currentThread().getContextClassLoader().getResourceAsStream(filePath);
        if (input == null) {
            if (filePath.startsWith("/")) {
                filePath = filePath.substring(1);
            }
            if ((input = config.getServletContext().getResourceAsStream("/WEB-INF/" + filePath)) == null) {
                input = config.getServletContext().getResourceAsStream("/META-INF/" + filePath);
            }
        }
        return input;
    }

    protected final File getFile(String filePath, String webAppRootPath, String propertyName) throws UWSException {
        if (filePath == null) {
            return null;
        }
        try {
            URI uri = new URI(filePath);
            if (uri.isAbsolute()) {
                if (uri.getScheme().equalsIgnoreCase("file")) {
                    return new File(uri);
                }
                throw new UWSException("Incorrect file URI for the property \"" + propertyName + "\": \"" + filePath + "\"! Only URI with the protocol \"file:\" are allowed.");
            }
            File f = new File(filePath);
            if (f.isAbsolute()) {
                return f;
            }
            return new File(webAppRootPath, filePath);
        }
        catch (URISyntaxException use) {
            throw new UWSException(404, (Throwable)use, "Incorrect file URI for the property \"" + propertyName + "\": \"" + filePath + "\"! Bad syntax for the given file URI.");
        }
    }

    public void destroy() {
        if (this.uws != null) {
            this.uws.destroy();
            this.uws = null;
        }
        super.destroy();
    }

    protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (this.uws != null) {
            try {
                this.uws.executeRequest(req, resp);
            }
            catch (Throwable t) {
                resp.sendError(500, t.getMessage());
            }
        } else {
            resp.sendError(503, "UWS service not yet initialized!");
        }
    }
}

