/*
 * Decompiled with CFR 0.152.
 */
package uws.job;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import uws.UWSException;
import uws.UWSToolBox;
import uws.job.ErrorSummary;
import uws.job.ExecutionPhase;
import uws.job.JobList;
import uws.job.Result;
import uws.job.UWSJob;
import uws.service.error.ServiceErrorWriter;
import uws.service.file.UWSFileManager;
import uws.service.log.UWSLog;

public abstract class JobThread
extends Thread {
    protected final UWSJob job;
    protected UWSException lastError = null;
    protected boolean fatalError = false;
    protected boolean finished = false;
    protected final String taskDescription;
    protected final ServiceErrorWriter errorWriter;
    public static final ThreadGroup tg = new ThreadGroup("UWS_GROUP");

    public JobThread(UWSJob j) throws NullPointerException {
        this(j, JobThread.getDefaultTaskDescription(j), null);
    }

    public JobThread(UWSJob j, ServiceErrorWriter errorWriter) throws NullPointerException {
        this(j, JobThread.getDefaultTaskDescription(j), errorWriter);
    }

    public JobThread(UWSJob j, String task) throws NullPointerException {
        super(tg, j.getJobId());
        this.job = j;
        this.taskDescription = task;
        this.errorWriter = null;
    }

    public JobThread(UWSJob j, String task, ServiceErrorWriter errorWriter) throws NullPointerException {
        super(tg, j.getJobId());
        this.job = j;
        this.taskDescription = task;
        this.errorWriter = errorWriter;
    }

    protected static final String getDefaultTaskDescription(UWSJob job) {
        String task = "";
        task = "Executing the job " + job.getJobId();
        if (job.getJobList() != null && job.getJobList().getName() != null && !job.getJobList().getName().trim().isEmpty()) {
            JobList jl = job.getJobList();
            task = task + " (JobList: " + job.getJobList().getName();
            if (jl.getUWS() != null && jl.getUWS().getName() != null && !jl.getUWS().getName().trim().isEmpty()) {
                task = task + ", UWS: " + jl.getUWS().getName();
            }
            task = task + ")";
        }
        return task;
    }

    public final UWSJob getJob() {
        return this.job;
    }

    public final UWSFileManager getFileManager() {
        return this.job.getFileManager();
    }

    public final UWSException getError() {
        return this.lastError;
    }

    public final boolean isFinished() {
        return this.finished;
    }

    private final void complete() throws UWSException {
        if (this.isInterrupted()) {
            this.job.abort();
        } else {
            this.job.setPhase(ExecutionPhase.COMPLETED);
            this.job.setEndTime(new Date());
        }
    }

    public void setError(ErrorSummary error) throws UWSException {
        this.job.error(error);
    }

    public void setError(UWSException ue) throws UWSException {
        if (ue == null) {
            return;
        }
        try {
            ErrorSummary error = new ErrorSummary(ue, ue.getUWSErrorType(), this.job.getUrl() + "/" + "error" + "/details");
            OutputStream output = this.getFileManager().getErrorOutput(error, this.job);
            if (this.errorWriter != null) {
                this.errorWriter.writeError(ue, error, this.job, output);
            } else {
                UWSToolBox.writeErrorFile(ue, error, this.job, output);
            }
            this.setError(error);
        }
        catch (IOException ioe) {
            this.job.getLogger().logThread(UWSLog.LogLevel.ERROR, this, "SET_ERROR", "The stack trace of a UWSException had not been written!", ioe);
            this.setError(new ErrorSummary(ue.getMessage(), ue.getUWSErrorType()));
        }
    }

    public Result createResult() {
        String resultName = "result";
        if (this.job.getResult(resultName) != null) {
            int resultCount = 0;
            while (this.job.getResult(resultName = "result_" + ++resultCount) != null) {
            }
        }
        return this.createResult(resultName);
    }

    public Result createResult(String name) {
        return new Result(this.job, name);
    }

    public void publishResult(Result result) throws UWSException {
        this.job.addResult(result);
    }

    public OutputStream getResultOutput(Result resultToWrite) throws IOException, UWSException {
        return this.getFileManager().getResultOutput(resultToWrite, this.job);
    }

    public long getResultSize(Result result) throws IOException {
        return this.getFileManager().getResultSize(result, this.job);
    }

    protected abstract void jobWork() throws UWSException, InterruptedException;

    /*
     * Exception decompiling
     */
    @Override
    public final void run() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

