/*
 * Decompiled with CFR 0.152.
 */
package uws.job.jobInfo;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import javax.servlet.http.HttpServletResponse;
import uws.UWSException;
import uws.UWSToolBox;
import uws.job.UWSJob;
import uws.job.jobInfo.JobInfo;
import uws.service.log.UWSLog;
import uws.service.request.UploadFile;

public class XMLJobInfo
implements JobInfo {
    private static final long serialVersionUID = 1L;
    protected String location = null;
    protected transient UploadFile file = null;
    protected String content = null;
    protected int length = -1;
    protected transient UWSJob job = null;

    public XMLJobInfo(String smallXML) throws NullPointerException {
        if (smallXML == null || smallXML.trim().length() == 0) {
            throw new NullPointerException("Missing XML content!");
        }
        this.content = smallXML;
        this.length = smallXML.getBytes().length;
        this.file = null;
        this.location = null;
    }

    public XMLJobInfo(UploadFile xmlFile) throws NullPointerException {
        if (xmlFile == null || xmlFile.length <= 0L) {
            throw new NullPointerException("Missing XML file!");
        }
        this.file = xmlFile;
        this.location = this.file.getLocation();
        this.length = (int)this.file.length;
        this.content = null;
    }

    @Override
    public String getXML(String newLinePrefix) throws UWSException {
        if (this.content != null) {
            if (this.content.trim().startsWith("<?")) {
                return this.content.substring(this.content.indexOf("?>") + 2);
            }
            return this.content;
        }
        this.restoreFile();
        StringBuffer xml = new StringBuffer();
        BufferedReader input = null;
        try {
            String line;
            input = new BufferedReader(new InputStreamReader(this.file.open()));
            while ((line = input.readLine()) != null) {
                if (line.trim().startsWith("<?") && (line = line.substring(line.indexOf("?>") + 2)).trim().length() == 0) continue;
                if (newLinePrefix != null && xml.length() > 0) {
                    xml.append(newLinePrefix);
                }
                xml.append(line);
            }
        }
        catch (IOException ioe) {
            throw new UWSException(500, (Throwable)ioe, "Impossible to get the XML representation of the JobInfo!");
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException iOException) {}
            }
        }
        return xml.toString();
    }

    @Override
    public void write(HttpServletResponse response) throws IOException, UWSException {
        if (this.content != null) {
            response.setCharacterEncoding("UTF-8");
            response.setContentType("text/xml");
            UWSToolBox.setContentLength(response, this.content.getBytes("UTF-8").length);
            PrintWriter writer = response.getWriter();
            writer.println(this.content);
            writer.flush();
        } else {
            this.restoreFile();
            UWSToolBox.write(this.file.open(), "text/xml", this.file.length, response);
        }
    }

    @Override
    public void setJob(UWSJob myJob) {
        block3: {
            this.job = myJob;
            if (this.job != null && this.file != null) {
                try {
                    this.file.move(this.job);
                    this.location = this.file.getLocation();
                }
                catch (IOException ioe) {
                    if (this.job.getLogger() == null) break block3;
                    this.job.getLogger().logUWS(UWSLog.LogLevel.ERROR, this.job, "SET_JOB_INFO", "Error when moving the XML JobInfo file closer to the job " + this.job.getJobId() + "! Current file location: " + this.file.getLocation(), ioe);
                }
            }
        }
    }

    @Override
    public void destroy() throws UWSException {
        try {
            this.file.deleteFile();
        }
        catch (IOException ioe) {
            throw new UWSException(500, (Throwable)ioe, "Error when deleting a JobInfo file!");
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        if (this.file != null) {
            this.location = this.file.getLocation();
        }
        out.defaultWriteObject();
    }

    protected void restoreFile() throws UWSException {
        if (this.file == null && this.location != null) {
            if (this.job != null) {
                this.file = new UploadFile("UWS_JOB_DESCRIPTION", this.location, this.job.getFileManager());
            } else {
                throw new UWSException(500, "Missing jobInfo's file: impossible to display its content! Cause: missing UWSJob parent.");
            }
        }
    }
}

