/*
 * Decompiled with CFR 0.152.
 */
package uws.job.serializer;

import org.json.JSONException;
import org.json.Json4Uws;
import uws.ISO8601Format;
import uws.job.ErrorSummary;
import uws.job.JobList;
import uws.job.Result;
import uws.job.UWSJob;
import uws.job.serializer.UWSSerializer;
import uws.job.serializer.filter.JobListRefiner;
import uws.job.user.JobOwner;
import uws.service.UWS;
import uws.service.UWSUrl;

public class JSONSerializer
extends UWSSerializer {
    private static final long serialVersionUID = 1L;

    @Override
    public final String getMimeType() {
        return "application/json";
    }

    @Override
    public String getUWS(UWS uws, JobOwner user) throws JSONException {
        return Json4Uws.getJson(uws).toString();
    }

    @Override
    public String getJobList(JobList jobsList, JobOwner owner, JobListRefiner listRefiner, boolean root) throws JSONException {
        return Json4Uws.getJson(jobsList, owner, listRefiner).toString();
    }

    @Override
    public String getJob(UWSJob job, boolean root) throws JSONException {
        return Json4Uws.getJson(job, null, false).toString();
    }

    @Override
    public String getJobRef(UWSJob job, UWSUrl jobsListUrl) throws JSONException {
        return Json4Uws.getJson(job, jobsListUrl, true).toString();
    }

    @Override
    public String getJobID(UWSJob job, boolean root) throws JSONException {
        return Json4Uws.getJson("jobId", job.getJobId()).toString();
    }

    @Override
    public String getRunID(UWSJob job, boolean root) throws JSONException {
        return Json4Uws.getJson("runId", job.getRunId()).toString();
    }

    @Override
    public String getOwnerID(UWSJob job, boolean root) throws JSONException {
        if (job.getOwner() == null) {
            return "{}";
        }
        return Json4Uws.getJson("owner", job.getOwner().getPseudo()).toString();
    }

    @Override
    public String getPhase(UWSJob job, boolean root) throws JSONException {
        return Json4Uws.getJson("phase", job.getPhase().toString()).toString();
    }

    @Override
    public String getQuote(UWSJob job, boolean root) throws JSONException {
        String quoteDate = null;
        if (job.getStartTime() != null && job.getQuote() > 0L) {
            long quoteTime = job.getStartTime().getTime() + 1000L * job.getQuote();
            quoteDate = ISO8601Format.format(quoteTime);
        }
        return Json4Uws.getJson("quote", quoteDate).toString();
    }

    @Override
    public String getCreationTime(UWSJob job, boolean root) throws JSONException {
        return Json4Uws.getJson("creationTime", ISO8601Format.format(job.getCreationTime())).toString();
    }

    @Override
    public String getExecutionDuration(UWSJob job, boolean root) throws JSONException {
        return Json4Uws.getJson("executionDuration", job.getExecutionDuration()).toString();
    }

    @Override
    public String getDestructionTime(UWSJob job, boolean root) throws JSONException {
        if (job.getDestructionTime() != null) {
            return Json4Uws.getJson("destruction", ISO8601Format.format(job.getDestructionTime())).toString();
        }
        return "{}";
    }

    @Override
    public String getStartTime(UWSJob job, boolean root) throws JSONException {
        if (job.getDestructionTime() != null) {
            return Json4Uws.getJson("startTime", ISO8601Format.format(job.getDestructionTime())).toString();
        }
        return "{}";
    }

    @Override
    public String getEndTime(UWSJob job, boolean root) throws JSONException {
        if (job.getDestructionTime() != null) {
            return Json4Uws.getJson("endTime", ISO8601Format.format(job.getDestructionTime())).toString();
        }
        return "{}";
    }

    @Override
    public String getErrorSummary(ErrorSummary error, boolean root) throws JSONException {
        return Json4Uws.getJson(error).toString();
    }

    @Override
    public String getAdditionalParameters(UWSJob job, boolean root) throws JSONException {
        return Json4Uws.getJobParamsJson(job).toString();
    }

    @Override
    public String getAdditionalParameter(String paramName, Object paramValue, boolean root) throws JSONException {
        return Json4Uws.getJson(paramName, paramValue == null ? null : paramValue.toString()).toString();
    }

    @Override
    public String getResults(UWSJob job, boolean root) throws JSONException {
        return Json4Uws.getJobResultsJson(job).toString();
    }

    @Override
    public String getResult(Result result, boolean root) throws JSONException {
        return Json4Uws.getJobResultJson(result).toString();
    }
}

