/*
 * Decompiled with CFR 0.152.
 */
package uws.service;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import uws.AcceptHeader;
import uws.UWSException;
import uws.UWSExceptionFactory;
import uws.UWSToolBox;
import uws.job.ErrorSummary;
import uws.job.JobList;
import uws.job.JobThread;
import uws.job.Result;
import uws.job.UWSJob;
import uws.job.jobInfo.JobInfo;
import uws.job.parameters.DestructionTimeController;
import uws.job.parameters.ExecutionDurationController;
import uws.job.parameters.InputParamController;
import uws.job.parameters.UWSParameters;
import uws.job.serializer.JSONSerializer;
import uws.job.serializer.UWSSerializer;
import uws.job.serializer.XMLSerializer;
import uws.job.serializer.filter.JobListRefiner;
import uws.job.user.JobOwner;
import uws.service.UWS;
import uws.service.UWSFactory;
import uws.service.UWSUrl;
import uws.service.UserIdentifier;
import uws.service.actions.JobSummary;
import uws.service.backup.UWSBackupManager;
import uws.service.error.DefaultUWSErrorWriter;
import uws.service.error.ServiceErrorWriter;
import uws.service.file.LocalUWSFileManager;
import uws.service.file.UWSFileManager;
import uws.service.log.DefaultUWSLog;
import uws.service.log.UWSLog;
import uws.service.request.RequestParser;
import uws.service.request.UWSRequestParser;
import uws.service.request.UploadFile;
import uws.service.wait.BlockingPolicy;

public abstract class UWSServlet
extends HttpServlet
implements UWS,
UWSFactory {
    private static final long serialVersionUID = 1L;
    protected String name = null;
    protected String description = null;
    private Map<String, JobList> mapJobLists;
    private Map<String, UWSSerializer> serializers;
    protected String defaultSerializer = null;
    protected UserIdentifier userIdentifier = null;
    private UWSUrl urlInterpreter = null;
    protected final ArrayList<String> expectedAdditionalParams = new ArrayList(10);
    protected final HashMap<String, InputParamController> inputParamControllers = new HashMap(10);
    private UWSFileManager fileManager = null;
    protected UWSBackupManager backupManager;
    protected UWSLog logger;
    protected RequestParser requestParser;
    protected ServiceErrorWriter errorWriter;
    protected BlockingPolicy waitPolicy = null;
    protected static String lastRequestID = null;

    public final void init(ServletConfig config) throws ServletException {
        super.init(config);
    }

    public final void init() throws ServletException {
        String INIT_ERROR_MSG = "UWS initialization ERROR! Contact the administrator of the service to figure out the failure.";
        this.name = this.getServletConfig().getInitParameter("name");
        this.description = this.getServletConfig().getInitParameter("description");
        try {
            this.fileManager = this.createFileManager();
            if (this.fileManager == null) {
                throw new ServletException("UWS initialization ERROR! Contact the administrator of the service to figure out the failure.");
            }
        }
        catch (UWSException ue) {
            throw new ServletException("UWS initialization ERROR! Contact the administrator of the service to figure out the failure.", (Throwable)ue);
        }
        this.logger = new DefaultUWSLog(this);
        this.errorWriter = new DefaultUWSErrorWriter(this.logger);
        try {
            this.requestParser = this.createRequestParser(this.fileManager);
        }
        catch (UWSException ue) {
            this.logger.logUWS(UWSLog.LogLevel.FATAL, null, "INIT", "Can't create a request parser!", ue);
            throw new ServletException("UWS initialization ERROR! Contact the administrator of the service to figure out the failure.", (Throwable)ue);
        }
        this.mapJobLists = new LinkedHashMap<String, JobList>();
        this.serializers = new HashMap<String, UWSSerializer>();
        this.addSerializer(new XMLSerializer());
        this.addSerializer(new JSONSerializer());
        try {
            this.initUWS();
            this.logger.logUWS(UWSLog.LogLevel.INFO, this, "INIT", "UWS successfully initialized.", null);
        }
        catch (UWSException ue) {
            this.logger.logUWS(UWSLog.LogLevel.FATAL, null, "INIT", "Can't execute the custom initialization of this UWS service (UWSServlet.initUWS())!", ue);
            throw new ServletException("UWS initialization ERROR! Contact the administrator of the service to figure out the failure.");
        }
    }

    public abstract void initUWS() throws UWSException;

    @Override
    public void destroy() {
        if (this.backupManager != null) {
            this.backupManager.setEnabled(true);
            this.backupManager.saveAll();
            this.backupManager.setEnabled(false);
        }
        for (JobList jl : this.mapJobLists.values()) {
            jl.getExecutionManager().stopAll();
            jl.getDestructionManager().stop();
        }
        JobThread.tg.interrupt();
        if (this.logger != null) {
            this.logger.logUWS(UWSLog.LogLevel.INFO, this, "STOP", "UWS Service \"" + this.getName() + "\" stopped!", null);
        }
        super.destroy();
    }

    public UWSFileManager createFileManager() throws UWSException {
        LocalUWSFileManager fm = null;
        String rootPath = this.getServletConfig().getInitParameter("rootDirectory");
        if (rootPath == null || rootPath.trim().isEmpty()) {
            rootPath = (this.name != null && !this.name.trim().isEmpty() ? this.name.replaceAll("/", "_") : "") + "_files";
        }
        fm = rootPath.startsWith("/") ? new LocalUWSFileManager(new File(rootPath)) : new LocalUWSFileManager(new File(this.getServletContext().getRealPath("/" + rootPath)));
        return fm;
    }

    @Override
    public UWSFileManager getFileManager() {
        return this.fileManager;
    }

    @Override
    public RequestParser getRequestParser() {
        return this.requestParser;
    }

    public final void service(ServletRequest req, ServletResponse resp) throws ServletException, IOException {
        super.service(req, resp);
    }

    protected synchronized String generateRequestID(HttpServletRequest request) {
        String id;
        do {
            id = System.currentTimeMillis() + "";
        } while (lastRequestID != null && lastRequestID.startsWith(id));
        lastRequestID = id;
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected final void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String uwsAction = null;
        JobOwner user = null;
        String reqID = this.generateRequestID(req);
        req.setAttribute("UWS_REQUEST_ID", (Object)reqID);
        this.logger.logHttp(UWSLog.LogLevel.INFO, req, reqID, null, null);
        try {
            String method = req.getMethod();
            if (this.urlInterpreter == null) {
                this.setUrlInterpreter(new UWSUrl(req));
            }
            UWSUrl requestUrl = new UWSUrl(this.urlInterpreter);
            requestUrl.load(req);
            user = UWSToolBox.getUser(req, this.userIdentifier);
            resp.setCharacterEncoding("UTF-8");
            req.setAttribute("UWS_PARAMETERS", this.requestParser.parse(req));
            if (method.equals("GET")) {
                if (!requestUrl.hasJobList()) {
                    uwsAction = "Show UWS Home Page";
                    this.writeHomePage(requestUrl, req, resp, user);
                } else if (requestUrl.hasJobList() && !requestUrl.hasJob()) {
                    uwsAction = "List Jobs";
                    this.doListJob(requestUrl, req, resp, user);
                } else if (requestUrl.hasJobList() && requestUrl.hasJob() && !requestUrl.hasAttribute()) {
                    uwsAction = "Get Job";
                    this.doJobSummary(requestUrl, req, resp, user);
                } else {
                    if (!requestUrl.hasJobList() || !requestUrl.hasJobList() || !requestUrl.hasAttribute()) throw new UWSException(501, "Unknown UWS action!");
                    uwsAction = "Get Job Parameter";
                    this.doGetJobParam(requestUrl, req, resp, user);
                }
            } else if (method.equals("POST")) {
                if (!requestUrl.hasJobList()) {
                    uwsAction = "Show UWS Home Page";
                    this.writeHomePage(requestUrl, req, resp, user);
                } else if (requestUrl.hasJobList() && !requestUrl.hasJob()) {
                    uwsAction = "Add Job";
                    this.doAddJob(requestUrl, req, resp, user);
                } else if (requestUrl.hasJobList() && requestUrl.hasJob() && requestUrl.getAttributes().length == 0 && UWSToolBox.hasParameter("ACTION", "DELETE", req, false)) {
                    uwsAction = "Destroy Job";
                    this.doDestroyJob(requestUrl, req, resp, user);
                } else if (requestUrl.hasJobList() && requestUrl.hasJob() && requestUrl.getAttributes().length == 1 && requestUrl.getAttributes()[0].toLowerCase().matches(UWSParameters.UWS_RW_PARAMETERS_REGEXP) && UWSToolBox.hasParameter(requestUrl.getAttributes()[0], req, false)) {
                    uwsAction = "Set UWS Parameter";
                    this.doSetUWSParameter(requestUrl, req, resp, user);
                } else {
                    if (!requestUrl.hasJobList() || !requestUrl.hasJob() || requestUrl.hasAttribute() && (requestUrl.getAttributes().length != 1 || !requestUrl.getAttributes()[0].equalsIgnoreCase("parameters")) || UWSToolBox.getNbParameters(req) <= 0) throw new UWSException(501, "Unknown UWS action!");
                    uwsAction = "Set Job Parameter";
                    this.doSetJobParam(requestUrl, req, resp, user);
                }
            } else if (method.equals("PUT")) {
                if (requestUrl.hasJobList() && requestUrl.hasJob() && requestUrl.getAttributes().length >= 2 && requestUrl.getAttributes()[0].equalsIgnoreCase("parameters")) {
                    uwsAction = "Set Job Parameter";
                    if (!UWSToolBox.hasParameter(requestUrl.getAttributes()[1], req, false)) {
                        throw new UWSException(400, "Wrong parameter name in the PUT request! Expected: " + requestUrl.getAttributes()[1]);
                    }
                    this.doSetJobParam(requestUrl, req, resp, user);
                } else {
                    if (!requestUrl.hasJobList() || !requestUrl.hasJob() || requestUrl.getAttributes().length != 1 || !requestUrl.getAttributes()[0].toLowerCase().matches(UWSParameters.UWS_RW_PARAMETERS_REGEXP) || !UWSToolBox.hasParameter(requestUrl.getAttributes()[0], req, false)) throw new UWSException(501, "Unknown UWS action!");
                    uwsAction = "Set UWS Parameter";
                    this.doSetUWSParameter(requestUrl, req, resp, user);
                }
            } else {
                if (!method.equals("DELETE")) throw new UWSException(501, "Unknown UWS action!");
                if (!requestUrl.hasJobList() || !requestUrl.hasJob() || !req.getMethod().equalsIgnoreCase("delete")) throw new UWSException(501, "Unknown UWS action!");
                uwsAction = "Destroy Job";
                this.doDestroyJob(requestUrl, req, resp, user);
            }
            resp.flushBuffer();
            this.logger.logHttp(UWSLog.LogLevel.INFO, resp, reqID, user, "UWS action \"" + uwsAction + "\" successfully executed.", null);
            return;
        }
        catch (IOException ioe) {
            this.logger.logHttp(UWSLog.LogLevel.INFO, resp, reqID, user, "HTTP request aborted or connection with the client closed => the UWS action \"" + uwsAction + "\" has stopped and the body of the HTTP response can not have been partially or completely written!", null);
            return;
        }
        catch (UWSException ex) {
            this.sendError(ex, req, reqID, user, uwsAction, resp);
            return;
        }
        catch (IllegalStateException ise) {
            this.errorWriter.writeError(ise, resp, req, reqID, user, uwsAction);
            this.getLogger().logHttp(UWSLog.LogLevel.FATAL, resp, reqID, user, "HTTP response already partially committed => the UWS action \"" + uwsAction + "\" has stopped and the body of the HTTP response can not have been partially or completely written!", ise.getCause() != null ? ise.getCause() : ise);
            return;
        }
        catch (Throwable t) {
            this.sendError(t, req, reqID, user, uwsAction, resp);
            return;
        }
        finally {
            UWSToolBox.deleteUploads(req);
        }
    }

    public final BlockingPolicy getWaitPolicy() {
        return this.waitPolicy;
    }

    public final void setWaitPolicy(BlockingPolicy waitPolicy) {
        this.waitPolicy = waitPolicy;
    }

    protected void writeHomePage(UWSUrl requestUrl, HttpServletRequest req, HttpServletResponse resp, JobOwner user) throws UWSException, ServletException, IOException {
        String serialization;
        UWSSerializer serializer = this.getSerializer(req.getHeader("Accept"));
        resp.setContentType(serializer.getMimeType());
        resp.setCharacterEncoding("UTF-8");
        try {
            serialization = serializer.getUWS(this);
        }
        catch (Exception e) {
            if (!(e instanceof UWSException)) {
                this.getLogger().logUWS(UWSLog.LogLevel.ERROR, requestUrl, "SERIALIZE", "Can't display the default home page, due to a serialization error!", e);
                throw new UWSException(204, (Throwable)e, "No home page available for this UWS service!");
            }
            throw (UWSException)e;
        }
        if (serialization == null) {
            throw new UWSException(204, "No home page available for this UWS service.");
        }
        PrintWriter output = resp.getWriter();
        output.print(serialization);
        output.flush();
    }

    protected void doListJob(UWSUrl requestUrl, HttpServletRequest req, HttpServletResponse resp, JobOwner user) throws UWSException, ServletException, IOException {
        JobList jobsList = this.getJobList(requestUrl.getJobListName());
        UWSSerializer serializer = this.getSerializer(req.getHeader("Accept"));
        resp.setContentType(serializer.getMimeType());
        resp.setCharacterEncoding("UTF-8");
        try {
            jobsList.serialize(resp.getOutputStream(), serializer, user, new JobListRefiner(req));
        }
        catch (Exception e) {
            if (!(e instanceof UWSException)) {
                this.getLogger().logUWS(UWSLog.LogLevel.ERROR, requestUrl, "SERIALIZE", "Can not serialize the jobs list \"" + jobsList.getName() + "\"!", e);
                throw new UWSException(500, (Throwable)e, "Can not format properly the jobs list \"" + jobsList.getName() + "\"!");
            }
            throw (UWSException)e;
        }
    }

    protected void doAddJob(UWSUrl requestUrl, HttpServletRequest req, HttpServletResponse resp, JobOwner user) throws UWSException, ServletException, IOException {
        JobList jobsList = this.getJobList(requestUrl.getJobListName());
        if (user != null && !user.hasWritePermission(jobsList)) {
            throw new UWSException(550, UWSExceptionFactory.writePermissionDenied(user, true, jobsList.getName()));
        }
        UWSJob newJob = this.createJob(req, user);
        if (jobsList.addNewJob(newJob) != null) {
            if (UWSToolBox.hasParameter("phase", "RUN", req, false)) {
                newJob.start();
            }
        } else {
            throw new UWSException(500, "Unable to add the new job " + newJob.getJobId() + " to the jobs list " + jobsList.getName() + ". (ID already used = " + (jobsList.getJob(newJob.getJobId()) != null) + ")");
        }
        this.redirect(requestUrl.jobSummary(jobsList.getName(), newJob.getJobId()).getRequestURL(), req, user, "Add Job", resp);
    }

    protected void doSetUWSParameter(UWSUrl requestUrl, HttpServletRequest req, HttpServletResponse resp, JobOwner user) throws UWSException, ServletException, IOException {
        UWSJob job = this.getJob(requestUrl);
        if (user != null && !user.hasWritePermission(job)) {
            throw new UWSException(550, UWSExceptionFactory.writePermissionDenied(user, true, job.getJobId()));
        }
        String name = requestUrl.getAttributes()[0];
        job.addOrUpdateParameter(name, UWSToolBox.getParameter(name, req, false), user);
        this.redirect(requestUrl.jobSummary(requestUrl.getJobListName(), job.getJobId()).getRequestURL(), req, user, this.getName(), resp);
    }

    protected void doDestroyJob(UWSUrl requestUrl, HttpServletRequest req, HttpServletResponse resp, JobOwner user) throws UWSException, ServletException, IOException {
        JobList jobsList = this.getJobList(requestUrl.getJobListName());
        try {
            jobsList.destroyJob(requestUrl.getJobId(), user);
        }
        catch (UWSException ue) {
            this.getLogger().logUWS(UWSLog.LogLevel.ERROR, requestUrl, "DESTROY_JOB", "Can not destroy the job \"" + requestUrl.getJobId() + "\"!", ue);
            throw ue;
        }
        this.redirect(requestUrl.listJobs(jobsList.getName()).getRequestURL(), req, user, "Destroy Job", resp);
    }

    protected void doJobSummary(UWSUrl requestUrl, HttpServletRequest req, HttpServletResponse resp, JobOwner user) throws UWSException, ServletException, IOException {
        UWSJob job = this.getJob(requestUrl);
        JobSummary.block(this.waitPolicy, req, job, user);
        UWSSerializer serializer = this.getSerializer(req.getHeader("Accept"));
        resp.setContentType(serializer.getMimeType());
        resp.setCharacterEncoding("UTF-8");
        try {
            job.serialize(resp.getOutputStream(), serializer, user);
        }
        catch (Exception e) {
            if (!(e instanceof UWSException)) {
                this.getLogger().logUWS(UWSLog.LogLevel.ERROR, requestUrl, "SERIALIZE", "Can not serialize the job \"" + job.getJobId() + "\"!", e);
                throw new UWSException(500, (Throwable)e, "Can not format properly the job \"" + job.getJobId() + "\"!");
            }
            throw (UWSException)e;
        }
    }

    protected void doGetJobParam(UWSUrl requestUrl, HttpServletRequest req, HttpServletResponse resp, JobOwner user) throws UWSException, ServletException, IOException {
        UWSJob job = this.getJob(requestUrl, user);
        String[] attributes = requestUrl.getAttributes();
        if (attributes[0].equalsIgnoreCase("results") && attributes.length > 1) {
            Result result = job.getResult(attributes[1]);
            if (result == null) {
                throw new UWSException(404, "No result identified with \"" + attributes[1] + "\" in the job \"" + job.getJobId() + "\"!");
            }
            if (result.getHref() != null && !result.getHref().trim().isEmpty() && !result.getHref().equalsIgnoreCase(req.getRequestURL().toString())) {
                this.redirect(result.getHref(), req, user, "Get Job Parameter", resp);
            } else {
                try (InputStream input = null;){
                    input = this.getFileManager().getResultInput(result, job);
                    UWSToolBox.write(input, result.getMimeType(), result.getSize(), resp);
                }
            }
        } else {
            if (attributes[0].equalsIgnoreCase("error") && attributes.length > 1 && attributes[1].equalsIgnoreCase("details")) {
                ErrorSummary error = job.getErrorSummary();
                if (error == null) {
                    throw new UWSException(404, "No error summary for the job \"" + job.getJobId() + "\"!");
                }
                try (InputStream input = null;){
                    input = this.getFileManager().getErrorInput(error, job);
                    UWSToolBox.write(input, this.errorWriter.getErrorDetailsMIMEType(), this.getFileManager().getErrorSize(error, job), resp);
                }
            }
            if (attributes[0].equalsIgnoreCase("jobInfo")) {
                if (job.getJobInfo() == null) {
                    resp.sendError(204);
                } else {
                    job.getJobInfo().write(resp);
                }
            } else if (attributes[0].equalsIgnoreCase("parameters") && attributes.length > 1 && job.getAdditionalParameterValue(attributes[1]) != null && job.getAdditionalParameterValue(attributes[1]) instanceof UploadFile) {
                UploadFile upl = (UploadFile)job.getAdditionalParameterValue(attributes[1]);
                if (upl.getLocation().matches("^http(s)?://")) {
                    this.redirect(upl.getLocation(), req, user, this.getName(), resp);
                } else {
                    try (InputStream input = null;){
                        input = this.getFileManager().getUploadInput(upl);
                        UWSToolBox.write(input, upl.mimeType, upl.length, resp);
                    }
                }
            } else {
                UWSSerializer serializer = this.getSerializer(req.getHeader("Accept"));
                String uwsField = attributes[0];
                boolean jobSerialization = false;
                if (uwsField == null || uwsField.trim().isEmpty() || attributes.length <= 1 && (uwsField.equalsIgnoreCase("error") || uwsField.equalsIgnoreCase("results") || uwsField.equalsIgnoreCase("parameters"))) {
                    resp.setContentType(serializer.getMimeType());
                    jobSerialization = true;
                } else {
                    resp.setContentType("text/plain");
                }
                resp.setCharacterEncoding("UTF-8");
                try {
                    job.serialize(resp.getOutputStream(), attributes, serializer);
                }
                catch (Exception e) {
                    if (!(e instanceof UWSException)) {
                        String errorMsgPart = jobSerialization ? "the job \"" + job.getJobId() + "\"" : "the parameter " + uwsField + " of the job \"" + job.getJobId() + "\"";
                        this.getLogger().logUWS(UWSLog.LogLevel.ERROR, requestUrl, "SERIALIZE", "Can not serialize " + errorMsgPart + "!", e);
                        throw new UWSException(500, (Throwable)e, "Can not format properly " + errorMsgPart + "!");
                    }
                    throw (UWSException)e;
                }
            }
        }
    }

    protected void doSetJobParam(UWSUrl requestUrl, HttpServletRequest req, HttpServletResponse resp, JobOwner user) throws UWSException, ServletException, IOException {
        UWSJob job = this.getJob(requestUrl);
        UWSParameters params = this.getFactory().createUWSParameters(req);
        job.addOrUpdateParameters(params, user);
        this.redirect(requestUrl.jobSummary(requestUrl.getJobListName(), job.getJobId()).getRequestURL(), req, user, "Set Job Parameter", resp);
    }

    public UWSJob getJob(UWSUrl requestUrl) throws UWSException {
        return this.getJob(requestUrl, null);
    }

    public UWSJob getJob(UWSUrl requestUrl, JobOwner user) throws UWSException {
        String jobId = requestUrl.getJobId();
        UWSJob job = null;
        if (jobId != null) {
            JobList jobsList = this.getJobList(requestUrl.getJobListName());
            job = jobsList.getJob(jobId, user);
            if (job == null) {
                throw new UWSException(404, "Incorrect job ID! The job \"" + jobId + "\" does not exist in the jobs list \"" + jobsList.getName() + "\".");
            }
        } else {
            throw new UWSException(400, "Missing job ID!");
        }
        return job;
    }

    @Override
    public final UWSFactory getFactory() {
        return this;
    }

    @Override
    public UWSJob createJob(HttpServletRequest request, JobOwner user) throws UWSException {
        UWSJob newJob = new UWSJob(user, this.createUWSParameters(request));
        Object jobDesc = request.getAttribute("UWS_JOB_DESCRIPTION");
        if (jobDesc != null && jobDesc instanceof JobInfo) {
            newJob.setJobInfo((JobInfo)jobDesc);
        }
        return newJob;
    }

    @Override
    public UWSJob createJob(String jobID, long creationTime, JobOwner owner, UWSParameters params, long quote, long startTime, long endTime, List<Result> results, ErrorSummary error) throws UWSException {
        return new UWSJob(jobID, creationTime, owner, params, quote, startTime, endTime, results, error);
    }

    @Override
    public UWSParameters createUWSParameters(Map<String, Object> params) throws UWSException {
        return new UWSParameters(params, this.expectedAdditionalParams, this.inputParamControllers);
    }

    @Override
    public UWSParameters createUWSParameters(HttpServletRequest req) throws UWSException {
        return new UWSParameters(req, this.expectedAdditionalParams, this.inputParamControllers);
    }

    @Override
    public RequestParser createRequestParser(UWSFileManager fileManager) throws UWSException {
        return new UWSRequestParser(fileManager);
    }

    public void redirect(String url, HttpServletRequest request, JobOwner user, String uwsAction, HttpServletResponse response) throws ServletException, IOException {
        response.setStatus(303);
        response.setContentType(request.getContentType());
        response.setCharacterEncoding("UTF-8");
        response.setHeader("Location", url);
        response.flushBuffer();
    }

    public final void sendError(UWSException error, HttpServletRequest request, String reqID, JobOwner user, String uwsAction, HttpServletResponse response) throws ServletException {
        if (error.getHttpErrorCode() == 303) {
            this.logger.logHttp(UWSLog.LogLevel.INFO, response, reqID, user, "HTTP 303 [Redirection toward " + error.getMessage() + "] - Action \"" + uwsAction + "\" successfully executed.", null);
            try {
                this.redirect(error.getMessage(), request, user, uwsAction, response);
            }
            catch (IOException ioe) {
                this.logger.logHttp(UWSLog.LogLevel.FATAL, request, reqID, "Can not redirect the response toward " + error.getMessage(), error);
                throw new ServletException("Can not redirect the response! You should notify the administrator of the service (FATAL-" + reqID + "). However, while waiting a correction of this problem, you can manually go toward " + error.getMessage() + ".");
            }
        } else {
            this.sendError((Throwable)error, request, reqID, user, uwsAction, response);
        }
    }

    public final void sendError(Throwable error, HttpServletRequest request, String reqID, JobOwner user, String uwsAction, HttpServletResponse response) throws ServletException {
        this.errorWriter.writeError(error, response, request, reqID, user, uwsAction);
        this.logger.logHttp(UWSLog.LogLevel.ERROR, response, reqID, user, "Can not complete the UWS action \"" + uwsAction + "\", because: " + error.getMessage(), error);
    }

    @Override
    public UWSLog getLogger() {
        return this.logger;
    }

    public final ServiceErrorWriter getErrorWriter() {
        return this.errorWriter;
    }

    public final void setErrorWriter(ServiceErrorWriter errorWriter) {
        if (errorWriter != null) {
            this.errorWriter = errorWriter;
        }
    }

    public final void addExpectedAdditionalParameter(String paramName) {
        if (paramName != null && !paramName.trim().isEmpty()) {
            this.expectedAdditionalParams.add(paramName);
        }
    }

    public final int getNbExpectedAdditionalParameters() {
        return this.expectedAdditionalParams.size();
    }

    public final List<String> getExpectedAdditionalParameters() {
        return this.expectedAdditionalParams;
    }

    public final Iterator<String> expectedAdditionalParametersIterator() {
        return this.expectedAdditionalParams.iterator();
    }

    public final void removeExpectedAdditionalParam(String paramName) {
        if (paramName != null && !paramName.trim().isEmpty()) {
            this.expectedAdditionalParams.remove(paramName);
        }
    }

    public final Map<String, InputParamController> getInputParamControllers() {
        return this.inputParamControllers;
    }

    public final Iterator<Map.Entry<String, InputParamController>> getInputParamControllersIterator() {
        return this.inputParamControllers.entrySet().iterator();
    }

    public final InputParamController getInputParamController(String inputParamName) {
        return inputParamName == null ? null : this.inputParamControllers.get(inputParamName);
    }

    public final InputParamController setInputParamController(String paramName, InputParamController controller) {
        if (paramName == null || paramName.trim().isEmpty()) {
            return null;
        }
        if (controller == null) {
            return this.inputParamControllers.remove(paramName);
        }
        return this.inputParamControllers.put(paramName, controller);
    }

    public final InputParamController removeInputParamController(String paramName) {
        return paramName == null ? null : this.inputParamControllers.remove(paramName);
    }

    public final void configureExecution(long defaultDuration, long maxDuration, boolean allowModif) {
        InputParamController controller = this.inputParamControllers.get("executionDuration");
        if (controller != null && controller instanceof ExecutionDurationController) {
            ExecutionDurationController durationController = (ExecutionDurationController)controller;
            durationController.setMaxExecutionDuration(maxDuration);
            durationController.setDefaultExecutionDuration(defaultDuration);
            durationController.allowModification(allowModif);
        } else {
            this.inputParamControllers.put("executionDuration", new ExecutionDurationController(defaultDuration, maxDuration, allowModif));
        }
    }

    public final void configureDestruction(int defaultTime, DestructionTimeController.DateField defaultTimeUnit, int maxTime, DestructionTimeController.DateField maxTimeUnit, boolean allowModif) {
        DestructionTimeController destructionController;
        InputParamController controller = this.inputParamControllers.get("destruction");
        if (controller == null || !(controller instanceof DestructionTimeController)) {
            destructionController = new DestructionTimeController();
            this.inputParamControllers.put("destruction", destructionController);
        } else {
            destructionController = (DestructionTimeController)controller;
        }
        destructionController.setMaxDestructionInterval(maxTime, maxTimeUnit);
        destructionController.setDefaultDestructionInterval(defaultTime, defaultTimeUnit);
        destructionController.allowModification(allowModif);
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public final String getDescription() {
        return this.description;
    }

    @Override
    public final Iterator<JobList> iterator() {
        return this.mapJobLists.values().iterator();
    }

    @Override
    public JobList getJobList(String name) throws UWSException {
        if (name != null) {
            name = name.trim();
        }
        if (name == null || name.length() == 0) {
            throw new UWSException(400, "Missing job list name!");
        }
        if (!this.mapJobLists.containsKey(name)) {
            throw new UWSException(404, "Incorrect job list name ! The jobs list \"" + name + "\" does not exist.");
        }
        return this.mapJobLists.get(name);
    }

    @Override
    public final int getNbJobList() {
        return this.mapJobLists.size();
    }

    @Override
    public final boolean addJobList(JobList jl) {
        if (jl == null) {
            return false;
        }
        if (this.mapJobLists.containsKey(jl.getName())) {
            return false;
        }
        try {
            jl.setUWS(this);
            this.mapJobLists.put(jl.getName(), jl);
        }
        catch (IllegalStateException ise) {
            this.logger.logUWS(UWSLog.LogLevel.ERROR, jl, "ADD_JOB_LIST", "The jobs list \"" + jl.getName() + "\" can not be added into the UWS " + this.getName() + ": it may already be associated with one!", ise);
            return false;
        }
        return true;
    }

    @Override
    public final boolean destroyJobList(String name) {
        return this.destroyJobList(this.mapJobLists.get(name));
    }

    public boolean destroyJobList(JobList jl) {
        if (jl == null) {
            return false;
        }
        if ((jl = this.mapJobLists.remove(jl.getName())) != null) {
            try {
                jl.clear();
                jl.setUWS(null);
            }
            catch (IllegalStateException ise) {
                this.logger.logUWS(UWSLog.LogLevel.WARNING, jl, "DESTROY_JOB_LIST", "Impossible to erase completely the association between the jobs list \"" + jl.getName() + "\" and the UWS \"" + this.getName() + "\"!", ise);
            }
        }
        return jl != null;
    }

    public final boolean addSerializer(UWSSerializer serializer) {
        if (serializer != null) {
            this.serializers.put(serializer.getMimeType(), serializer);
            if (this.serializers.size() == 1) {
                this.defaultSerializer = serializer.getMimeType();
            }
            return true;
        }
        return false;
    }

    @Override
    public final UWSSerializer getSerializer(String mimeTypes) throws UWSException {
        UWSSerializer choosenSerializer = null;
        if (mimeTypes != null) {
            AcceptHeader accept = new AcceptHeader(mimeTypes);
            List<String> lstMimeTypes = accept.getOrderedMimeTypes();
            for (int i = 0; choosenSerializer == null && i < lstMimeTypes.size(); ++i) {
                choosenSerializer = this.serializers.get(lstMimeTypes.get(i));
            }
        }
        if (choosenSerializer == null && (choosenSerializer = this.serializers.get(this.defaultSerializer)) == null) {
            throw new UWSException(500, "Missing UWS serializer for the MIME types: " + mimeTypes + " (given MIME types) and " + this.defaultSerializer + " (default serializer MIME type)!");
        }
        return choosenSerializer;
    }

    public final UWSSerializer removeSerializer(String mimeType) {
        return this.serializers.remove(mimeType);
    }

    public final String getXsltURL() {
        XMLSerializer serializer = (XMLSerializer)this.serializers.get("text/xml");
        if (serializer != null) {
            return serializer.getXSLTPath();
        }
        return null;
    }

    public final boolean setXsltURL(String xsltPath) {
        XMLSerializer serializer = (XMLSerializer)this.serializers.get("text/xml");
        if (serializer != null) {
            serializer.setXSLTPath(xsltPath);
            return true;
        }
        return false;
    }

    @Override
    public final UserIdentifier getUserIdentifier() {
        return this.userIdentifier;
    }

    public final void setUserIdentifier(UserIdentifier identifier) {
        this.userIdentifier = identifier;
    }

    @Override
    public final UWSUrl getUrlInterpreter() {
        return this.urlInterpreter;
    }

    public final void setUrlInterpreter(UWSUrl urlInterpreter) {
        this.urlInterpreter = urlInterpreter;
        if (this.name == null && urlInterpreter != null) {
            this.name = urlInterpreter.getUWSName();
        }
    }

    @Override
    public final UWSBackupManager getBackupManager() {
        return this.backupManager;
    }
}

