/*
 * Decompiled with CFR 0.152.
 */
package org.cache2k.core;

import org.cache2k.core.AbstractEviction;
import org.cache2k.core.Entry;
import org.cache2k.core.HeapCache;
import org.cache2k.core.HeapCacheListener;
import org.cache2k.core.IntegrityState;
import org.cache2k.core.util.TunableConstants;
import org.cache2k.core.util.TunableFactory;

public class ClockProPlusEviction
extends AbstractEviction {
    private static final Tunable TUNABLE_CLOCK_PRO = TunableFactory.get(Tunable.class);
    private long hotHits;
    private long coldHits;
    private long ghostHits;
    private long hotRunCnt;
    private long hotScanCnt;
    private long coldRunCnt;
    private long coldScanCnt;
    private int coldSize;
    private int hotSize;
    private long hotMax;
    private long ghostMax;
    private Entry handCold;
    private Entry handHot;
    private Ghost[] ghosts;
    private Ghost ghostHead = new Ghost().shortCircuit();
    private int ghostSize = 0;
    private static final int GHOST_LOAD_PERCENT = 63;

    public ClockProPlusEviction(HeapCache _heapCache, HeapCacheListener _listener, long _maxSize) {
        super(_heapCache, _listener, _maxSize);
        this.ghostMax = this.maxSize / 2L + 1L;
        this.hotMax = this.maxSize * (long)ClockProPlusEviction.TUNABLE_CLOCK_PRO.hotMaxPercentage / 100L;
        this.coldSize = 0;
        this.hotSize = 0;
        this.handCold = null;
        this.handHot = null;
        this.ghosts = new Ghost[4];
    }

    private long sumUpListHits(Entry e) {
        if (e == null) {
            return 0L;
        }
        long cnt = 0L;
        Entry _head = e;
        do {
            cnt += e.hitCnt;
        } while ((e = e.next) != _head);
        return cnt;
    }

    @Override
    public long getHitCount() {
        return this.hotHits + this.coldHits + this.sumUpListHits(this.handCold) + this.sumUpListHits(this.handHot);
    }

    @Override
    public long removeAll() {
        Entry _next;
        Entry _head;
        int _count = 0;
        Entry e = _head = this.handCold;
        long _hits = 0L;
        if (e != null) {
            do {
                _hits += e.hitCnt;
                _next = e.prev;
                e.removedFromList();
                ++_count;
            } while ((e = _next) != _head);
            this.coldHits += _hits;
        }
        this.handCold = null;
        this.coldSize = 0;
        _head = this.handHot;
        e = _head;
        if (e != null) {
            _hits = 0L;
            do {
                _hits += e.hitCnt;
                _next = e.prev;
                e.removedFromList();
                ++_count;
            } while ((e = _next) != _head);
            this.hotHits += _hits;
        }
        this.handHot = null;
        this.hotSize = 0;
        return _count;
    }

    @Override
    public void removeFromReplacementListOnEvict(Entry e) {
        this.insertCopyIntoGhosts(e);
        this.removeFromReplacementList(e);
    }

    @Override
    protected void removeFromReplacementList(Entry e) {
        if (e.isHot()) {
            this.hotHits += e.hitCnt;
            this.handHot = Entry.removeFromCyclicList(this.handHot, e);
            --this.hotSize;
        } else {
            this.coldHits += e.hitCnt;
            this.handCold = Entry.removeFromCyclicList(this.handCold, e);
            --this.coldSize;
        }
    }

    private void insertCopyIntoGhosts(Entry e) {
        int hc = e.hashCode;
        Ghost g = this.lookupGhost(hc);
        if (g != null) {
            Ghost.moveToFront(this.ghostHead, g);
            return;
        }
        if ((long)this.ghostSize >= this.ghostMax) {
            g = this.ghostHead.prev;
            Ghost.removeFromList(g);
            boolean bl = this.removeGhost(g, g.hash);
        } else {
            g = new Ghost();
        }
        g.hash = hc;
        this.insertGhost(g, hc);
        Ghost.insertInList(this.ghostHead, g);
    }

    @Override
    public long getSize() {
        return this.hotSize + this.coldSize;
    }

    @Override
    protected void insertIntoReplacementList(Entry e) {
        Ghost g = this.lookupGhost(e.hashCode);
        if (g != null) {
            ++this.ghostHits;
            e.setHot(true);
            ++this.hotSize;
            this.handHot = Entry.insertIntoTailCyclicList(this.handHot, e);
            return;
        }
        ++this.coldSize;
        this.handCold = Entry.insertIntoTailCyclicList(this.handCold, e);
    }

    private Entry runHandHot() {
        int _initialMaxScan;
        Entry _hand;
        ++this.hotRunCnt;
        Entry _coldCandidate = _hand = this.handHot;
        long _lowestHits = Long.MAX_VALUE;
        long _hotHits = this.hotHits;
        int _maxScan = _initialMaxScan = this.hotSize >> 3;
        long _decrease = (_hand.hitCnt + _hand.next.hitCnt >> ClockProPlusEviction.TUNABLE_CLOCK_PRO.hitCounterDecreaseShift) + 1L;
        while (_maxScan-- > 0) {
            long _hitCnt = _hand.hitCnt;
            if (_hitCnt < _lowestHits) {
                _lowestHits = _hitCnt;
                _coldCandidate = _hand;
                if (_hitCnt == 0L) break;
            }
            if (_hitCnt < _decrease) {
                _hand.hitCnt = 0L;
                _hotHits += _hitCnt;
            } else {
                _hand.hitCnt = _hitCnt - _decrease;
                _hotHits += _decrease;
            }
            _hand = _hand.next;
        }
        this.hotHits = _hotHits;
        this.hotScanCnt += (long)(_initialMaxScan - _maxScan);
        this.handHot = Entry.removeFromCyclicList(_hand, _coldCandidate);
        --this.hotSize;
        _coldCandidate.setHot(false);
        return _coldCandidate;
    }

    @Override
    protected Entry findEvictionCandidate(Entry _previous) {
        ++this.coldRunCnt;
        Entry _hand = this.handCold;
        int _scanCnt = 1;
        if (_hand == null) {
            _hand = this.refillFromHot(_hand);
        }
        if (_hand.hitCnt > 0L) {
            _hand = this.refillFromHot(_hand);
            do {
                ++_scanCnt;
                this.coldHits += _hand.hitCnt;
                _hand.hitCnt = 0L;
                Entry e = _hand;
                _hand = Entry.removeFromCyclicList(e);
                --this.coldSize;
                e.setHot(true);
                ++this.hotSize;
                this.handHot = Entry.insertIntoTailCyclicList(this.handHot, e);
            } while (_hand != null && _hand.hitCnt > 0L);
        }
        if (_hand == null) {
            _hand = this.refillFromHot(_hand);
        }
        this.coldScanCnt += (long)_scanCnt;
        this.handCold = _hand.next;
        return _hand;
    }

    private Entry refillFromHot(Entry _hand) {
        while ((long)this.hotSize > this.hotMax || _hand == null) {
            Entry e = this.runHandHot();
            if (e == null) continue;
            _hand = Entry.insertIntoTailCyclicList(_hand, e);
            ++this.coldSize;
        }
        return _hand;
    }

    @Override
    public void checkIntegrity(IntegrityState is) {
        is.checkEquals("ghostSize == countGhostsInHash()", this.ghostSize, this.countGhostsInHash()).check("hotMax <= maxElements", this.hotMax <= this.maxSize).check("checkCyclicListIntegrity(handHot)", Entry.checkCyclicListIntegrity(this.handHot)).check("checkCyclicListIntegrity(handCold)", Entry.checkCyclicListIntegrity(this.handCold)).checkEquals("getCyclicListEntryCount(handHot) == hotSize", Entry.getCyclicListEntryCount(this.handHot), this.hotSize).checkEquals("getCyclicListEntryCount(handCold) == coldSize", Entry.getCyclicListEntryCount(this.handCold), this.coldSize).checkEquals("Ghost.listSize(ghostHead) == ghostSize", Ghost.listSize(this.ghostHead), this.ghostSize);
    }

    @Override
    public String getExtraStatistics() {
        return super.getExtraStatistics() + ", coldSize=" + this.coldSize + ", hotSize=" + this.hotSize + ", hotMaxSize=" + this.hotMax + ", ghostSize=" + this.ghostSize + ", coldHits=" + (this.coldHits + this.sumUpListHits(this.handCold)) + ", hotHits=" + (this.hotHits + this.sumUpListHits(this.handHot)) + ", ghostHits=" + this.ghostHits + ", coldRunCnt=" + this.coldRunCnt + ", coldScanCnt=" + this.coldScanCnt + ", hotRunCnt=" + this.hotRunCnt + ", hotScanCnt=" + this.hotScanCnt;
    }

    private Ghost lookupGhost(int _hash) {
        Ghost[] tab = this.ghosts;
        int n = tab.length;
        int _mask = n - 1;
        int idx = _hash & _mask;
        Ghost e = tab[idx];
        while (e != null) {
            if (e.hash == _hash) {
                return e;
            }
            e = e.another;
        }
        return null;
    }

    private void insertGhost(Ghost e2, int _hash) {
        Ghost[] tab = this.ghosts;
        int n = tab.length;
        int _mask = n - 1;
        int idx = _hash & _mask;
        e2.another = tab[idx];
        tab[idx] = e2;
        ++this.ghostSize;
        int _maxFill = n * 63 / 100;
        if (this.ghostSize > _maxFill) {
            this.expand();
        }
    }

    private void expand() {
        Ghost[] tab = this.ghosts;
        int n = tab.length;
        Ghost[] _newTab = new Ghost[n * 2];
        int _mask = _newTab.length - 1;
        for (Ghost g : tab) {
            while (g != null) {
                int idx = g.hash & _mask;
                Ghost _next = g.another;
                g.another = _newTab[idx];
                _newTab[idx] = g;
                g = _next;
            }
        }
        this.ghosts = _newTab;
    }

    private boolean removeGhost(Ghost g, int _hash) {
        Ghost[] tab = this.ghosts;
        int n = tab.length;
        int _mask = n - 1;
        int idx = _hash & _mask;
        Ghost e = tab[idx];
        if (e == g) {
            tab[idx] = e.another;
            --this.ghostSize;
            return true;
        }
        while (e != null) {
            Ghost _another = e.another;
            if (_another == g) {
                e.another = _another.another;
                --this.ghostSize;
                return true;
            }
            e = _another;
        }
        return false;
    }

    private int countGhostsInHash() {
        int _entryCount = 0;
        for (Ghost e : this.ghosts) {
            while (e != null) {
                ++_entryCount;
                e = e.another;
            }
        }
        return _entryCount;
    }

    private static class Ghost {
        int hash;
        Ghost another;
        Ghost next;
        Ghost prev;

        private Ghost() {
        }

        Ghost shortCircuit() {
            this.next = this.prev = this;
            return this.prev;
        }

        static void removeFromList(Ghost e) {
            e.prev.next = e.next;
            e.next.prev = e.prev;
            e.prev = null;
            e.next = null;
        }

        static void insertInList(Ghost _head, Ghost e) {
            e.prev = _head;
            e.next = _head.next;
            e.next.prev = e;
            _head.next = e;
        }

        static void moveToFront(Ghost _head, Ghost e) {
            Ghost.removeFromList(e);
            Ghost.insertInList(_head, e);
        }

        static int listSize(Ghost _head) {
            int _count = 0;
            Ghost e = _head;
            while ((e = e.next) != _head) {
                ++_count;
            }
            return _count;
        }
    }

    public static class Tunable
    extends TunableConstants {
        int hotMaxPercentage = 97;
        int hitCounterDecreaseShift = 6;
    }
}

