/*
 * Decompiled with CFR 0.152.
 */
package org.cache2k.impl.xmlConfiguration;

import java.util.HashMap;
import java.util.Map;
import org.cache2k.configuration.CacheType;
import org.cache2k.configuration.CacheTypeCapture;
import org.cache2k.impl.xmlConfiguration.PropertyParser;
import org.cache2k.impl.xmlConfiguration.ValueConverter;

public class StandardPropertyParser
implements PropertyParser {
    private Map<Class<?>, ValueConverter> type2parser = new HashMap();
    private static final Map<String, Long> UNIT2LONG = new HashMap<String, Long>(){
        {
            this.put("KiB", 1024L);
            this.put("MiB", 0x100000L);
            this.put("GiB", 0x40000000L);
            this.put("TiB", 0x10000000000L);
            this.put("k", 1000L);
            this.put("M", 1000000L);
            this.put("G", 1000000000L);
            this.put("T", 1000000000000L);
            this.put("s", 1000L);
            this.put("m", 60000L);
            this.put("h", 3600000L);
            this.put("d", 86400000L);
        }
    };

    public StandardPropertyParser() {
        this.addParser(Integer.TYPE, Integer.class, new ValueConverter<Integer>(){

            @Override
            public Integer parse(String v) {
                return Integer.valueOf(v);
            }
        });
        this.addParser(Boolean.TYPE, Boolean.class, new ValueConverter<Boolean>(){

            @Override
            public Boolean parse(String v) {
                if ("true".equals(v = v.toLowerCase())) {
                    return true;
                }
                if ("false".equals(v)) {
                    return false;
                }
                throw new IllegalArgumentException("no boolean, true/false expected");
            }
        });
        this.addParser(Long.TYPE, Long.class, new ValueConverter<Long>(){

            @Override
            public Long parse(String v) {
                return StandardPropertyParser.parseLongWithUnitSuffix(v);
            }
        });
        this.addParser(String.class, new ValueConverter<String>(){

            @Override
            public String parse(String v) {
                return v;
            }
        });
        this.addParser(CacheType.class, new ValueConverter<CacheType>(){

            @Override
            public CacheType parse(String v) throws Exception {
                if (!v.contains(".")) {
                    v = "java.lang." + v;
                }
                return CacheTypeCapture.of(Class.forName(v));
            }
        });
    }

    @Override
    public Object parse(Class<?> _targetType, String _value) throws Exception {
        ValueConverter p = this.type2parser.get(_targetType);
        if (p == null) {
            throw new IllegalArgumentException("Unknown target type: " + _targetType);
        }
        return p.parse(_value);
    }

    private void addParser(Class<?> _type, ValueConverter<?> p) {
        this.type2parser.put(_type, p);
    }

    private void addParser(Class<?> _primitiveType, Class<?> _type, ValueConverter<?> p) {
        this.type2parser.put(_primitiveType, p);
        this.type2parser.put(_type, p);
    }

    static long parseLongWithUnitSuffix(String v) {
        v = v.replace("_", "");
        long _multiplier = 1L;
        int pos = v.length();
        while (--pos >= 0 && !Character.isDigit(v.charAt(pos))) {
        }
        if (pos < v.length() - 1) {
            String _unitSuffix = v.substring(pos + 1);
            Long _newMultiplier = UNIT2LONG.get(_unitSuffix);
            if (_newMultiplier == null) {
                throw new NumberFormatException("Unknown unit suffix in: \"" + v + "\"");
            }
            v = v.substring(0, pos + 1);
            _multiplier = _newMultiplier;
        }
        return Long.valueOf(v) * _multiplier;
    }
}

