/*
 * Decompiled with CFR 0.152.
 */
package it.inaf.ia2.aa.jwt;

import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.spec.RSAPublicKeySpec;
import java.util.Base64;

public class Jwk {
    private static final String ALGORITHM = "RSA";
    private String kty;
    private String kid;
    private String use;
    private String n;
    private String e;

    public String getKty() {
        return this.kty;
    }

    public Jwk setKty(String kty) {
        this.kty = kty;
        return this;
    }

    public String getKid() {
        return this.kid;
    }

    public Jwk setKid(String kid) {
        this.kid = kid;
        return this;
    }

    public String getUse() {
        return this.use;
    }

    public Jwk setUse(String use) {
        this.use = use;
        return this;
    }

    public String getN() {
        return this.n;
    }

    public Jwk setN(String n) {
        this.n = n;
        return this;
    }

    public String getE() {
        return this.e;
    }

    public Jwk setE(String e) {
        this.e = e;
        return this;
    }

    public Key getKey() {
        try {
            BigInteger modulus = new BigInteger(1, Base64.getUrlDecoder().decode(this.n));
            BigInteger exponent = new BigInteger(1, Base64.getUrlDecoder().decode(this.e));
            RSAPublicKeySpec spec = new RSAPublicKeySpec(modulus, exponent);
            KeyFactory factory = KeyFactory.getInstance(ALGORITHM);
            return factory.generatePublic(spec);
        }
        catch (GeneralSecurityException ex) {
            throw new RuntimeException(ex);
        }
    }
}

