/*
 * Decompiled with CFR 0.152.
 */
package vo.parameter;

class Interval {
    private double[] range;

    Interval(String value) {
        this.range = Interval.getDaliIntervalPositiveValues(value, "Interval");
    }

    public String toString() {
        return "Interval " + this.range[0] + (String)(this.range.length > 1 ? " " + this.range[1] : "");
    }

    public static double[] getDaliIntervalPositiveValues(String value, String errorMsgPrefix) {
        double dbl;
        String[] arr = value.strip().split(" +");
        double[] dblArr = new double[2];
        if (arr == null) {
            throw new IllegalArgumentException(errorMsgPrefix + " : no value, or value contains no space");
        }
        int len = 2;
        if (arr.length != 2) {
            throw new IllegalArgumentException(errorMsgPrefix + " : must have 2 space-delimited elements, but found " + arr.length);
        }
        String val = arr[0];
        if (val.equals("Inf") || val.equals("+Inf")) {
            dblArr[0] = Double.POSITIVE_INFINITY;
        } else {
            dbl = Double.parseDouble(val);
            if (dbl < 0.0) {
                throw new IllegalArgumentException(errorMsgPrefix + " : values must be positive, but first value was " + dbl);
            }
            dblArr[0] = dbl;
        }
        val = arr[1];
        if (val.equals("-Inf")) {
            throw new IllegalArgumentException(errorMsgPrefix + " : values must be positive, but second value was " + val);
        }
        dbl = Double.parseDouble(val);
        if (dbl < 0.0) {
            throw new IllegalArgumentException(errorMsgPrefix + " : values must be positive, but second value was " + dbl);
        }
        dblArr[1] = dbl;
        return dblArr;
    }
}

