/*
 * Decompiled with CFR 0.152.
 */
package vo.parameter;

import java.util.Map;
import java.util.logging.Logger;
import vo.parameter.Circle;
import vo.parameter.Parser;
import vo.parameter.Polygon;
import vo.parameter.Range;

public class Pos {
    protected static final Logger LOGGER = Logger.getLogger("Pos");
    public String shape;
    String value;
    public System system;
    public Circle circle;
    public Range range;
    public Polygon polygon;

    public static Pos parsePos(Map<String, String[]> params, String defaultSystem) {
        return new Parser(params).getPosCirclePolygon(defaultSystem);
    }

    public Pos(String value, String valuePosSystem) {
        LOGGER.info("trace: " + value);
        this.parsePos(value);
        this.system = this.toPosSystem(valuePosSystem);
    }

    public Pos(Circle circle, String valuePosSystem) {
        this.shape = "CIRCLE";
        this.circle = circle;
        this.system = this.toPosSystem(valuePosSystem);
    }

    public Pos(Range range, String valuePosSystem) {
        this.shape = "RANGE";
        this.range = range;
        this.system = this.toPosSystem(valuePosSystem);
    }

    public Pos(Polygon polygon, String valuePosSystem) {
        this.shape = "POLYGON";
        this.polygon = polygon;
        this.system = this.toPosSystem(valuePosSystem);
    }

    private void parsePos(String str) {
        String[] strArr = str.strip().split(" +", 2);
        if (strArr.length <= 1) {
            throw new IllegalArgumentException("POS value must have more then one space-separated elements but had " + strArr.length + " elements)");
        }
        this.shape = strArr[0].strip();
        this.value = strArr[1].strip();
        if (this.shape.equals("CIRCLE")) {
            this.circle = new Circle(this.value);
        } else if (this.shape.equals("RANGE")) {
            this.range = new Range(this.value);
        } else if (this.shape.equals("POLYGON")) {
            this.polygon = new Polygon(this.value);
        } else {
            throw new IllegalArgumentException("Valid POS shape is CIRCLE or RANGE or POLYGON but was: " + this.shape);
        }
    }

    public System toPosSystem(String str) {
        for (System sys : System.values()) {
            if (!str.equals((Object)sys)) continue;
            return sys;
        }
        throw new IllegalArgumentException("Invalid POSSYS value: " + str);
    }

    public void setSystem(System system) {
        this.system = system;
    }

    public String toString() {
        String shapeStr;
        if (this.shape.equals("CIRCLE")) {
            shapeStr = this.circle.toString();
        } else if (this.shape.equals("RANGE")) {
            shapeStr = this.range.toString();
        } else if (this.shape.equals("POLYGON")) {
            shapeStr = this.polygon.toString();
        } else {
            throw new IllegalArgumentException("Valid POS shape is CIRCLE or RANGE or POLYGON but was: " + this.shape);
        }
        return "POS: " + shapeStr;
    }

    public static enum System {
        NONE,
        ICRS,
        GALACTIC;

    }
}

