/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.fits;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.EOFException;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import nom.tam.fits.AbstractTableData;
import nom.tam.fits.FitsException;
import nom.tam.fits.FitsHeap;
import nom.tam.fits.FitsUtil;
import nom.tam.fits.Header;
import nom.tam.fits.HeaderCard;
import nom.tam.fits.PaddingException;
import nom.tam.fits.header.IFitsHeader;
import nom.tam.fits.header.Standard;
import nom.tam.util.ArrayDataInput;
import nom.tam.util.ArrayDataOutput;
import nom.tam.util.ArrayFuncs;
import nom.tam.util.ColumnTable;
import nom.tam.util.Cursor;
import nom.tam.util.RandomAccess;
import nom.tam.util.TableException;

public class BinaryTable
extends AbstractTableData {
    private static final long MAX_INTEGER_VALUE = Integer.MAX_VALUE;
    private static final int MAX_EMPTY_BLOCK_SIZE = 4000000;
    private static final Logger LOG = Logger.getLogger(BinaryTable.class.getName());
    private final FitsHeap heap;
    private int heapOffset;
    private boolean heapReadFromStream = true;
    private boolean warnedOnVariableConversion = false;
    private List<ColumnDesc> columnList = new ArrayList<ColumnDesc>();
    private int nRow;
    private int rowLen;
    private ColumnTable<SaveState> table;
    private ArrayDataInput currInput;

    private static Object[] convertToColumns(Object[][] data) {
        Object[] row = data[0];
        int nrow = data.length;
        Object[] results = new Object[row.length];
        for (int col = 0; col < row.length; ++col) {
            if (row[col] instanceof String) {
                String[] sa = new String[nrow];
                for (int irow = 0; irow < nrow; ++irow) {
                    sa[irow] = (String)data[irow][col];
                }
                results[col] = sa;
                continue;
            }
            Class<?> base = ArrayFuncs.getBaseClass(row[col]);
            int[] dims = ArrayFuncs.getDimensions(row[col]);
            if (dims.length > 1 || dims[0] > 1) {
                int[] xdims = new int[dims.length + 1];
                xdims[0] = nrow;
                Object[] arr = (Object[])ArrayFuncs.newInstance(base, xdims);
                for (int irow = 0; irow < nrow; ++irow) {
                    arr[irow] = data[irow][col];
                }
                results[col] = arr;
                continue;
            }
            Object arr = ArrayFuncs.newInstance(base, nrow);
            for (int irow = 0; irow < nrow; ++irow) {
                System.arraycopy(data[irow][col], 0, arr, irow, 1);
            }
            results[col] = arr;
        }
        return results;
    }

    public static int[] getTDims(String tdims) {
        StringTokenizer st;
        int dim;
        int[] dims = null;
        int first = tdims.indexOf(40);
        int last = tdims.lastIndexOf(41);
        if (first >= 0 && last > first && (dim = (st = new StringTokenizer(tdims = tdims.substring(first + 1, last - first), ",")).countTokens()) > 0) {
            dims = new int[dim];
            for (int i = dim - 1; i >= 0; --i) {
                dims[i] = Integer.parseInt(st.nextToken().trim());
            }
        }
        return dims;
    }

    public BinaryTable() {
        try {
            this.table = this.createColumnTable(new Object[0], new int[0]);
        }
        catch (TableException e) {
            throw new IllegalStateException("Impossible exception in BinaryTable() constructor", e);
        }
        this.heap = new FitsHeap(0);
        this.saveExtraState();
        this.nRow = 0;
        this.rowLen = 0;
    }

    public BinaryTable(ColumnTable<?> tabIn) {
        ColumnTable<?> tab = tabIn;
        SaveState extra = (SaveState)tab.getExtraState();
        this.columnList = new ArrayList<ColumnDesc>();
        for (ColumnDesc col : extra.columns) {
            ColumnDesc copy = (ColumnDesc)col.clone();
            copy.column = null;
            this.columnList.add(copy);
        }
        try {
            this.table = tab.copy();
        }
        catch (Exception e) {
            throw new IllegalStateException("Unexpected Exception", e);
        }
        this.heap = extra.heap.copy();
        this.nRow = tab.getNRows();
        this.saveExtraState();
    }

    public BinaryTable(Header myHeader) throws FitsException {
        long heapSizeL = myHeader.getLongValue(Standard.PCOUNT);
        long heapOffsetL = myHeader.getLongValue(Standard.THEAP);
        if (heapOffsetL > Integer.MAX_VALUE) {
            throw new FitsException("Heap Offset > 2GB");
        }
        if (heapSizeL > Integer.MAX_VALUE) {
            throw new FitsException("Heap size > 2 GB");
        }
        if (heapSizeL - heapOffsetL > Integer.MAX_VALUE) {
            throw new FitsException("Unable to allocate heap > 2GB");
        }
        this.heapOffset = (int)heapOffsetL;
        int heapSize = (int)heapSizeL;
        int rwsz = myHeader.getIntValue(Standard.NAXIS1);
        this.nRow = myHeader.getIntValue(Standard.NAXIS2);
        if (this.heapOffset > 0) {
            this.heapOffset -= this.nRow * rwsz;
        }
        if (this.heapOffset < 0 || this.heapOffset > heapSize) {
            throw new FitsException("Inconsistent THEAP and PCOUNT");
        }
        this.heap = new FitsHeap(heapSize - this.heapOffset);
        int nCol = myHeader.getIntValue(Standard.TFIELDS);
        this.rowLen = 0;
        for (int col = 0; col < nCol; ++col) {
            this.rowLen += this.processCol(myHeader, col);
        }
        HeaderCard card = myHeader.findCard(Standard.NAXIS1);
        card.setValue(String.valueOf(this.rowLen));
        myHeader.updateLine(Standard.NAXIS1, card);
    }

    public BinaryTable(Object[] o) throws FitsException {
        this.heap = new FitsHeap(0);
        for (Object element : o) {
            this.addColumn(element);
        }
        this.createTable();
    }

    public BinaryTable(Object[][] data) throws FitsException {
        this(BinaryTable.convertToColumns(data));
    }

    @Override
    public int addColumn(Object o) throws FitsException {
        int primeDim = Array.getLength(o);
        ColumnDesc added = new ColumnDesc();
        this.columnList.add(added);
        if (this.isVarying(o)) {
            added.isVarying = true;
            ColumnDesc.access$402(added, new int[]{2});
        }
        if (this.isVaryingComp(o)) {
            added.isVarying = true;
            added.isComplex = true;
            ColumnDesc.access$402(added, new int[]{2});
        }
        if (!added.isVarying) {
            int[] allDim = ArrayFuncs.getDimensions(o);
            Class<?> base = ArrayFuncs.getBaseClass(o);
            if (base == String.class) {
                int[] xdim = new int[allDim.length + 1];
                System.arraycopy(allDim, 0, xdim, 0, allDim.length);
                xdim[allDim.length] = -1;
                allDim = xdim;
            }
            if (allDim.length == 1) {
                ColumnDesc.access$402(added, new int[0]);
            } else {
                ColumnDesc.access$402(added, new int[allDim.length - 1]);
                System.arraycopy(allDim, 1, added.dimens, 0, allDim.length - 1);
                o = ArrayFuncs.flatten(o);
            }
        }
        this.addFlattenedColumn(o, added.dimens, true);
        if (this.nRow == 0 && this.columnList.size() == 1) {
            this.nRow = primeDim;
        }
        return this.columnList.size();
    }

    public int addFlattenedColumn(Object o, int[] dims) throws FitsException {
        return this.addFlattenedColumn(o, dims, false);
    }

    int addFlattenedColumn(Object o, int[] dims, boolean allocated) throws FitsException {
        int xRow;
        ColumnDesc added;
        if (!allocated) {
            added = new ColumnDesc();
            ColumnDesc.access$402(added, dims);
        } else {
            added = this.columnList.get(this.columnList.size() - 1);
        }
        added.base = ArrayFuncs.getBaseClass(o);
        added.isBoolean = added.base == Boolean.TYPE;
        added.isString = added.base == String.class;
        o = this.arrayToColumn(added, o);
        int size = 1;
        for (int dim2 : dims) {
            size *= dim2;
        }
        added.size = size;
        if (size != 0 && this.columnList.size() > 1 && (xRow = Array.getLength(o) / size) > 0 && xRow != this.nRow) {
            throw new FitsException("Added column does not have correct row count");
        }
        if (!added.isVarying) {
            added.model = ArrayFuncs.newInstance(ArrayFuncs.getBaseClass(o), dims);
            this.rowLen += size * ArrayFuncs.getBaseLength(o);
        } else if (added.isLongVary) {
            added.model = new long[2];
            this.rowLen += 16;
        } else {
            added.model = new int[2];
            this.rowLen += 8;
        }
        added.column = o;
        if (this.table != null) {
            this.table.addColumn(o, added.size);
        }
        if (!this.columnList.contains(added)) {
            this.columnList.add(added);
        }
        return this.columnList.size();
    }

    @Override
    public int addRow(Object[] o) throws FitsException {
        this.ensureData();
        if (this.columnList.size() == 0 && this.nRow == 0) {
            for (Object element : o) {
                if (element == null) {
                    throw new FitsException("Cannot add initial rows with nulls");
                }
                this.addColumn(this.encapsulate(element));
            }
            this.createTable();
        } else {
            Object[] flatRow = new Object[this.getNCols()];
            for (int i = 0; i < this.getNCols(); ++i) {
                Object x = ArrayFuncs.flatten(o[i]);
                ColumnDesc colDesc = this.columnList.get(i);
                flatRow[i] = this.arrayToColumn(colDesc, x);
            }
            this.table.addRow(flatRow);
            ++this.nRow;
        }
        return this.nRow;
    }

    private Object arrayToColumn(ColumnDesc added, Object o) throws FitsException {
        if (!(added.isVarying || added.isBoolean || added.isComplex || added.isString)) {
            return o;
        }
        if (!added.isVarying) {
            if (added.isString) {
                int[] dims = added.dimens;
                if (dims[dims.length - 1] < 0) {
                    dims[dims.length - 1] = FitsUtil.maxLength((String[])o);
                }
                if (o instanceof String) {
                    o = new String[]{(String)o};
                }
                o = FitsUtil.stringsToByteArray((String[])o, dims[dims.length - 1]);
            } else if (added.isBoolean) {
                o = FitsUtil.booleanToByte((boolean[])o);
            }
        } else {
            if (added.isBoolean) {
                if (o instanceof boolean[]) {
                    o = new boolean[][]{(boolean[])o};
                }
                boolean[][] to = (boolean[][])o;
                byte[][] xo = new byte[to.length][];
                for (int i = 0; i < to.length; ++i) {
                    xo[i] = FitsUtil.booleanToByte(to[i]);
                }
                o = xo;
            }
            int offset = this.heap.putData(o);
            int blen = ArrayFuncs.getBaseLength(o);
            if (!(o instanceof Object[])) {
                o = new Object[]{o};
            }
            int nrow = Array.getLength(o);
            int factor = 1;
            if (added.isComplex) {
                factor = 2;
            }
            if (added.isLongVary) {
                long[] descrip = new long[2 * nrow];
                Object x = o;
                for (int i = 0; i < nrow; ++i) {
                    int len = Array.getLength(x[i]);
                    descrip[2 * i] = len;
                    descrip[2 * i + 1] = offset;
                    offset += len * blen * factor;
                }
                o = descrip;
            } else {
                int[] descrip = new int[2 * nrow];
                Object x = o;
                for (int i = 0; i < nrow; ++i) {
                    int len;
                    descrip[2 * i] = len = Array.getLength(x[i]);
                    descrip[2 * i + 1] = offset;
                    offset += len * blen * factor;
                }
                o = descrip;
            }
        }
        return o;
    }

    private boolean checkCompVary(float[][][] o) {
        boolean varying = false;
        int len0 = o[0].length;
        for (float[][] element : o) {
            if (element.length != len0) {
                varying = true;
            }
            if (element.length <= 0) continue;
            for (float[] element2 : element) {
                if (element2.length == 2) continue;
                return false;
            }
        }
        return varying;
    }

    private boolean checkDCompVary(double[][][] o) {
        boolean varying = false;
        int len0 = o[0].length;
        for (double[][] element : o) {
            if (element.length != len0) {
                varying = true;
            }
            if (element.length <= 0) continue;
            for (double[] element2 : element) {
                if (element2.length == 2) continue;
                return false;
            }
        }
        return varying;
    }

    private Object columnToArray(ColumnDesc colDesc, Object o, int rows) throws FitsException {
        if (!(colDesc.isVarying || colDesc.isBoolean || colDesc.isString || colDesc.isComplex)) {
            return o;
        }
        if (colDesc.isVarying) {
            Object[] res;
            int[] dims;
            int[] descrip;
            if (!this.heapReadFromStream) {
                this.readHeap(this.currInput);
            }
            if (colDesc.isLongVary) {
                if (!this.warnedOnVariableConversion) {
                    LOG.log(Level.WARNING, "Warning: converting long variable array pointers to int's");
                    this.warnedOnVariableConversion = true;
                }
                descrip = (int[])ArrayFuncs.convertArray(o, Integer.TYPE);
            } else {
                descrip = (int[])o;
            }
            int nrow = descrip.length / 2;
            if (colDesc.isComplex) {
                dims = new int[]{nrow, 0, 0};
                res = (Object[])ArrayFuncs.newInstance(colDesc.base, dims);
                dims = new int[2];
                dims[1] = 2;
            } else if (colDesc.isString) {
                dims = new int[]{nrow, 0};
                res = (Object[])ArrayFuncs.newInstance(Byte.TYPE, dims);
            } else {
                dims = new int[]{nrow, 0};
                res = (Object[])ArrayFuncs.newInstance(colDesc.base, dims);
            }
            for (int i = 0; i < nrow; ++i) {
                Object row;
                int offset = descrip[2 * i + 1];
                int dim = descrip[2 * i];
                if (colDesc.isComplex) {
                    dims[0] = dim;
                    row = ArrayFuncs.newInstance(colDesc.base, dims);
                } else {
                    row = colDesc.isString ? ArrayFuncs.newInstance(Byte.TYPE, dim) : (colDesc.isBoolean ? ArrayFuncs.newInstance(Byte.TYPE, dim) : ArrayFuncs.newInstance(colDesc.base, dim));
                }
                this.heap.getData(offset, row);
                if (colDesc.isBoolean) {
                    row = FitsUtil.byteToBoolean((byte[])row);
                }
                res[i] = row;
            }
            o = res;
        } else if (colDesc.isString) {
            int[] dims = colDesc.dimens;
            byte[] bytes = (byte[])o;
            if (bytes.length > 0) {
                o = dims.length > 0 ? FitsUtil.byteArrayToStrings(bytes, dims[dims.length - 1]) : FitsUtil.byteArrayToStrings(bytes, 1);
            } else {
                String[] str = new String[rows];
                for (int i = 0; i < str.length; ++i) {
                    str[i] = "";
                }
                o = str;
            }
        } else if (colDesc.isBoolean) {
            o = FitsUtil.byteToBoolean((byte[])o);
        }
        return o;
    }

    protected ColumnTable<SaveState> createColumnTable(Object[] arrCol, int[] sizes) throws TableException {
        return new ColumnTable<SaveState>(arrCol, sizes);
    }

    private ColumnTable<SaveState> createTable() throws FitsException {
        int nfields = this.columnList.size();
        Object[] arrCol = new Object[nfields];
        int[] sizes = new int[nfields];
        for (int i = 0; i < nfields; ++i) {
            ColumnDesc desc = this.columnList.get(i);
            sizes[i] = desc.size;
            if (desc.column != null) {
                arrCol[i] = desc.column;
                desc.column = null;
                continue;
            }
            arrCol[i] = ArrayFuncs.newInstance(ArrayFuncs.getBaseClass(desc.model), desc.size * this.nRow);
        }
        this.table = this.createColumnTable(arrCol, sizes);
        this.saveExtraState();
        return this.table;
    }

    @Override
    public void deleteColumns(int start, int len) throws FitsException {
        this.ensureData();
        try {
            this.rowLen = this.table.deleteColumns(start, len);
            for (int i = start + len - 1; i >= start; --i) {
                if (i < 0 || i > this.columnList.size()) continue;
                this.columnList.remove(i);
            }
        }
        catch (Exception e) {
            throw new FitsException("Error deleting columns from BinaryTable", e);
        }
    }

    @Override
    public void deleteRows(int row, int len) throws FitsException {
        this.ensureData();
        this.table.deleteRows(row, len);
        this.nRow -= len;
    }

    private Object encapsulate(Object o) {
        if (o.getClass().isArray() && ArrayFuncs.getDimensions(o).length == 1 && ArrayFuncs.getDimensions(o)[0] == 1) {
            return o;
        }
        Object[] array = (Object[])Array.newInstance(o.getClass(), 1);
        array[0] = o;
        return array;
    }

    private Object encurl(Object res, int col, int rows) {
        ColumnDesc colDesc = this.columnList.get(col);
        if (colDesc.base != String.class) {
            if (!colDesc.isVarying && colDesc.dimens.length > 0) {
                int[] dims = new int[colDesc.dimens.length + 1];
                System.arraycopy(colDesc.dimens, 0, dims, 1, colDesc.dimens.length);
                dims[0] = rows;
                res = ArrayFuncs.curl(res, dims);
            }
        } else if (colDesc.dimens.length > 1) {
            int[] dims = new int[colDesc.dimens.length];
            System.arraycopy(colDesc.dimens, 0, dims, 1, colDesc.dimens.length - 1);
            dims[0] = rows;
            res = ArrayFuncs.curl(res, dims);
        }
        return res;
    }

    private void ensureData() throws FitsException {
        this.getData();
    }

    private void ensureDataSilent() {
        try {
            this.getData();
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, "reading data of binary table failed!", e);
        }
    }

    void fillForColumn(Header h, int col, Cursor<String, HeaderCard> iter) throws FitsException {
        ColumnDesc colDesc = this.columnList.get(col);
        String tform = colDesc.isVarying ? (colDesc.isLongVary ? "1Q" : "1P") : "" + colDesc.size;
        if (colDesc.base == Integer.TYPE) {
            tform = tform + "J";
        } else if (colDesc.base == Short.TYPE || colDesc.base == Character.TYPE) {
            tform = tform + "I";
        } else if (colDesc.base == Byte.TYPE) {
            tform = tform + "B";
        } else if (colDesc.base == Float.TYPE) {
            tform = colDesc.isComplex ? tform + "C" : tform + "E";
        } else if (colDesc.base == Double.TYPE) {
            tform = colDesc.isComplex ? tform + "M" : tform + "D";
        } else if (colDesc.base == Long.TYPE) {
            tform = tform + "K";
        } else if (colDesc.base == Boolean.TYPE) {
            tform = tform + "L";
        } else if (colDesc.base == String.class) {
            tform = tform + "A";
        } else {
            throw new FitsException("Invalid column data class:" + colDesc.base);
        }
        IFitsHeader key = Standard.TFORMn.n(col + 1);
        iter.add(new HeaderCard(key.key(), tform, key.comment()));
        if (colDesc.dimens.length > 0 && !colDesc.isVarying) {
            StringBuffer tdim = new StringBuffer();
            int comma = 40;
            for (int i = colDesc.dimens.length - 1; i >= 0; --i) {
                tdim.append((char)comma);
                tdim.append(colDesc.dimens[i]);
                comma = 44;
            }
            tdim.append(')');
            key = Standard.TDIMn.n(col + 1);
            iter.add(new HeaderCard(key.key(), tdim.toString(), key.comment()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fillHeader(Header h) throws FitsException {
        try {
            Standard.context(BinaryTable.class);
            h.setXtension("BINTABLE");
            h.setBitpix(8);
            h.setNaxes(2);
            h.setNaxis(1, this.rowLen);
            h.setNaxis(2, this.nRow);
            h.addValue((IFitsHeader)Standard.PCOUNT, this.heap.size());
            h.addValue((IFitsHeader)Standard.GCOUNT, 1);
            Cursor<String, HeaderCard> iter = h.iterator();
            iter.setKey(Standard.GCOUNT.key());
            iter.next();
            iter.add(new HeaderCard(Standard.TFIELDS.key(), this.columnList.size(), Standard.TFIELDS.comment()));
            for (int i = 0; i < this.columnList.size(); ++i) {
                if (i > 0) {
                    h.positionAfterIndex(Standard.TFORMn, i);
                }
                this.fillForColumn(h, i, iter);
            }
        }
        finally {
            Standard.context(null);
        }
    }

    public Class<?>[] getBases() {
        return this.table.getBases();
    }

    @Override
    public Object getColumn(int col) throws FitsException {
        this.ensureData();
        Object res = this.getFlattenedColumn(col);
        res = this.encurl(res, col, this.nRow);
        return res;
    }

    @Override
    public ColumnTable<SaveState> getData() throws FitsException {
        if (this.table == null) {
            if (this.currInput == null) {
                throw new FitsException("Cannot find input for deferred read");
            }
            this.table = this.createTable();
            long currentOffset = FitsUtil.findOffset(this.currInput);
            FitsUtil.reposition(this.currInput, this.fileOffset);
            this.readTrueData(this.input);
            FitsUtil.reposition(this.currInput, currentOffset);
        }
        return this.table;
    }

    ColumnDesc getDescriptor(int column) {
        return this.columnList.get(column);
    }

    public int[][] getDimens() {
        int[][] dimens = new int[this.columnList.size()][];
        for (int i = 0; i < dimens.length; ++i) {
            dimens[i] = this.columnList.get(i).dimens;
        }
        return dimens;
    }

    @Override
    public Object getElement(int i, int j) throws FitsException {
        Object ele;
        if (!this.validRow(i) || !this.validColumn(j)) {
            throw new FitsException("No such element");
        }
        ColumnDesc colDesc = this.columnList.get(j);
        if (colDesc.isVarying) {
            this.ensureData();
        }
        if (this.table == null) {
            Object[] row = this.getRow(i);
            ele = row[j];
        } else {
            ele = this.table.getElement(i, j);
            ele = this.columnToArray(colDesc, ele, 1);
            if ((ele = this.encurl(ele, j, 1)) instanceof Object[]) {
                ele = ((Object[])ele)[0];
            }
        }
        return ele;
    }

    private Object[] getFileRow(int row) throws FitsException {
        ColumnDesc colDesc;
        int col;
        Object[] data = new Object[this.columnList.size()];
        for (col = 0; col < data.length; ++col) {
            colDesc = this.columnList.get(col);
            data[col] = ArrayFuncs.newInstance(ArrayFuncs.getBaseClass(colDesc.model), colDesc.size);
        }
        try {
            FitsUtil.reposition(this.currInput, this.fileOffset + (long)row * (long)this.rowLen);
            this.currInput.readLArray(data);
        }
        catch (IOException e) {
            throw new FitsException("Error in deferred row read");
        }
        for (col = 0; col < data.length; ++col) {
            colDesc = this.columnList.get(col);
            data[col] = this.columnToArray(colDesc, data[col], 1);
            data[col] = this.encurl(data[col], col, 1);
            if (!(data[col] instanceof Object[])) continue;
            data[col] = ((Object[])data[col])[0];
        }
        return data;
    }

    public Object[] getFlatColumns() {
        this.ensureDataSilent();
        return this.table.getColumns();
    }

    public Object getFlattenedColumn(int col) throws FitsException {
        this.ensureData();
        if (!this.validColumn(col)) {
            throw new FitsException("Invalid column");
        }
        Object res = this.table.getColumn(col);
        ColumnDesc colDesc = this.columnList.get(col);
        return this.columnToArray(colDesc, res, this.nRow);
    }

    public int getHeapOffset() {
        return this.heapOffset;
    }

    public int getHeapSize() {
        return this.heapOffset + this.heap.size();
    }

    private Object[] getMemoryRow(int row) throws FitsException {
        Object[] modelRow = this.getModelRow();
        Object[] data = new Object[modelRow.length];
        for (int col = 0; col < modelRow.length; ++col) {
            ColumnDesc colDesc = this.columnList.get(col);
            Object o = this.table.getElement(row, col);
            o = this.columnToArray(colDesc, o, 1);
            data[col] = this.encurl(o, col, 1);
            if (!(data[col] instanceof Object[])) continue;
            data[col] = ((Object[])data[col])[0];
        }
        return data;
    }

    public Object[] getModelRow() {
        Object[] modelRow = new Object[this.columnList.size()];
        for (int i = 0; i < modelRow.length; ++i) {
            modelRow[i] = this.columnList.get(i).model;
        }
        return modelRow;
    }

    @Override
    public int getNCols() {
        return this.columnList.size();
    }

    @Override
    public int getNRows() {
        return this.nRow;
    }

    public Object getRawElement(int i, int j) throws FitsException {
        this.ensureData();
        return this.table.getElement(i, j);
    }

    @Override
    public Object[] getRow(int row) throws FitsException {
        if (!this.validRow(row)) {
            throw new FitsException("Invalid row");
        }
        Object[] res = this.table != null ? this.getMemoryRow(row) : this.getFileRow(row);
        return res;
    }

    public int[] getSizes() {
        int[] sizes = new int[this.columnList.size()];
        for (int i = 0; i < sizes.length; ++i) {
            sizes[i] = this.columnList.get(i).size;
        }
        return sizes;
    }

    int getTFORMLength(String tform) {
        if (Character.isDigit((tform = tform.trim()).charAt(0))) {
            return this.initialNumber(tform);
        }
        return 1;
    }

    char getTFORMType(String tform) {
        for (int i = 0; i < tform.length(); ++i) {
            if (Character.isDigit(tform.charAt(i))) continue;
            return tform.charAt(i);
        }
        return '\u0000';
    }

    char getTFORMVarType(String tform) {
        int ind = tform.indexOf("P");
        if (ind < 0) {
            ind = tform.indexOf("Q");
        }
        if (tform.length() > ind + 1) {
            return tform.charAt(ind + 1);
        }
        return '\u0000';
    }

    @Override
    public long getTrueSize() {
        long len = (long)this.nRow * (long)this.rowLen;
        if (this.heap.size() > 0) {
            len += (long)(this.heap.size() + this.heapOffset);
        }
        return len;
    }

    public char[] getTypes() {
        this.ensureDataSilent();
        return this.table.getTypes();
    }

    private int initialNumber(String tform) {
        int i;
        for (i = 0; i < tform.length() && Character.isDigit(tform.charAt(i)); ++i) {
        }
        return Integer.parseInt(tform.substring(0, i));
    }

    private boolean isVarying(Object o) {
        if (!(o != null && o.getClass().isArray() && o.getClass().getComponentType().isArray() && o.getClass().getComponentType().getComponentType().isPrimitive())) {
            return false;
        }
        int oLength = Array.getLength(o);
        if (oLength < 2) {
            return false;
        }
        int flen = Array.getLength(Array.get(o, 0));
        for (int i = 1; i < oLength; ++i) {
            if (Array.getLength(Array.get(o, i)) == flen) continue;
            return true;
        }
        return false;
    }

    private boolean isVaryingComp(Object o) {
        if (o instanceof float[][][]) {
            return this.checkCompVary((float[][][])o);
        }
        if (o instanceof double[][][]) {
            return this.checkDCompVary((double[][][])o);
        }
        return false;
    }

    void pointToColumn(int col, Header hdr) throws FitsException {
        Cursor<String, HeaderCard> iter = hdr.iterator();
        if (col > 0) {
            hdr.positionAfterIndex(Standard.TFORMn, col);
        }
        this.fillForColumn(hdr, col, iter);
    }

    private int processCol(Header header, int col) throws FitsException {
        char type;
        String tform = header.getStringValue(Standard.TFORMn.n(col + 1));
        if (tform == null) {
            throw new FitsException("Attempt to process column " + (col + 1) + " but no TFORMn found.");
        }
        tform = tform.trim();
        ColumnDesc colDesc = new ColumnDesc();
        String tdims = header.getStringValue(Standard.TDIMn.n(col + 1));
        if (tdims != null) {
            tdims = tdims.trim();
        }
        if ((type = this.getTFORMType(tform)) == 'P' || type == 'Q') {
            colDesc.isVarying = true;
            colDesc.isLongVary = type == 'Q';
            type = this.getTFORMVarType(tform);
        }
        int size = this.getTFORMLength(tform);
        if (type == 'X') {
            size = (size + 8 - 1) / 8;
        } else if (colDesc.isVarying) {
            size = 2;
        }
        int bSize = size;
        int[] dims = null;
        if (tdims != null && type != 'X' && !colDesc.isVarying) {
            dims = BinaryTable.getTDims(tdims);
        }
        if (dims == null) {
            dims = size == 1 ? new int[]{} : new int[]{size};
        }
        colDesc.isComplex = type == 'C' || type == 'M';
        Class<Number> colBase = null;
        switch (type) {
            case 'A': {
                colBase = Byte.TYPE;
                colDesc.isString = true;
                colDesc.base = String.class;
                break;
            }
            case 'L': {
                colBase = Byte.TYPE;
                colDesc.base = Boolean.TYPE;
                colDesc.isBoolean = true;
                break;
            }
            case 'B': 
            case 'X': {
                colBase = Byte.TYPE;
                colDesc.base = Byte.TYPE;
                break;
            }
            case 'I': {
                colBase = Short.TYPE;
                colDesc.base = Short.TYPE;
                bSize *= 2;
                break;
            }
            case 'J': {
                colBase = Integer.TYPE;
                colDesc.base = Integer.TYPE;
                bSize *= 4;
                break;
            }
            case 'K': {
                colBase = Long.TYPE;
                colDesc.base = Long.TYPE;
                bSize *= 8;
                break;
            }
            case 'C': 
            case 'E': {
                colBase = Float.TYPE;
                colDesc.base = Float.TYPE;
                bSize *= 4;
                break;
            }
            case 'D': 
            case 'M': {
                colBase = Double.TYPE;
                colDesc.base = Double.TYPE;
                bSize *= 8;
                break;
            }
            default: {
                throw new FitsException("Invalid type in column:" + col);
            }
        }
        if (colDesc.isVarying) {
            dims = new int[]{this.nRow, 2};
            colBase = Integer.TYPE;
            bSize = 8;
            if (colDesc.isLongVary) {
                colBase = Long.TYPE;
                bSize = 16;
            }
        }
        if (!colDesc.isVarying && colDesc.isComplex) {
            int[] xdims = new int[dims.length + 1];
            System.arraycopy(dims, 0, xdims, 0, dims.length);
            xdims[dims.length] = 2;
            dims = xdims;
            bSize *= 2;
            size *= 2;
        }
        colDesc.model = ArrayFuncs.newInstance(colBase, dims);
        ColumnDesc.access$402(colDesc, dims);
        colDesc.size = size;
        this.columnList.add(colDesc);
        return bSize;
    }

    @Override
    public void read(ArrayDataInput i) throws FitsException {
        this.setFileOffset(i);
        this.currInput = i;
        if (i instanceof RandomAccess) {
            try {
                i.skipAllBytes(this.getTrueSize());
                this.heapReadFromStream = false;
            }
            catch (IOException e) {
                throw new FitsException("Unable to skip binary table HDU:" + e, e);
            }
            try {
                i.skipAllBytes(FitsUtil.padding(this.getTrueSize()));
            }
            catch (EOFException e) {
                throw new PaddingException("Missing padding after binary table", this, e);
            }
            catch (IOException e) {
                throw new FitsException("Error skipping padding after binary table", e);
            }
        }
        if (this.table == null) {
            this.table = this.createTable();
        }
        this.readTrueData(i);
    }

    protected void readHeap(ArrayDataInput input) throws FitsException {
        FitsUtil.reposition(input, this.fileOffset + (long)(this.nRow * this.rowLen) + (long)this.heapOffset);
        this.heap.read(input);
        this.heapReadFromStream = true;
    }

    protected void readTrueData(ArrayDataInput i) throws FitsException {
        try {
            this.table.read(i);
            i.skipAllBytes(this.heapOffset);
            this.heap.read(i);
            this.heapReadFromStream = true;
        }
        catch (IOException e) {
            throw new FitsException("Error reading binary table data:" + e, e);
        }
        try {
            i.skipAllBytes(FitsUtil.padding(this.getTrueSize()));
        }
        catch (EOFException e) {
            throw new PaddingException("Error skipping padding after binary table", this, e);
        }
        catch (IOException e) {
            throw new FitsException("Error reading binary table data padding", e);
        }
    }

    private void saveExtraState() {
        this.table.setExtraState(new SaveState(this.columnList, this.heap));
    }

    @Override
    public void setColumn(int col, Object xcol) throws FitsException {
        ColumnDesc colDesc = this.columnList.get(col);
        xcol = this.arrayToColumn(colDesc, xcol);
        xcol = ArrayFuncs.flatten(xcol);
        this.setFlattenedColumn(col, xcol);
    }

    boolean setComplexColumn(int index) throws FitsException {
        if (index >= 0 && index < this.columnList.size()) {
            ColumnDesc colDesc = this.columnList.get(index);
            if (colDesc.isComplex) {
                return true;
            }
            if ((colDesc.base == Float.TYPE || colDesc.base == Double.TYPE) && colDesc.dimens[colDesc.dimens.length - 1] == 2) {
                if (colDesc.isVarying) {
                    Object col = this.getFlattenedColumn(index);
                    if (col instanceof int[]) {
                        int[] ptrs = (int[])col;
                        for (int i = 1; i < ptrs.length; i += 2) {
                            if (ptrs[i] % 2 == 0) continue;
                            return false;
                        }
                    } else {
                        long[] ptrs = (long[])col;
                        for (int i = 1; i < ptrs.length; ++i) {
                            if (ptrs[i] % 2L == 0L) continue;
                            return false;
                        }
                    }
                }
                colDesc.isComplex = true;
                return true;
            }
        }
        return false;
    }

    @Override
    public void setElement(int i, int j, Object o) throws FitsException {
        this.ensureData();
        ColumnDesc colDesc = this.columnList.get(j);
        if (colDesc.isVarying) {
            int size = Array.getLength(o);
            int offset = (int)this.heap.getSize();
            this.heap.putData(o);
            if (colDesc.isLongVary) {
                this.table.setElement(i, j, new long[]{size, offset});
            } else {
                this.table.setElement(i, j, new int[]{size, offset});
            }
        } else {
            this.table.setElement(i, j, ArrayFuncs.flatten(o));
        }
    }

    public void setFlattenedColumn(int col, Object data) throws FitsException {
        this.ensureData();
        Object oldCol = this.table.getColumn(col);
        if (data.getClass() != oldCol.getClass() || Array.getLength(data) != Array.getLength(oldCol)) {
            throw new FitsException("Replacement column mismatch at column:" + col);
        }
        this.table.setColumn(col, data);
    }

    @Override
    public void setRow(int row, Object[] data) throws FitsException {
        this.ensureData();
        if (data.length != this.getNCols()) {
            throw new FitsException("Updated row size does not agree with table");
        }
        Object[] ydata = new Object[data.length];
        for (int col = 0; col < data.length; ++col) {
            Object o = ArrayFuncs.flatten(data[col]);
            ColumnDesc colDesc = this.columnList.get(col);
            ydata[col] = this.arrayToColumn(colDesc, o);
        }
        this.table.setRow(row, ydata);
    }

    @Override
    public void updateAfterDelete(int oldNcol, Header hdr) throws FitsException {
        hdr.addValue(Standard.NAXIS1, this.rowLen);
    }

    protected boolean validColumn(int j) {
        return j >= 0 && j < this.getNCols();
    }

    protected boolean validRow(int i) {
        return this.getNRows() > 0 && i >= 0 && i < this.getNRows();
    }

    @Override
    public void write(ArrayDataOutput os) throws FitsException {
        this.ensureData();
        try {
            this.table.write(os);
            if (this.heapOffset > 0) {
                int arrSiz = 4000000;
                for (int off = this.heapOffset; off > 0; off -= arrSiz) {
                    if (arrSiz > off) {
                        arrSiz = off;
                    }
                    os.write(new byte[arrSiz]);
                }
            }
            if (this.heap.size() > 0) {
                this.heap.write(os);
            }
            FitsUtil.pad(os, this.getTrueSize());
        }
        catch (IOException e) {
            throw new FitsException("Unable to write table:" + e, e);
        }
    }

    protected static class SaveState {
        private final List<ColumnDesc> columns;
        private final FitsHeap heap;

        public SaveState(List<ColumnDesc> columns, FitsHeap heap) {
            this.columns = columns;
            this.heap = heap;
        }
    }

    protected static class ColumnDesc
    implements Cloneable {
        private int size;
        private int[] dimens;
        private Class<?> base;
        private Object model;
        private boolean isVarying;
        private boolean isLongVary;
        private boolean isComplex;
        private boolean isString;
        private boolean isBoolean;
        private Object column;

        protected ColumnDesc() {
        }

        public Object clone() {
            try {
                ColumnDesc copy = (ColumnDesc)super.clone();
                if (this.getDimens() != null) {
                    this.dimens = (int[])this.getDimens().clone();
                }
                return copy;
            }
            catch (CloneNotSupportedException e) {
                throw new IllegalStateException("ColumnDesc is not clonable, but it must be!");
            }
        }

        public Class<?> getBase() {
            return this.base;
        }

        @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="intended exposure of mutable data")
        public int[] getDimens() {
            return this.dimens;
        }

        boolean isLongVary() {
            return this.isLongVary;
        }

        boolean isVarying() {
            return this.isVarying;
        }

        static /* synthetic */ int[] access$402(ColumnDesc x0, int[] x1) {
            x0.dimens = x1;
            return x1;
        }
    }
}

