
import java.util.Arrays;

class Range
{

   double lon1, lon2;
   double lat1, lat2;

   public Range(String value)
   {
      parseRange(value);
   }

   public Range(double lonCenter, double latCenter, double lonWidth, double latWidth)
   {
      lon1 = lonCenter - lonWidth/2.0;
      lon2 = lonCenter + lonWidth/2.0;
      lat1 = latCenter - latWidth/2.0;
      lat2 = latCenter + latWidth/2.0;
   }

   public Range(Circle circle)
   {
      lon1 = circle.lon - circle.radius;
      lon2 = circle.lon + circle.radius;

      lat1 = circle.lat - circle.radius;
      lat2 = circle.lat + circle.radius;
   }



   public Range(Polygon polygon)
   {
      lon1 = Arrays.stream(polygon.lon).min().getAsDouble();
      lon2 = Arrays.stream(polygon.lon).max().getAsDouble();

      lat1 = Arrays.stream(polygon.lat).min().getAsDouble();
      lat2 = Arrays.stream(polygon.lat).max().getAsDouble();
   }



   private void parseRange(String str)
   {
      String[] arr = str.strip().split(" +");

      if(arr == null)
         throw new IllegalArgumentException("RANGE : no value, or value contains no space");
      else
      {
         final int len = 4;
         if(arr.length != len)
            throw new IllegalArgumentException(
                  "RANGE : must have " + len + " elements delimited by space, but found " + arr.length);
         else
         {

            double dbl = Double.parseDouble(arr[0]);
            if ((dbl < 0) || (dbl > 360))
               throw new IllegalArgumentException("RANGE : first number must be in range [0,360] but found " + dbl);
            else
               this.lon1 = dbl;

            dbl = Double.parseDouble(arr[1]);
            if ((dbl < 0) || (dbl > 360))
               throw new IllegalArgumentException("RANGE : first number must be in range [0,360] but found " + dbl);
            else
               this.lon2 = dbl;


            dbl = Double.parseDouble(arr[2]);
            if ((dbl < -90) || (dbl > 90))
               throw new IllegalArgumentException("RANGE : second number must be in range [-90,90] but found " + dbl);
            else
               this.lat1 = dbl;

            dbl = Double.parseDouble(arr[3]);
            if ((dbl < -90) || (dbl > 90))
               throw new IllegalArgumentException("RANGE : second number must be in range [-90,90] but found " + dbl);
            else
               this.lat2 = dbl;

         }
      }
   }


   public String toString()
   {
      String str = "RANGE " + Double.valueOf(lon1) + " " + Double.valueOf(lon2)
         + " " + Double.valueOf(lat1) + " " + Double.valueOf(lat2);
      return str;
   }

}

