

class FitsCard
{
   public String key;
   public String value;
   public String comment;

   public static FitsCard[] convertToFitsCard(double restFreq, String velUnitStr)
   {
      FitsCard fitsCard_CUNIT3  = new FitsCard();
      FitsCard fitsCard_RESTFRQ = new FitsCard();

      fitsCard_CUNIT3.key = "CUNIT3";
      fitsCard_CUNIT3.value = convert_csv_vel_unit_to_fits_vel_unit(velUnitStr);
      fitsCard_CUNIT3.comment = "key added by VLKB";

      fitsCard_RESTFRQ.key = "RESTFRQ";
      fitsCard_RESTFRQ.value = String.format("%.0f",restFreq);
      fitsCard_RESTFRQ.comment = "key added by VLKB";

      FitsCard[] keyRecords = new FitsCard[2];

      keyRecords[0] = fitsCard_CUNIT3;
      keyRecords[1] = fitsCard_RESTFRQ;

      return keyRecords;

   }


   // FIXME should this go to parsing csv file ??
   private static String convert_csv_vel_unit_to_fits_vel_unit(String csv_vel_unit)
   {
      if(csv_vel_unit.equals("m.s**-1"))
      {
         return new String("'m/s'");
      }
      else if(csv_vel_unit.equals("km.s**-1"))
      {
         return new String("'km/s'");
      }
      else
      {
         return csv_vel_unit;
      }
   }

}

