/*
 * Decompiled with CFR 0.152.
 */
package uws.job;

import java.net.URL;
import uws.UWSException;
import uws.job.SerializableUWSObject;
import uws.job.UWSJob;
import uws.job.serializer.UWSSerializer;
import uws.job.user.JobOwner;
import uws.service.UWSUrl;

public class Result
extends SerializableUWSObject {
    private static final long serialVersionUID = 1L;
    public static final String DEFAULT_RESULT_NAME = "result";
    protected String id = "result";
    protected String href = null;
    protected String type = "simple";
    protected String mimeType = null;
    protected long size = -1L;
    protected final boolean redirection;

    public Result(UWSJob job, URL resultUrl) {
        if (resultUrl != null) {
            this.id = resultUrl.getFile();
            this.href = resultUrl.toString();
        }
        this.redirection = Result.isRedirectionUrl(this.href, this.id, job);
        if (!this.redirection) {
            this.href = Result.getDefaultUrl(this.id, job);
        }
    }

    public Result(UWSJob job, String name) {
        if (name != null) {
            this.id = name;
        }
        this.href = Result.getDefaultUrl(name, job);
        this.redirection = false;
    }

    public Result(UWSJob job, String name, String resultUrl) {
        if (name != null) {
            this.id = name;
        }
        this.redirection = Result.isRedirectionUrl(resultUrl, this.id, job);
        this.href = this.redirection ? resultUrl : Result.getDefaultUrl(name, job);
    }

    public Result(UWSJob job, String name, String resultType, String resultUrl) {
        this(job, name, resultUrl);
        this.type = resultType;
    }

    public Result(String name, String resultType, String resultUrl, boolean redirection) {
        this.id = name;
        this.href = resultUrl;
        this.redirection = this.href == null || this.href.trim().isEmpty() ? true : redirection;
        this.type = resultType;
    }

    public static final String getDefaultUrl(String id, UWSJob job) {
        UWSUrl url = job.getUrl();
        if (url == null) {
            return null;
        }
        url.setAttributes(new String[]{"results", id});
        return url.toString();
    }

    public static final boolean isRedirectionUrl(String url, String resultId, UWSJob job) {
        if (url == null || url.trim().isEmpty() || resultId == null || resultId.trim().isEmpty() || job == null || job.getUrl() == null) {
            return false;
        }
        return !url.equalsIgnoreCase(Result.getDefaultUrl(resultId, job).toString());
    }

    public final String getId() {
        return this.id;
    }

    public final String getHref() {
        return this.href;
    }

    public final boolean isRedirectionRequired() {
        return this.redirection;
    }

    public final String getType() {
        return this.type;
    }

    public final String getMimeType() {
        return this.mimeType;
    }

    public final void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    public final long getSize() {
        return this.size;
    }

    public final void setSize(long size) {
        this.size = size;
    }

    @Override
    public String serialize(UWSSerializer serializer, JobOwner owner) throws UWSException, Exception {
        return serializer.getResult(this, true);
    }

    public String toString() {
        return "RESULT {id: " + this.id + "; type: \"" + (this.type == null ? "?" : this.type) + "\"; href: " + (this.href == null ? "none" : this.href) + "; mimeType: " + (this.mimeType == null ? "none" : this.mimeType) + "}";
    }
}

