
import java.util.logging.Logger;
import java.util.List;
import java.util.ArrayList;


class DataLink
{
   private static final Logger LOGGER = Logger.getLogger("DataLink");

   /* DataLink fields */

   String id;
   String accessUrl;   // MX
   String serviceDef;
   String errorMessage;
   String description;  // X
   String semantics;
   String contentType;
   long  contentLength;  // MX

   /* legacy-VLKB fields */

   Inputs inputs;
   String versionString;
   String cut;
   String absCutPathname; // ServeltCutout uses
   int datacubeCount;
   NullValueCount nullVals;
   MCutResult.Cut[] mcutResultArr;


   public DataLink()
   {
      this.nullVals = new NullValueCount();
      this.versionString = Version.asString;
      this.inputs = null;
      this.datacubeCount = 1;
   }

   // FIXME fake, only to compile MCutout and Merge
   public DataLink(CutResult cutResult)
   {
      this.nullVals = new NullValueCount();

      this.id            = "_PIXEL_BOUNDS"; 
      this.accessUrl     = cutResult.filename; // FIXME filename ->> remoteUrl
      this.serviceDef    = null;
      this.errorMessage  = null;
      this.description   = "cutout_from ID";
      this.semantics     = "FIXME find in IVOA docs...";
      this.contentType   = "application/fits"; 
      this.contentLength = cutResult.filesize;

      // VLKB-extension to DataLink:
      this.inputs         = null;
      this.versionString  = Version.asString;
      this.cut            = null;
      this.absCutPathname = cutResult.filename;
      this.datacubeCount  = 1;
      this.nullVals       = cutResult.nullValueCount;
      this.mcutResultArr  = null;
   }


   public DataLink(MCutResult cutResult)
   {
      this.nullVals = new NullValueCount();

      this.id            = "_PIXEL_BOUNDS"; 
      this.accessUrl     = cutResult.fileName; // FIXME filename ->> remoteUrl
      this.serviceDef    = null;
      this.errorMessage  = null;
      this.description   = "cutout_from ID";
      this.semantics     = "FIXME find in IVOA docs...";
      this.contentType   = "application/fits"; 
      this.contentLength = cutResult.fileSize;

      // VLKB-extension to DataLink:
      this.inputs         = null;
      this.versionString  = Version.asString;
      this.cut            = null;
      this.absCutPathname = cutResult.fileName;
      this.datacubeCount  = 1;
      this.nullVals       = null;
      this.mcutResultArr  = cutResult.cutResArr;
   }


   public String convertLocalPathnameToRemoteUrl(String localPathname, String FITScutpath, String FITSRemoteUrlCutouts)
   {
      String filename = localPathname.replaceAll(FITScutpath + "/", "");
      LOGGER.info("local filename: " + filename);
      String remotefname = FITSRemoteUrlCutouts + "/" + filename;
      LOGGER.info("remote url    : " + remotefname);
      return remotefname;
   }

}

