/*
 * Decompiled with CFR 0.152.
 */
package org.cache2k.core;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.concurrent.ExecutionException;
import org.cache2k.Cache;
import org.cache2k.Cache2kBuilder;
import org.cache2k.CacheException;
import org.cache2k.CacheManager;
import org.cache2k.configuration.Cache2kConfiguration;
import org.cache2k.core.Cache2kCoreProviderImpl;
import org.cache2k.core.CacheClosedException;
import org.cache2k.core.CacheInternalError;
import org.cache2k.core.InternalCache;
import org.cache2k.core.spi.CacheLifeCycleListener;
import org.cache2k.core.spi.CacheManagerLifeCycleListener;
import org.cache2k.core.util.Log;
import org.cache2k.spi.Cache2kCoreProvider;

public class CacheManagerImpl
extends CacheManager {
    public static final Cache2kCoreProvider PROVIDER = CacheManager.PROVIDER;
    private static final Iterable<CacheLifeCycleListener> cacheLifeCycleListeners = CacheManagerImpl.constructAllServiceImplementations(CacheLifeCycleListener.class);
    private static final Iterable<CacheManagerLifeCycleListener> cacheManagerLifeCycleListeners = CacheManagerImpl.constructAllServiceImplementations(CacheManagerLifeCycleListener.class);
    private final Object lock = new Object();
    private Log log;
    private String name;
    private Map<String, InternalCache> cacheNames = new HashMap<String, InternalCache>();
    private final Properties properties = new Properties();
    private final ClassLoader classLoader;
    private boolean defaultManager;
    private Cache2kCoreProviderImpl provider;
    private boolean closing;

    private static <S> Iterable<S> constructAllServiceImplementations(Class<S> _service) {
        ClassLoader cl = CacheManagerImpl.class.getClassLoader();
        ArrayList<S> li = new ArrayList<S>();
        Iterator<S> it = ServiceLoader.load(_service, cl).iterator();
        while (it.hasNext()) {
            try {
                li.add(it.next());
            }
            catch (ServiceConfigurationError ex) {
                Log.getLog(CacheManager.class.getName()).debug("Error loading service '" + _service + "'", ex);
            }
        }
        final Object[] a = (Object[])Array.newInstance(_service, li.size());
        li.toArray(a);
        return new Iterable<S>(){

            @Override
            public Iterator<S> iterator() {
                return new Iterator<S>(){
                    private int pos = 0;

                    @Override
                    public boolean hasNext() {
                        return this.pos < a.length;
                    }

                    @Override
                    public S next() {
                        return a[this.pos++];
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    public CacheManagerImpl(Cache2kCoreProviderImpl _provider, ClassLoader cl, String _name, boolean _default) {
        this.provider = _provider;
        this.defaultManager = _default;
        this.classLoader = cl;
        this.name = _name;
        this.log = Log.getLog(CacheManager.class.getName() + '.' + this.name);
        for (CacheManagerLifeCycleListener lc : cacheManagerLifeCycleListeners) {
            lc.managerCreated(this);
        }
        this.logPhase("open");
    }

    public static Iterable<CacheLifeCycleListener> getCacheLifeCycleListeners() {
        return cacheLifeCycleListeners;
    }

    public void sendCreatedEvent(Cache c, Cache2kConfiguration _configuration) {
        for (CacheLifeCycleListener e : cacheLifeCycleListeners) {
            e.cacheCreated(c, _configuration);
        }
    }

    private void sendDestroyedEvent(Cache c) {
        for (CacheLifeCycleListener e : cacheLifeCycleListeners) {
            e.cacheDestroyed(c);
        }
    }

    public static void checkName(String s) {
        for (char c : s.toCharArray()) {
            if (c == '.' || c == '-' || c == '~' || c == ',' || c == '@' || c == ' ' || c == '(' || c == ')' || c == '+' || c == '!' || c == '\'' || c == '%' || c == '#' || c >= ' ' && c < '\u007f' && Character.isJavaIdentifierPart(c)) continue;
            throw new IllegalArgumentException("Cache name contains illegal character: '" + c + "', name=\"" + s + "\"");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String newCache(InternalCache c, String _requestedName) {
        Object object = this.lock;
        synchronized (object) {
            this.checkClosed();
            String _name = _requestedName;
            if (this.cacheNames.containsKey(_name)) {
                throw new IllegalStateException("Cache already created: '" + _requestedName + "'");
            }
            CacheManagerImpl.checkName(_name);
            this.cacheNames.put(_name, c);
            return _name;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cacheDestroyed(Cache c) {
        Object object = this.lock;
        synchronized (object) {
            this.cacheNames.remove(c.getName());
            this.sendDestroyedEvent(c);
        }
    }

    public boolean isDefaultManager() {
        return this.defaultManager;
    }

    public String getName() {
        return this.name;
    }

    public Iterable<Cache> getActiveCaches() {
        return this.cachesCopy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Iterable<Cache> cachesCopy() {
        HashSet<Cache> _caches = new HashSet<Cache>();
        Object object = this.lock;
        synchronized (object) {
            if (!this.isClosed()) {
                for (Cache cache : this.cacheNames.values()) {
                    if (cache.isClosed()) continue;
                    _caches.add(cache);
                }
            }
        }
        return _caches;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<String> getActiveCacheNames() {
        HashSet<String> _caches = new HashSet<String>();
        Object object = this.lock;
        synchronized (object) {
            if (!this.isClosed()) {
                for (Cache cache : this.cacheNames.values()) {
                    if (cache.isClosed()) continue;
                    _caches.add(cache.getName());
                }
            }
        }
        return _caches;
    }

    public Iterable<String> getConfiguredCacheNames() {
        return Cache2kCoreProviderImpl.CACHE_CONFIGURATION_PROVIDER.getConfiguredCacheNames(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <K, V> Cache<K, V> getCache(String name) {
        Object object = this.lock;
        synchronized (object) {
            Cache c = this.cacheNames.get(name);
            return c != null && c.isClosed() ? null : c;
        }
    }

    public <K, V> Cache<K, V> createCache(Cache2kConfiguration<K, V> cfg) {
        return Cache2kBuilder.of(cfg).manager((CacheManager)this).build();
    }

    public void clear() {
        for (Cache c : this.cachesCopy()) {
            try {
                c.clear();
            }
            catch (CacheClosedException cacheClosedException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Iterable<Cache> _caches;
        if (this.isDefaultManager() && ((Object)((Object)this)).getClass().getClassLoader() == this.classLoader) {
            this.log.info("Closing default CacheManager");
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.closing) {
                return;
            }
            _caches = this.cachesCopy();
            this.closing = true;
        }
        this.logPhase("close");
        ArrayList<Throwable> _suppressedExceptions = new ArrayList<Throwable>();
        for (Cache c : _caches) {
            ((InternalCache)c).cancelTimerJobs();
        }
        for (Cache c : _caches) {
            try {
                c.close();
            }
            catch (Throwable throwable) {
                _suppressedExceptions.add(throwable);
            }
        }
        try {
            for (CacheManagerLifeCycleListener lc : cacheManagerLifeCycleListeners) {
                lc.managerDestroyed(this);
            }
        }
        catch (Throwable t) {
            _suppressedExceptions.add(t);
        }
        ((Cache2kCoreProviderImpl)PROVIDER).removeManager(this);
        Object object2 = this.lock;
        synchronized (object2) {
            for (Cache cache : this.cacheNames.values()) {
                this.log.warn("unable to close cache: " + cache.getName());
            }
        }
        CacheManagerImpl.eventuallyThrowException(_suppressedExceptions);
        this.cacheNames = null;
    }

    static void eventuallyThrowException(List<Throwable> _suppressedExceptions) {
        if (_suppressedExceptions.isEmpty()) {
            return;
        }
        Throwable _error = null;
        for (Throwable t : _suppressedExceptions) {
            if (t instanceof Error) {
                _error = t;
                break;
            }
            if (!(t instanceof ExecutionException) || !(t.getCause() instanceof Error)) continue;
            _error = t.getCause();
            break;
        }
        String _text = "Exception(s) during shutdown";
        if (_suppressedExceptions.size() > 1) {
            _text = " (" + (_suppressedExceptions.size() - 1) + " more suppressed exceptions)";
        }
        if (_error != null) {
            throw new CacheInternalError(_text, _error);
        }
        throw new CacheException(_text, _suppressedExceptions.get(0));
    }

    public Properties getProperties() {
        return this.properties;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public String getVersion() {
        return this.provider.getVersion();
    }

    public Cache2kCoreProviderImpl getProvider() {
        return this.provider;
    }

    public boolean isClosed() {
        return this.closing;
    }

    public Object getLockObject() {
        return this.lock;
    }

    private void checkClosed() {
        if (this.closing) {
            throw new IllegalStateException("CacheManager already closed");
        }
    }

    private void logPhase(String _phase) {
        if (this.log.isDebugEnabled()) {
            this.log.debug(_phase + ": " + this.getManagerId());
        }
    }

    private String getManagerId() {
        return "name='" + this.name + "', objectId=" + Integer.toString(System.identityHashCode((Object)this), 36) + ", classloaderId=" + Integer.toString(System.identityHashCode(this.classLoader), 36) + ", default=" + this.defaultManager;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("CacheManager(");
        sb.append(this.getManagerId());
        if (this.isClosed()) {
            sb.append(", closed=true");
        } else {
            sb.append(", activeCaches=");
            sb.append(this.getActiveCacheNames());
        }
        return sb.append(')').toString();
    }
}

