/*
 * Decompiled with CFR 0.152.
 */
package it.inaf.ia2.client;

import java.io.InputStream;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.Scanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpErrorLoggingUtils {
    public static <T> void logServerError(HttpRequest request, HttpResponse<T> response) {
        if (response.body() instanceof String) {
            HttpErrorLoggingUtils.logServerErrorString(request, response);
        } else if (response.body() instanceof InputStream) {
            HttpErrorLoggingUtils.logServerErrorInputStream(request, response);
        } else {
            throw new UnsupportedOperationException("Unable to log error for response body type " + response.body().getClass().getCanonicalName());
        }
    }

    public static void logServerErrorString(HttpRequest request, HttpResponse<String> response) {
        HttpErrorLoggingUtils.getCallerLogger().error("Error while reading " + request.uri() + "\nServer response status code is " + response.statusCode() + "\nServer response text is " + response.body());
    }

    public static void logServerErrorInputStream(HttpRequest request, HttpResponse<InputStream> response) {
        Scanner s = new Scanner(response.body()).useDelimiter("\\A");
        String responseBody = s.hasNext() ? s.next() : "";
        String error = "Error while reading " + request.uri() + "\nServer response status code is " + response.statusCode() + "\nServer response text is " + responseBody;
        HttpErrorLoggingUtils.getCallerLogger().error(error);
    }

    private static Logger getCallerLogger() {
        Class<?> callerClass = Thread.currentThread().getStackTrace()[3].getClass();
        return LoggerFactory.getLogger(callerClass);
    }
}

