/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.util.array;

import java.lang.reflect.Array;
import nom.tam.util.array.MultiArrayPointer;

public class MultiArrayIterator {
    private final Object baseArray;
    private final boolean baseIsNoSubArray;
    private boolean baseNextCalled = false;
    private final MultiArrayPointer pointer;

    public MultiArrayIterator(Object baseArray) {
        this.baseArray = baseArray;
        this.baseIsNoSubArray = !MultiArrayPointer.isSubArray(this.baseArray);
        this.pointer = new MultiArrayPointer(this.baseArray);
    }

    public Class<?> deepComponentType() {
        Class<?> clazz = this.baseArray.getClass();
        while (clazz.isArray()) {
            clazz = clazz.getComponentType();
        }
        return clazz;
    }

    public Object next() {
        if (this.baseIsNoSubArray) {
            if (this.baseNextCalled) {
                return null;
            }
            this.baseNextCalled = true;
            return this.baseArray;
        }
        Object result = null;
        while (result == null || Array.getLength(result) == 0) {
            result = this.pointer.next();
            if (result != MultiArrayPointer.END) continue;
            return null;
        }
        return result;
    }

    public void reset() {
        if (this.baseIsNoSubArray) {
            this.baseNextCalled = false;
        } else {
            this.pointer.reset();
        }
    }

    public int size() {
        Object next;
        int size = 0;
        while ((next = this.next()) != null) {
            size += Array.getLength(next);
        }
        return size;
    }
}

