
#include "io.hpp"

#include <string>
#include <fstream>
#include <chrono>
#include <ctime>  

#include <unistd.h> // getpid  
#include <sys/types.h> // pid_t ?
#include <sys/syscall.h> // syscall NR_gettid

using namespace std;

std::ofstream LOG_STREAM;



void LOG_open(string log_dir, string log_filename)
{
	//pid_t pid = getpid();
	//long int tid = syscall(__NR_gettid);

	std::string log_pathname = log_dir + "/" + log_filename;
	//std::string log_pathname = log_dir + "/" + log_filename + "-" + to_string(pid) + "-" + to_string(tid);
	LOG_STREAM.open(log_pathname, std::ios::out);
	if (LOG_STREAM) 
	{
		LOG_STREAM << "LOG_start";
		auto nnn = std::chrono::system_clock::now();
		std::time_t now_time = std::chrono::system_clock::to_time_t(nnn);
		LOG_STREAM << " " << ctime(&now_time) << std::endl;
	}
}


void LOG_close()
{ 
	if (LOG_STREAM) 
	{
		LOG_STREAM << "LOG___end";
		auto nnn = std::chrono::system_clock::now();
		std::time_t now_time = std::chrono::system_clock::to_time_t(nnn);
		LOG_STREAM << " " << ctime(&now_time) << std::endl;
		LOG_STREAM.close();
	}
}

void LOG_trace(const std::string line)
{
	if(LOG_STREAM) LOG_STREAM << "TRC " + line << std::endl;
}

