#ifndef SQLSCHEMA_INSERT_HPP
#define SQLSCHEMA_INSERT_HPP

#include <string>
#include <vector>

#include "SqlSchema.hpp"
#include "SqlSurvey.hpp"

#include "fitsfiles.hpp" // Hdu needed
#include "ObsCoreKeys.hpp"


std::string createPubdid(const std::string path, const std::string filename, unsigned int hdunum);

class SqlSchema_INSERT : public SqlSchema
{
   public:

      //      void appendRow(/*const int hid, const int sid,*/
      //            const std::string& obscore_publisher,
      //            const std::string& obscore_access_format,
      //            const std::string& obscore_access_url,
      //            const Survey& surv, const std::string& authGroups,
      //           /*const*/ fitsfiles::Hdu& hdu,
      ////            ObsCoreKeys ocKeys,
      //            const std::string& filename, const uintmax_t filesize);

      void appendRow(
            // mandatory
            const int calib_level,
            const std::string& obs_collection,
            const std::string& obs_id,
            const std::string& obs_publisher_did,
            // optional
            const std::string& access_url,
            const std::string& access_format,
            const uintmax_t access_estsize,
            // optional
            const fitsfiles::Hdu& hdu,  // header
            const Survey& surv,         // metadata
            // optional
            const std::string& auth_groups); // security


      std::vector<std::string> getINSERT(void);

};


#endif
