/*
 * Decompiled with CFR 0.152.
 */
package it.inaf.ia2.aa;

import it.inaf.ia2.aa.AuthConfig;
import it.inaf.ia2.aa.SimpleGmsClient;
import it.inaf.ia2.aa.data.User;
import it.inaf.ia2.aa.jwt.InvalidTokenException;
import it.inaf.ia2.aa.jwt.JwksClient;
import it.inaf.ia2.aa.jwt.TokenParser;
import it.inaf.ia2.rap.client.RapClient;
import it.inaf.ia2.rap.client.call.TokenResponse;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.cache2k.Cache;
import org.cache2k.Cache2kBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserManager {
    private static final Logger LOG = LoggerFactory.getLogger(UserManager.class);
    private final AuthConfig config;
    private final RapClient rapClient;
    private JwksClient jwksClient;
    private TokenParser tokenParser;
    private SimpleGmsClient gmsClient;
    private final Cache<String, List<String>> groupsCache;

    public UserManager(AuthConfig config, RapClient rapClient, SimpleGmsClient gmsClient) {
        this.config = config;
        this.rapClient = rapClient;
        if (gmsClient != null) {
            this.gmsClient = gmsClient;
        }
        this.groupsCache = new Cache2kBuilder<String, List<String>>(){}.expireAfterWrite((long)config.getGroupsCacheExpiration(), TimeUnit.MINUTES).build();
    }

    public User getUserFromTokenResponse(TokenResponse tokenResponse) {
        return this.getUser(claims -> {
            User user = new User();
            this.setTokenResponse(user, tokenResponse);
            return user;
        }, tokenResponse.getIdToken());
    }

    public User getUserFromAccessToken(String accessToken) {
        return this.getUser(claims -> {
            User user = new User();
            user.setAccessToken(accessToken);
            return user;
        }, accessToken);
    }

    private User getUser(Function<Map<String, Object>, User> userFactory, String token) {
        Map<String, Object> claims = this.parseIdTokenClaims(token);
        this.validateClaims(claims);
        User user = userFactory.apply(claims);
        user.setUserId((String)claims.get("sub"));
        if (claims.containsKey("name")) {
            user.setUserLabel((String)claims.get("name"));
        } else {
            user.setUserLabel((String)claims.get("email"));
        }
        user.setExpirationTime(this.getExptime(claims));
        if (this.gmsClient != null && this.config.groupsAutoload()) {
            List groups = (List)this.groupsCache.computeIfAbsent((Object)user.getName(), () -> this.gmsClient.getGroups(this.config.getGroupsPrefix(), token));
            user.setGroups(groups);
        }
        return user;
    }

    public Map<String, Object> parseIdTokenClaims(String idToken) {
        return this.tokenParser.getClaims(idToken);
    }

    public void addJwksUri(URI jwksUri) {
        if (this.jwksClient == null) {
            this.jwksClient = new JwksClient(jwksUri);
            this.tokenParser = new TokenParser(this.jwksClient);
        } else {
            this.jwksClient.addJwksUri(jwksUri);
        }
    }

    private int getExptime(Map<String, Object> claims) {
        Number expTime = (Number)claims.get("exp");
        return expTime instanceof Integer ? ((Integer)expTime).intValue() : Long.valueOf((Long)expTime).intValue();
    }

    private void validateClaims(Map<String, Object> claims) {
        if (!claims.containsKey("sub")) {
            throw new InvalidTokenException("Missing sub claim in id token");
        }
        if (!claims.containsKey("exp")) {
            throw new InvalidTokenException("Missing exp claim in id token");
        }
    }

    public User refreshToken(HttpServletRequest request) {
        HttpSession session = request.getSession(false);
        if (session == null) {
            throw new IllegalStateException("Unable to retrieve user from session. Session not set");
        }
        User user = (User)session.getAttribute("user_data");
        if (user == null) {
            throw new IllegalStateException("User not found in session while trying to refresh tokens");
        }
        LOG.trace("Refreshing token for user {}", (Object)user.getName());
        TokenResponse tokenResponse = this.rapClient.refreshToken(user.getRefreshToken(), this.config.getScope(), (Object)request);
        this.setTokenResponse(user, tokenResponse);
        session.setAttribute("user_data", (Object)user);
        return user;
    }

    private void setTokenResponse(User user, TokenResponse tokenResponse) {
        user.setAccessToken(tokenResponse.getAccessToken());
        user.setIdToken(tokenResponse.getIdToken());
        user.setRefreshToken(tokenResponse.getRefreshToken());
        user.setExpiresIn(tokenResponse.getExpiresIn());
    }
}

