/*
 * Decompiled with CFR 0.152.
 */
package vo.parameter;

import java.util.Iterator;
import java.util.Map;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import vo.parameter.Parser;

public class Polygon {
    private static final String ARG_POLYGON = "POLYGON";
    public double[] lon;
    public double[] lat;

    public static Polygon parsePolygon(Map<String, String[]> params) {
        String value = Parser.getSingleValue(params, ARG_POLYGON);
        if (value == null) {
            return null;
        }
        return new Polygon(value);
    }

    public static Polygon parsePolygonFromJson(String jsonString) {
        JSONParser parser = new JSONParser();
        double[] lon = null;
        double[] lat = null;
        try {
            JSONObject jObj = (JSONObject)parser.parse(jsonString);
            JSONArray jLon = (JSONArray)jObj.get((Object)"lon");
            JSONArray jLat = (JSONArray)jObj.get((Object)"lat");
            if (jLon.size() != jLat.size()) {
                throw new IllegalArgumentException("POLYGON's lon and lat arrays must be the same length but is Lon: " + jLon.size() + " and Lat: " + jLat.size());
            }
            lon = new double[jLon.size()];
            Iterator it = jLon.iterator();
            int ix = 0;
            while (it.hasNext()) {
                lon[ix++] = (Double)it.next();
            }
            lat = new double[jLat.size()];
            it = jLat.iterator();
            ix = 0;
            while (it.hasNext()) {
                lat[ix++] = (Double)it.next();
            }
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return new Polygon(lon, lat);
    }

    public Polygon(double[] lon, double[] lat) {
        this.lon = lon;
        this.lat = lat;
    }

    public Polygon(String value) {
        this.parsePolygon(value);
    }

    private void parsePolygon(String str) {
        boolean isEven;
        String[] arr = str.strip().split(" +");
        if (arr == null) {
            throw new IllegalArgumentException("POLYGON : no value, or value contains no space");
        }
        int minLen = 6;
        if (arr.length < 6) {
            throw new IllegalArgumentException("POLYGON : must have at least 6 elements delimited by space, but found " + arr.length);
        }
        boolean bl = isEven = arr.length % 2 == 0;
        if (!isEven) {
            throw new IllegalArgumentException("POLYGON must have even number of values, but has " + arr.length);
        }
        this.lon = new double[arr.length / 2];
        this.lat = new double[arr.length / 2];
        for (int ii = 0; ii < arr.length - 1; ii += 2) {
            double dbl = Double.parseDouble(arr[ii]);
            if (dbl < 0.0 || dbl > 360.0) {
                throw new IllegalArgumentException("POLYGON : first number must be in range [0,360] but found " + dbl);
            }
            this.lon[ii / 2] = dbl;
            dbl = Double.parseDouble(arr[ii + 1]);
            if (dbl < -90.0 || dbl > 90.0) {
                throw new IllegalArgumentException("POLYGON : second number must be in range [-90,90] but found " + dbl);
            }
            this.lat[ii / 2] = dbl;
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(ARG_POLYGON);
        int ii = 0;
        sb.append(String.valueOf(this.lon[ii]) + " " + String.valueOf(this.lat[ii]));
        for (ii = 1; ii < this.lon.length; ++ii) {
            sb.append(" " + String.valueOf(this.lon[ii]) + " " + String.valueOf(this.lat[ii]));
        }
        return sb.toString();
    }

    public String toJsonString() {
        return this.toJsonObject().toString();
    }

    public JSONObject toJsonObject() {
        JSONObject jObj = new JSONObject();
        JSONArray jLonArr = new JSONArray();
        for (double dbl : this.lon) {
            jLonArr.add((Object)dbl);
        }
        JSONArray jLatArr = new JSONArray();
        for (double dbl : this.lat) {
            jLatArr.add((Object)dbl);
        }
        jObj.put((Object)"lon", (Object)jLonArr);
        jObj.put((Object)"lat", (Object)jLatArr);
        return jObj;
    }
}

