/*
 *  This was taken from UWSLibrary DefaultJobOwner because that is final class
 *  we need to add only 
 */

import java.util.HashMap;
import java.util.Map;
import java.util.Set;

import uws.job.JobList;
import uws.job.UWSJob;
import uws.job.user.JobOwner;



public final class UWSMCutoutJobOwner implements JobOwner {

   private AuthPolicy auth;

   private final String id;
   private String pseudo;
   private HashMap<String,Object> otherData = null;


   public UWSMCutoutJobOwner(final AuthPolicy auth){
      this.auth = auth;
      this.id = auth.getUserName();
      this.pseudo = this.id;
   }

   public UWSMCutoutJobOwner(final String name){
      this(name, name);
   }

   public UWSMCutoutJobOwner(final String id, final String pseudo){
      this.id = id;
      this.pseudo = pseudo;
   }

   public String[] getGroups(){ return auth.getUserGroups();}

   @Override
   public final String getID(){
      return id;
   }

   @Override
   public final String getPseudo(){
      return pseudo;
   }

   public final void setPseudo(final String pseudo){
      this.pseudo = pseudo;
   }

   /**
    *          * By default: ALL users have the READ permission for ALL jobs lists.
    *                   * @see uws.job.user.JobOwner#hasReadPermission(uws.job.JobList)
    *                            */
   @Override
   public boolean hasReadPermission(JobList jl){
      return true;
   }

   /**
    *          * By default: ALL users have the WRITE permission for ALL jobs lists.
    *                   * @see uws.job.user.JobOwner#hasWritePermission(uws.job.JobList)
    *                            */
   @Override
   public boolean hasWritePermission(JobList jl){
      return true;
   }

   /**
    *          * By default: ONLY owners of the given job have the READ permission.
    *                   * @see uws.job.user.JobOwner#hasReadPermission(uws.job.UWSJob)
    *                            */
   @Override
   public boolean hasReadPermission(UWSJob job){
      return (job == null) || (job.getOwner() == null) || (job.getOwner().equals(this));
   }

   /**
    *          * By default: ONLY owners of the given job have the WRITE permission.
    *                   * @see uws.job.user.JobOwner#hasWritePermission(uws.job.UWSJob)
    *                            */
   @Override
   public boolean hasWritePermission(UWSJob job){
      return (job == null) || (job.getOwner() == null) || (job.getOwner().equals(this));
   }

   /**
    *          * By default: ONLY owners of the given job have the EXECUTE permission.
    *                   * @see uws.job.user.JobOwner#hasExecutePermission(uws.job.UWSJob)
    *                            */
   @Override
   public boolean hasExecutePermission(UWSJob job){
      return (job == null) || (job.getOwner() == null) || (job.getOwner().equals(this));
   }

   public String putUserData(final String name, final String value){
      if (otherData == null)
         otherData = new HashMap<String,Object>();
      return (String)otherData.put(name, value);
   }

   public String getUserData(final String name){
      return (otherData == null) ? null : (String)otherData.get(name);
   }

   public String removeUserData(final String name){
      return (otherData == null) ? null : (String)otherData.remove(name);
   }

   public Set<String> getAllUserData(){
      return (otherData == null) ? null : otherData.keySet();
   }

   @Override
   public Map<String,Object> getDataToSave(){
      return otherData;
   }

   @Override
   public void restoreData(Map<String,Object> data){
      if (data == null || data.isEmpty())
         return;

      if (otherData == null)
         otherData = new HashMap<String,Object>(data.size());

      otherData.putAll(data);
   }

   /**
    *          * By default: the user ID.
    *                   * @see java.lang.Object#toString()
    *                            */
   @Override
   public String toString(){
      return id;
   }

   /**
    *          * By default: a {@link UWSMCutoutJobOwner} is equal to any {@link JobOwner} only if their ID are equals.
    *                   * @see java.lang.Object#equals(java.lang.Object)
    *                            */
   @Override
   public boolean equals(Object obj){
      if (obj == null || !(obj instanceof JobOwner))
         return false;

      String objId = ((JobOwner)obj).getID();
      return (id == null && objId == null) || (id != null && objId != null && id.equals(objId));
   }

   /**
    *          * By default: this function returns the hashCode of the ID.
    *                   * @see java.lang.Object#hashCode()
    *                            */
   @Override
   public int hashCode(){
      return id.hashCode();
   }

}

