/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.image.tile.operation;

import java.nio.Buffer;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import nom.tam.image.tile.operation.AbstractTiledImageOperation;
import nom.tam.image.tile.operation.TileArea;
import nom.tam.image.tile.operation.buffer.TileBuffer;
import nom.tam.util.type.PrimitiveType;

public abstract class AbstractTileOperation<OPERATION extends AbstractTileOperation, IMAGE_OPERATION extends AbstractTiledImageOperation<OPERATION>>
implements Runnable {
    private final IMAGE_OPERATION tiledImageOperation;
    private Future<?> future;
    private TileBuffer tileBuffer;
    private final int tileIndex;
    private final TileArea area;

    public AbstractTileOperation(IMAGE_OPERATION operation, int tileIndex, TileArea area) {
        this.tiledImageOperation = operation;
        this.tileIndex = tileIndex;
        this.area = area;
    }

    public void execute(ExecutorService threadPool) {
        this.future = threadPool.submit(this);
    }

    public TileArea getArea() {
        return this.area;
    }

    public int getPixelSize() {
        return this.tileBuffer.getPixelSize();
    }

    public int getTileIndex() {
        return this.tileIndex;
    }

    public void setWholeImageBuffer(Buffer buffer) {
        this.tileBuffer.setData(buffer);
    }

    public void waitForResult() {
        try {
            this.future.get();
        }
        catch (Exception e) {
            throw new IllegalStateException("could not process tile", e);
        }
    }

    protected PrimitiveType<Buffer> getBaseType() {
        return ((AbstractTiledImageOperation)this.tiledImageOperation).getBaseType();
    }

    protected OPERATION getPreviousTile() {
        return ((AbstractTiledImageOperation)this.tiledImageOperation).getTile(this.getTileIndex() - 1);
    }

    protected TileBuffer getTileBuffer() {
        return this.tileBuffer;
    }

    protected IMAGE_OPERATION getTiledImageOperation() {
        return this.tiledImageOperation;
    }

    protected OPERATION setDimensions(int dataOffset, int width, int height) {
        this.setTileBuffer(TileBuffer.createTileBuffer(this.getBaseType(), dataOffset, ((AbstractTiledImageOperation)this.tiledImageOperation).getImageWidth(), width, height));
        this.area.size(width, height);
        return (OPERATION)this;
    }

    protected void setTileBuffer(TileBuffer tileBuffer) {
        this.tileBuffer = tileBuffer;
    }
}

