#ifndef SQLSURVEY_HPP
#define SQLSURVEY_HPP

#include <string>
#include "colmap.hpp"

#include <pqxx/pqxx>



namespace survey_ns {

enum ColumnId
      {
         name, species, transition,
         rest_frequency, restf_fits_unit, velocity_fits_unit,
         storage_path, file_filter,
         description,
         dataproduct_type, calib_level, o_ucd,
         fitskey_facility_name, fitskey_instrument_name,
         auth_policy
      };
}

class Survey
{
   public:

      Survey(std::string tableName);
      std::string getCREATE();
      std::string getINSERT(std::string surveysPathName);
      std::string qry_SELECT_Attribs(int sid);
      void handleResult(pqxx::result res);

      std::string getStorageFilter(void);
      std::string getObsCollection(void) const;

      // table fields

      double restFrequency;    // FIXME check in which units ? [Hz] [GHz]?

      std::string restFreqFitsUnit; // FIXME enum not string
      std::string velocityFitsUnit; // FIXME enum not string

      std::string storagePath;
      std::string fileFilter;

      std::string survDescription;

      std::string survName;
      std::string survSpecies;
      std::string survTransition;

      std::string dataproductType; // FIXME enum : cube | image
      int calibLevel;
      std::string oUcd;
      std::string fitskeyFacilityName;
      std::string fitskeyInstrumentName;
      std::string authPolicy; // sql_enum FIXME here enum too

   private:

      std::string tabName;
      static colmap<survey_ns::ColumnId,std::string> m_row;
      std::string m_CREATE;

      // utils

      std::string colName(survey_ns::ColumnId cid);
};

#endif

