#ifndef MCUTOUT_HPP
#define MCUTOUT_HPP

#include "cutout.hpp" // coordinates fits_card structs needed
#include "mcutout.hpp"

#include <string>
#include <vector>
#include <cstdint> // FIXME is for uintmax_t - find c++ equivalent


enum class content_type {FILENAME, BAD_REQUEST, SERVICE_ERROR};
std::string to_string(content_type ss);

struct cut_param_s
{
   std::string pubdid;
   coordinates coord;
   bool countNullVals;
   /* resolver adds: */
   std::string filename;
   unsigned int hdunum;
   std::vector<struct fits_card> cards;
};

struct cut_resp_s
{
   cut_param_s input;
   content_type type;
   std::string content;
   /* FIXME misses countNullVals results */
};

struct mcutout_res_s
{
   uintmax_t filesize;
   std::string tgz_filename;
   std::vector<cut_resp_s> responses;
};


struct mcutout_res_s mcutout(std::vector<struct cut_param_s> cut_params,
      const std::string fits_path, const std::string fits_cut_path);


/* mergefiles split (enables to call reproject in parallel) */


void xmergefiles_common_header(
      const std::string merge_id,
      const std::vector<std::string> fitsfiles,
      const std::string dimensionality,
      const std::string merge_dir,
      const std::string result_dir);


void xmergefiles_reproject(
      const std::string merge_id,
      const std::string fitsfilename,
      const std::string dimensionality,
      const std::string merge_dir,
      const std::string result_dir);


unsigned long xmergefiles_add_reprojected(
      const std::string merge_id,
      const std::string dimensionality,
      const std::string merge_dir,
      const std::string result_dir,
      std::string& merged_file_pathname);


/* legacy mergefiles (serial exec) */


unsigned long xmergefiles(
      const std::vector<std::string> fitsfile,
      const std::string dimensionality,
      const std::string merge_dir,
      const std::string result_dir,
      std::string& merged_file_pathname);


#endif

