/*
 * Decompiled with CFR 0.152.
 */
package uws.service.actions;

import java.io.IOException;
import java.util.Enumeration;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import uws.UWSException;
import uws.job.ExecutionPhase;
import uws.job.UWSJob;
import uws.job.serializer.UWSSerializer;
import uws.job.user.JobOwner;
import uws.service.UWSService;
import uws.service.UWSUrl;
import uws.service.actions.UWSAction;
import uws.service.log.UWSLog;
import uws.service.wait.BlockingPolicy;
import uws.service.wait.WaitObserver;

public class JobSummary
extends UWSAction {
    private static final long serialVersionUID = 1L;
    public static final String WAIT_PARAMETER = "WAIT";

    public JobSummary(UWSService u) {
        super(u);
    }

    @Override
    public String getName() {
        return "Get Job";
    }

    @Override
    public String getDescription() {
        return "Lets getting a summary of the specified job. (URL: {baseUWS_URL}/{jobListName}/{job-id}, Method: HTTP-GET, No parameter)";
    }

    @Override
    public boolean match(UWSUrl urlInterpreter, JobOwner user, HttpServletRequest request) throws UWSException {
        return urlInterpreter.hasJobList() && urlInterpreter.hasJob() && !urlInterpreter.hasAttribute() && request.getMethod().equalsIgnoreCase("get");
    }

    @Override
    public boolean apply(UWSUrl urlInterpreter, JobOwner user, HttpServletRequest request, HttpServletResponse response) throws UWSException, IOException {
        UWSJob job = this.getJob(urlInterpreter);
        JobSummary.block(this.uws.getWaitPolicy(), request, job, user);
        UWSSerializer serializer = this.uws.getSerializer(request.getHeader("Accept"));
        response.setContentType(serializer.getMimeType());
        response.setCharacterEncoding("UTF-8");
        try {
            job.serialize(response.getOutputStream(), serializer, user);
        }
        catch (Exception e) {
            if (!(e instanceof UWSException)) {
                this.getLogger().logUWS(UWSLog.LogLevel.ERROR, urlInterpreter, "SERIALIZE", "Can not serialize the job \"" + job.getJobId() + "\"!", e);
                throw new UWSException(500, (Throwable)e, "Can not format properly the job \"" + job.getJobId() + "\"!");
            }
            throw (UWSException)e;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void block(BlockingPolicy policy, HttpServletRequest req, UWSJob job, JobOwner user) {
        block28: {
            if (req == null || job == null) {
                return;
            }
            if (job.getPhase() != ExecutionPhase.PENDING && job.getPhase() != ExecutionPhase.QUEUED && job.getPhase() != ExecutionPhase.EXECUTING) {
                return;
            }
            ExecutionPhase phase = null;
            boolean waitGiven = false;
            long waitingTime = 0L;
            Enumeration parameters = req.getParameterNames();
            while (parameters.hasMoreElements()) {
                int i;
                String param = (String)parameters.nextElement();
                String[] values = req.getParameterValues(param);
                if (param.toUpperCase().equals(WAIT_PARAMETER)) {
                    if (values == null) continue;
                    for (i = 0; i < values.length; ++i) {
                        try {
                            if (values[i] == null || values[i].trim().length() <= 0) continue;
                            long tmp = Long.parseLong(values[i]);
                            if (tmp < 0L && !waitGiven) {
                                waitingTime = tmp;
                            } else if (tmp >= 0L) {
                                waitingTime = waitGiven && waitingTime >= 0L ? Math.min(waitingTime, tmp) : tmp;
                            }
                            waitGiven = true;
                            continue;
                        }
                        catch (NumberFormatException tmp) {
                            // empty catch block
                        }
                    }
                    continue;
                }
                if (!param.toUpperCase().equals("PHASE") || values == null) continue;
                for (i = values.length - 1; phase == null && i >= 0; --i) {
                    try {
                        if (values[i].trim().length() <= 0) continue;
                        phase = ExecutionPhase.valueOf(values[i].toUpperCase());
                        continue;
                    }
                    catch (IllegalArgumentException tmp) {
                        // empty catch block
                    }
                }
            }
            if (waitingTime != 0L && (phase == null || job.getPhase() == phase)) {
                Thread threadToBlock = Thread.currentThread();
                WaitObserver observer = null;
                if (policy != null) {
                    waitingTime = policy.block(threadToBlock, waitingTime, job, user, req);
                }
                if (waitingTime != 0L) {
                    try {
                        observer = new WaitObserver(threadToBlock);
                        job.addObserver(observer);
                        if (job.getPhase() != ExecutionPhase.PENDING && job.getPhase() != ExecutionPhase.QUEUED && job.getPhase() != ExecutionPhase.EXECUTING) break block28;
                        Thread thread = threadToBlock;
                        synchronized (thread) {
                            if (waitingTime > 0L) {
                                threadToBlock.wait(waitingTime * 1000L);
                            } else {
                                threadToBlock.wait();
                            }
                        }
                    }
                    catch (InterruptedException interruptedException) {
                    }
                    finally {
                        if (observer != null) {
                            job.removeObserver(observer);
                        }
                        if (policy != null) {
                            policy.unblocked(threadToBlock, job, user, req);
                        }
                    }
                }
            }
        }
    }
}

